/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.config.LegacyWorldOptions;
import wily.legacy.util.LegacyTipBuilder;

public class TipCommand {
    public static final SuggestionProvider<CommandSourceStack> TIP_PROVIDER = (c, builder) -> {
        ((Map)LegacyWorldOptions.customTips.get()).keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection environment) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"legacyTip").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"item").then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)commandBuildContext)).then(Commands.m_82127_((String)"display").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> TipCommand.sendTip((CommandContext<CommandSourceStack>)commandContext, new Payload(new LegacyTipBuilder().itemIcon(ItemArgument.m_120963_((CommandContext)commandContext, (String)"item").m_120980_(1, true)))))).then(Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> TipCommand.sendTip((CommandContext<CommandSourceStack>)commandContext, new Payload(new LegacyTipBuilder().itemIcon(ItemArgument.m_120963_((CommandContext)commandContext, (String)"item").m_120980_(1, true)), BoolArgumentType.getBool((CommandContext)commandContext, (String)"force")))))))))).then(Commands.m_82127_((String)"entity").then(Commands.m_82129_((String)"entity", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)commandBuildContext, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).then(Commands.m_82127_((String)"display").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> TipCommand.sendTip((CommandContext<CommandSourceStack>)commandContext, new EntityPayload((EntityType)ResourceArgument.m_247713_((CommandContext)commandContext, (String)"entity").m_203334_(), false)))).then(Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> TipCommand.sendTip((CommandContext<CommandSourceStack>)commandContext, new EntityPayload((EntityType)ResourceArgument.m_247713_((CommandContext)commandContext, (String)"entity").m_203334_(), BoolArgumentType.getBool((CommandContext)commandContext, (String)"force")))))))))).then(Commands.m_82127_((String)"custom").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"custom_tip", (ArgumentType)StringArgumentType.string()).suggests(TIP_PROVIDER).then(Commands.m_82127_((String)"add").executes(TipCommand::addCustomTip))).then(Commands.m_82127_((String)"remove").executes(c -> TipCommand.handleCustomTipPresence((CommandContext<CommandSourceStack>)c, ((Map)LegacyWorldOptions.customTips.get())::remove, "legacy.commands.legacyTip.success.remove")))).then(Commands.m_82127_((String)"reset").executes(c -> TipCommand.handleCustomTipPresence((CommandContext<CommandSourceStack>)c, s -> ((Map)LegacyWorldOptions.customTips.get()).put(s, new LegacyTipBuilder()), "legacy.commands.legacyTip.success.reset")))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"modify").then(Commands.m_82127_((String)"item").then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)commandBuildContext)).executes(c -> TipCommand.modifyCustomTip((CommandContext<CommandSourceStack>)c, t -> t.itemIcon(ItemArgument.m_120963_((CommandContext)c, (String)"item").m_120980_(1, false))))))).then(Commands.m_82127_((String)"tip").then(Commands.m_82129_((String)"tip", (ArgumentType)ComponentArgument.m_87114_()).executes(c -> TipCommand.modifyCustomTip((CommandContext<CommandSourceStack>)c, t -> t.tip(ComponentArgument.m_87117_((CommandContext)c, (String)"tip"))))))).then(Commands.m_82127_((String)"title").then(Commands.m_82129_((String)"title", (ArgumentType)ComponentArgument.m_87114_()).executes(c -> TipCommand.modifyCustomTip((CommandContext<CommandSourceStack>)c, t -> t.title(ComponentArgument.m_87117_((CommandContext)c, (String)"title"))))))).then(Commands.m_82127_((String)"time").then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> TipCommand.modifyCustomTip((CommandContext<CommandSourceStack>)c, t -> t.disappearTime(IntegerArgumentType.getInteger((CommandContext)c, (String)"seconds")))))))).then(Commands.m_82127_((String)"display").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> TipCommand.handleCustomTipPresence((CommandContext<CommandSourceStack>)commandContext, s -> TipCommand.sendTip((CommandContext<CommandSourceStack>)commandContext, new Payload((LegacyTipBuilder)((Map)LegacyWorldOptions.customTips.get()).get(s)))))).then(Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> TipCommand.handleCustomTipPresence((CommandContext<CommandSourceStack>)commandContext, s -> TipCommand.sendTip((CommandContext<CommandSourceStack>)commandContext, new Payload((LegacyTipBuilder)((Map)LegacyWorldOptions.customTips.get()).get(s), BoolArgumentType.getBool((CommandContext)commandContext, (String)"force")))))))))));
    }

    private static <T extends CommonNetwork.Payload> int sendTip(CommandContext<CommandSourceStack> context, T packet) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91471_(context, (String)"targets");
        CommonNetwork.sendToPlayers((Collection)players, packet);
        return players.size();
    }

    private static int addCustomTip(CommandContext<CommandSourceStack> context) {
        return TipCommand.handleCustomTip(context, s -> ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"legacy.commands.legacyTip.invalidName", (Object[])new Object[]{s})), s -> {
            ((Map)LegacyWorldOptions.customTips.get()).put(s, new LegacyTipBuilder());
            LegacyWorldOptions.customTips.save();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"legacy.commands.legacyTip.success.add", (Object[])new Object[]{s}), true);
        });
    }

    private static int handleCustomTipPresence(CommandContext<CommandSourceStack> context, CommandConsumer<String> consumer) {
        return TipCommand.handleCustomTip(context, consumer, s -> ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"legacy.commands.legacyTip.incorrectName", (Object[])new Object[]{s})));
    }

    private static int handleCustomTipPresence(CommandContext<CommandSourceStack> context, CommandConsumer<String> modifier, String successKey) {
        return TipCommand.handleCustomTipPresence(context, s -> {
            modifier.accept((String)s);
            LegacyWorldOptions.customTips.save();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)successKey, (Object[])new Object[]{s}), true);
        });
    }

    private static int modifyCustomTip(CommandContext<CommandSourceStack> context, CommandConsumer<LegacyTipBuilder> modifier) {
        return TipCommand.handleCustomTip(context, s -> {
            modifier.accept((LegacyTipBuilder)((Map)LegacyWorldOptions.customTips.get()).get(s));
            LegacyWorldOptions.customTips.save();
        }, s -> ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"legacy.commands.legacyTip.incorrectName", (Object[])new Object[]{s})));
    }

    private static int handleCustomTip(CommandContext<CommandSourceStack> context, CommandConsumer<String> presence, CommandConsumer<String> absence) {
        String tip = StringArgumentType.getString(context, (String)"custom_tip");
        if (((Map)LegacyWorldOptions.customTips.get()).containsKey(tip)) {
            presence.accept(tip);
        } else {
            absence.accept(tip);
        }
        return 1;
    }

    static interface CommandConsumer<T>
    extends Consumer<T> {
        @Override
        default public void accept(T t) {
            try {
                this.acceptExceptionally(t);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public void acceptExceptionally(T var1) throws CommandSyntaxException;
    }

    public record Payload(LegacyTipBuilder builder, boolean force) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<Payload> ID = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("send_tip"), Payload::decode);

        public Payload(LegacyTipBuilder builder) {
            this(builder, false);
        }

        public static Payload decode(CommonNetwork.PlayBuf buf) {
            return new Payload(LegacyTipBuilder.decode(buf), ((FriendlyByteBuf)buf.get()).readBoolean());
        }

        public void encode(CommonNetwork.PlayBuf buf) {
            this.builder.encode(buf);
            ((FriendlyByteBuf)buf.get()).writeBoolean(this.force);
        }

        public void apply(CommonNetwork.SecureExecutor executor, Supplier<Player> player) {
            if (player.get().m_9236_().f_46443_) {
                if (this.force) {
                    LegacyTipManager.setTip(LegacyTipManager.getTip(this.builder.getItem(), this.builder));
                } else {
                    LegacyTipManager.addTip(LegacyTipManager.getTip(this.builder.getItem(), this.builder));
                }
            }
        }

        public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
            return ID;
        }
    }

    public record EntityPayload(EntityType<?> entityType, boolean force) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<EntityPayload> ID = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("send_entity_tip"), EntityPayload::new);

        public EntityPayload(CommonNetwork.PlayBuf buf) {
            this((EntityType)FactoryAPIPlatform.getRegistryValue((ResourceLocation)((FriendlyByteBuf)buf.get()).m_130281_(), (Registry)BuiltInRegistries.f_256780_), ((FriendlyByteBuf)buf.get()).readBoolean());
        }

        public void encode(CommonNetwork.PlayBuf buf) {
            ((FriendlyByteBuf)buf.get()).m_130085_(BuiltInRegistries.f_256780_.m_7981_(this.entityType));
            ((FriendlyByteBuf)buf.get()).writeBoolean(this.force);
        }

        public void apply(CommonNetwork.SecureExecutor executor, Supplier<Player> player) {
            if (player.get().m_9236_().f_46443_) {
                if (this.force) {
                    LegacyTipManager.setTip(LegacyTipManager.getTip(this.entityType));
                } else {
                    LegacyTipManager.addTip(this.entityType);
                }
            }
        }

        public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
            return ID;
        }
    }
}

