/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1743;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1821;
import net.minecraft.class_1826;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_243;
import net.minecraft.class_2530;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2969;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_3956;
import net.minecraft.class_5328;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9282;
import net.minecraft.class_9307;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.config.FactoryMixinToggle;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.legacy.Legacy4JClient;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.config.LegacyMixinToggles;
import wily.legacy.config.LegacyWorldOptions;
import wily.legacy.entity.LegacyPlayerInfo;
import wily.legacy.init.LegacyGameRules;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.network.ClientAdvancementsPayload;
import wily.legacy.network.ClientAnimalInLoveSyncPayload;
import wily.legacy.network.ClientEffectActivationPayload;
import wily.legacy.network.ClientMerchantTradingPayload;
import wily.legacy.network.PlayerInfoSync;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.network.ServerOpenClientMenuPayload;
import wily.legacy.network.ServerPlayerMissHitPayload;
import wily.legacy.network.TipCommand;
import wily.legacy.network.TopMessage;
import wily.legacy.util.ArmorStandPose;

public class Legacy4J {
    public static final String MOD_ID = "legacy";
    public static final Supplier<String> VERSION = () -> FactoryAPIPlatform.getModInfo((String)MOD_ID).getVersion();
    public static final Logger LOGGER = LogManager.getLogger((String)"legacy");
    public static final FactoryConfig.StorageHandler MIXIN_CONFIGS_STORAGE = FactoryConfig.StorageHandler.fromMixin((FactoryMixinToggle.Storage)LegacyMixinToggles.COMMON_STORAGE, (boolean)true);
    private static Collection<CommonNetwork.Payload> playerInitialPayloads = Collections.emptySet();

    public Legacy4J() {
        Legacy4J.init();
    }

    public static List<Integer> getParsedVersion(String version) {
        String[] versions;
        ArrayList<Integer> parsedVersion = new ArrayList<Integer>();
        for (String s : versions = version.split("[.\\-]")) {
            int value;
            try {
                value = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            parsedVersion.add(value);
        }
        return parsedVersion;
    }

    public static boolean isNewerVersion(String actualVersion, String previous) {
        return Legacy4J.isNewerVersion(actualVersion, previous, 2);
    }

    public static boolean isNewerVersion(String actualVersion, String previous, int limitCount) {
        List<Integer> v = Legacy4J.getParsedVersion(actualVersion);
        List<Integer> v1 = Legacy4J.getParsedVersion(previous);
        int size = limitCount <= 0 ? v.size() : Math.min(limitCount, v.size());
        for (int i = 0; i < size; ++i) {
            if (v.get(i) <= (v1.size() <= i ? 0 : v1.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void init() {
        FactoryConfig.registerCommonStorage((class_2960)Legacy4J.createModLocation("common"), (FactoryConfig.StorageHandler)LegacyCommonOptions.COMMON_STORAGE);
        FactoryConfig.registerCommonStorage((class_2960)Legacy4J.createModLocation("mixin_common"), (FactoryConfig.StorageHandler)MIXIN_CONFIGS_STORAGE);
        LegacyRegistries.register();
        LegacyGameRules.init();
        FactoryEvent.registerPayload(r -> {
            r.register(false, ClientAdvancementsPayload.ID);
            r.register(false, ClientAnimalInLoveSyncPayload.ID);
            r.register(false, ClientEffectActivationPayload.ID);
            r.register(true, ClientMerchantTradingPayload.ID_C2S);
            r.register(false, ClientMerchantTradingPayload.ID_S2C);
            r.register(true, PlayerInfoSync.ID);
            r.register(true, PlayerInfoSync.All.ID_C2S);
            r.register(false, PlayerInfoSync.All.ID_S2C);
            r.register(true, ServerMenuCraftPayload.ID);
            r.register(true, ServerOpenClientMenuPayload.ID);
            r.register(true, ServerPlayerMissHitPayload.ID);
            r.register(false, TipCommand.Payload.ID);
            r.register(false, TipCommand.EntityPayload.ID);
            r.register(false, TopMessage.Payload.ID);
        });
        ArmorStandPose.init();
        FactoryEvent.setItemComponent((class_1792)class_1802.field_17534, (class_9331)class_9334.field_50071, (Object)64);
        FactoryEvent.registerCommands((dispatcher, context, selection) -> TipCommand.register((CommandDispatcher<class_2168>)dispatcher, context, selection));
        FactoryEvent.setup(Legacy4J::setup);
        FactoryEvent.tagsLoaded(Legacy4J::tagsLoaded);
        FactoryEvent.serverStarted(Legacy4J::onServerStart);
        FactoryEvent.PlayerEvent.JOIN_EVENT.register(Legacy4J::onServerPlayerJoin);
        FactoryEvent.PlayerEvent.RELOAD_RESOURCES_EVENT.register(Legacy4J::onResourcesReload);
    }

    public static class_2960 createModLocation(String path) {
        return FactoryAPI.createLocation((String)MOD_ID, (String)path);
    }

    public static class_1269 defaultPassInteraction() {
        return class_1269.field_5811;
    }

    public static class_1269 successInteraction() {
        return class_1269.field_5812;
    }

    public static class_1269 consumeInteraction() {
        return class_1269.field_21466;
    }

    public static void setup() {
        LegacyCommonOptions.COMMON_STORAGE.load();
        CommonRecipeManager.addRecipeTypeToSync((class_3956)class_3956.field_17545);
        CommonRecipeManager.addRecipeTypeToSync((class_3956)class_3956.field_17641);
        if (!((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
            return;
        }
        Map emptyCauldron = class_5620.field_27775.comp_1982();
        Map waterCauldron = class_5620.field_27776.comp_1982();
        class_5620 emptyCauldronPotion = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            class_6880 p = ((class_1844)itemStack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).comp_2378().orElse(null);
            if (p == null) {
                return Legacy4J.defaultPassInteraction();
            }
            level.method_8501(blockPos, class_2246.field_27097.method_9564());
            level.method_35230(blockPos, (class_2591)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get()).ifPresent(be -> {
                be.potion = p;
                be.lastPotionItemUsed = itemStack.method_41409();
                be.method_5431();
            });
            if (!level.field_9236) {
                class_1792 item = itemStack.method_7909();
                player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8469)));
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                level.method_8396(null, blockPos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
                level.method_33596(null, (class_6880)class_5712.field_28166, blockPos);
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        };
        emptyCauldron.put(class_1802.field_8574, emptyCauldronPotion);
        emptyCauldron.put(class_1802.field_8436, emptyCauldronPotion);
        emptyCauldron.put(class_1802.field_8150, emptyCauldronPotion);
        waterCauldron.put(class_1802.field_8469, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            Optional opt = level.method_35230(blockPos, (class_2591)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
            if (opt.isEmpty() || opt.map(be -> be.waterColor).orElse(null) != null) {
                return Legacy4J.defaultPassInteraction();
            }
            if (!level.field_9236) {
                class_1792 item = itemStack.method_7909();
                player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)Legacy4J.setItemStackPotion(new class_1799(((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).lastPotionItemUsed), ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion)));
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                class_5556.method_31650((class_2680)blockState, (class_1937)level, (class_2338)blockPos);
                level.method_8396(null, blockPos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
                level.method_33596(null, (class_6880)class_5712.field_28167, blockPos);
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        });
        class_5620 waterCauldronPotion = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            Optional opt = level.method_35230(blockPos, (class_2591)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
            class_6880 p = ((class_1844)itemStack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).comp_2378().orElse(null);
            if (p == null || (Integer)blockState.method_11654((class_2769)class_5556.field_27206) == 3 && (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion.equals((Object)p))) {
                return Legacy4J.defaultPassInteraction();
            }
            if (opt.isPresent() && !((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion.equals((Object)p)) {
                level.method_8501(blockPos, class_2246.field_10593.method_9564());
                if (!((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).potion.equals((Object)p)) {
                    level.method_8396(null, blockPos, (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15245, 1.0f, 1.0f);
                }
            } else {
                if (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor == null) {
                    level.method_8501(blockPos, (class_2680)blockState.method_28493((class_2769)class_5556.field_27206));
                } else {
                    ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor = null;
                    level.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(1)));
                    ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).method_5431();
                }
                ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).lastPotionItemUsed = itemStack.method_41409();
                level.method_8396(null, blockPos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
            }
            if (!level.field_9236) {
                player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8469)));
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
                level.method_33596(null, (class_6880)class_5712.field_28166, blockPos);
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        };
        waterCauldron.put(class_1802.field_8574, waterCauldronPotion);
        waterCauldron.put(class_1802.field_8436, waterCauldronPotion);
        waterCauldron.put(class_1802.field_8150, waterCauldronPotion);
        waterCauldron.put(class_1802.field_8107, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            WaterCauldronBlockEntity be;
            class_2586 patt0$temp = level.method_8321(blockPos);
            if (!(patt0$temp instanceof WaterCauldronBlockEntity) || (be = (WaterCauldronBlockEntity)patt0$temp).hasWater()) {
                return Legacy4J.defaultPassInteraction();
            }
            if (!level.field_9236) {
                int l = (Integer)blockState.method_11654((class_2769)class_5556.field_27206);
                int arrowCount = Math.min(itemStack.method_7947(), l < 3 ? l * 16 : 64);
                itemStack.method_57008(arrowCount, (class_1309)player);
                class_1799 tippedArrow = Legacy4J.setItemStackPotion(new class_1799((class_1935)class_1802.field_8087, arrowCount), be.potion);
                player.method_31548().method_7398(tippedArrow);
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
                int i = (int)Math.min(3.0, Math.ceil((double)arrowCount / 16.0));
                class_2680 blockState2 = l - i == 0 ? class_2246.field_10593.method_9564() : (class_2680)blockState.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(i));
                level.method_8501(blockPos, blockState2);
                level.method_43276((class_6880)class_5712.field_28733, blockPos, class_5712.class_7397.method_43287((class_2680)blockState2));
                return Legacy4J.consumeInteraction();
            }
            return Legacy4J.successInteraction();
        });
        for (class_1767 color : class_1767.values()) {
            waterCauldron.put(class_1769.method_7803((class_1767)color), (blockState, level, blockPos, player, interactionHand, itemStack) -> {
                Optional opt = level.method_35230(blockPos, (class_2591)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
                if (!(itemStack.method_7909() instanceof class_1769) || opt.isEmpty() || !((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).hasWater()) {
                    return Legacy4J.defaultPassInteraction();
                }
                int dyeColor = Legacy4J.getDyeColor(color);
                ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor = ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor == null ? Integer.valueOf(dyeColor) : Integer.valueOf(Legacy4J.mixColors(List.of(((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).waterColor, Integer.valueOf(dyeColor)).iterator()));
                ((WaterCauldronBlockEntity)((Object)((Object)opt.get()))).method_5431();
                return level.field_9236 ? Legacy4J.successInteraction() : Legacy4J.consumeInteraction();
            });
        }
        class_2315.method_10009((class_1935)class_2246.field_10375, (class_2357)new class_2969(){

            protected class_1799 method_10135(class_2342 blockSource, class_1799 itemStack) {
                this.method_27955(blockSource.comp_1967().method_64395().method_8355(LegacyGameRules.TNT_EXPLODES));
                if (this.method_27954()) {
                    class_2338 blockPos = blockSource.comp_1968().method_10093((class_2350)blockSource.comp_1969().method_11654((class_2769)class_2315.field_10918));
                    class_2530.method_10738((class_1937)blockSource.comp_1967(), (class_2338)blockPos);
                    blockSource.comp_1967().method_33596(null, (class_6880)class_5712.field_28738, blockSource.comp_1968());
                    itemStack.method_7934(1);
                }
                return itemStack;
            }

            protected void method_10133(class_2342 blockSource, class_2350 direction) {
                if (this.method_27954()) {
                    super.method_10133(blockSource, direction);
                }
            }
        });
        class_2347 defaultDispenseItemBehavior = new class_2347(){

            public class_1799 method_10135(class_2342 blockSource, class_1799 itemStack) {
                class_2350 direction = (class_2350)blockSource.comp_1969().method_11654((class_2769)class_2315.field_10918);
                class_1299 entityType = ((class_1826)itemStack.method_7909()).method_8015(itemStack);
                try {
                    if (entityType.method_5894(blockSource.comp_1967(), itemStack, null, blockSource.comp_1968().method_10093(direction), class_3730.field_16470, direction != class_2350.field_11036, false) != null) {
                        itemStack.method_7934(1);
                        blockSource.comp_1967().method_33596(null, (class_6880)class_5712.field_28738, blockSource.comp_1968());
                    }
                }
                catch (Exception var6) {
                    field_34020.error("Error while dispensing spawn egg from dispenser at {}", (Object)blockSource.comp_1968(), (Object)var6);
                    return class_1799.field_8037;
                }
                return itemStack;
            }
        };
        for (class_1826 spawnEggItem : class_1826.method_8017()) {
            class_2315.method_10009((class_1935)spawnEggItem, (class_2357)defaultDispenseItemBehavior);
        }
    }

    public static boolean isChunkPosVisibleInSquare(int centerX, int centerZ, int viewDistance, int x, int z, boolean offset) {
        int n = Math.max(0, Math.abs(x - centerX) - 1);
        int o = Math.max(0, Math.abs(z - centerZ) - 1);
        long p = Math.max(0, Math.max(n, o) - (offset ? 1 : 0));
        long q = Math.min(n, o);
        return Math.max(p, q) < (long)viewDistance;
    }

    public static class_1799 setItemStackPotion(class_1799 stack, class_6880<class_1842> potion) {
        stack.method_57379(class_9334.field_49651, (Object)new class_1844(potion));
        return stack;
    }

    public static void addPotionTooltip(class_6880<class_1842> potion, List<class_2561> tooltipList, float f, float tickRate) {
        class_1844.method_8065((Iterable)((class_1842)potion.comp_349()).method_8049(), tooltipList::add, (float)f, (float)tickRate);
    }

    public static int getDyeColor(class_1767 dyeColor) {
        return dyeColor.method_7787();
    }

    public static float getItemDamageModifier(class_1799 stack) {
        if (FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat)) {
            if (stack.method_31573(class_3489.field_42611)) {
                return 1.0f;
            }
            if (stack.method_7909() instanceof class_1821) {
                return -0.5f;
            }
            if (stack.method_31573(class_3489.field_42614)) {
                return 1.0f;
            }
            if (stack.method_7909() instanceof class_1743) {
                if (stack.method_31574(class_1802.field_8062)) {
                    return -4.0f;
                }
                if (stack.method_31574(class_1802.field_8556) || stack.method_31574(class_1802.field_22025)) {
                    return -2.0f;
                }
                return -3.0f;
            }
        }
        return 0.0f;
    }

    public static void tagsLoaded() {
        Legacy4J.registerDyedWaterCauldronInteraction(class_5620.field_27776.comp_1982());
    }

    public static void registerDyedWaterCauldronInteraction(Map<class_1792, class_5620> waterCauldron) {
        if (!((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
            return;
        }
        class_7923.field_41178.method_40295().forEach(i -> {
            if (!Legacy4J.isDyeableItem((class_6880<class_1792>)i)) {
                return;
            }
            waterCauldron.put((class_1792)i.comp_349(), (blockState, level, blockPos, player, interactionHand, itemStack) -> {
                Optional opt = level.method_35230(blockPos, (class_2591)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get());
                if (opt.isPresent() && !((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).hasWater() || itemStack.method_57824(class_9334.field_49644) == null && (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).waterColor == null)) {
                    return Legacy4J.defaultPassInteraction();
                }
                if (!level.field_9236) {
                    player.method_7281(class_3468.field_15373);
                    player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
                    if (opt.isEmpty() || ((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).waterColor == null) {
                        itemStack.method_57379(class_9334.field_49644, null);
                    } else {
                        Legacy4J.dyeItem(itemStack, ((WaterCauldronBlockEntity)((Object)((Object)((Object)opt.get())))).waterColor);
                    }
                    class_5556.method_31650((class_2680)blockState, (class_1937)level, (class_2338)blockPos);
                }
                return Legacy4J.successInteraction();
            });
        });
    }

    public static class_243 getRelativeMovement(class_1309 entity, float f, class_243 vec3, int relRot) {
        double d = (vec3 = Legacy4J.getNormal(vec3, Math.toRadians(relRot))).method_1027();
        if (d < 1.0E-7) {
            return class_243.field_1353;
        }
        class_243 vec32 = (d > 1.0 ? vec3.method_1029() : vec3).method_1021((double)f);
        double angle = Math.toRadians(relRot == 0 ? (double)entity.method_36454() : (double)(Math.round(entity.method_36454() / (float)relRot) * relRot));
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        return new class_243(vec32.field_1352 * cos - vec32.field_1350 * sin, vec32.field_1351, vec32.field_1350 * cos + vec32.field_1352 * sin);
    }

    public static class_243 getNormal(class_243 vec3, double relRot) {
        if (relRot == 0.0) {
            return vec3;
        }
        double angleRad = Math.atan2(vec3.field_1350, vec3.field_1352);
        double quantizedAngle = (double)Math.round(angleRad / relRot) * relRot;
        double length = vec3.method_1033();
        return new class_243(length * Math.cos(quantizedAngle), vec3.field_1351, length * Math.sin(quantizedAngle));
    }

    public static boolean canRepair(class_1799 repairItem, class_1799 ingredient) {
        return repairItem.method_31574(ingredient.method_7909()) && repairItem.method_7947() == 1 && ingredient.method_7947() == 1 && repairItem.method_7909().method_57347().method_57832(class_9334.field_49629) && !repairItem.method_7942() && !ingredient.method_7942();
    }

    public static boolean isDyeableItem(class_6880<class_1792> item) {
        return item.method_40220(class_3489.field_48803);
    }

    public static class_1799 dyeItem(class_1799 itemStack, int color) {
        boolean bl;
        ArrayList<Integer> colors = new ArrayList<Integer>();
        class_9282 dyedItemColor = (class_9282)itemStack.method_57824(class_9334.field_49644);
        boolean bl2 = bl = dyedItemColor == null || dyedItemColor.comp_2385();
        if (dyedItemColor != null) {
            colors.add(color);
        }
        colors.add(color);
        itemStack.method_57379(class_9334.field_49644, (Object)new class_9282(Legacy4J.mixColors(colors.iterator()), bl));
        return itemStack;
    }

    public static int mixColors(Iterator<Integer> colors) {
        float h;
        int[] is = new int[3];
        int i = 0;
        int j = 0;
        Iterator<Integer> it = colors;
        while (it.hasNext()) {
            Integer color = it.next();
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            h = (float)(color & 0xFF) / 255.0f;
            i += (int)(Math.max(f, Math.max(g, h)) * 255.0f);
            is[0] = is[0] + (int)(f * 255.0f);
            is[1] = is[1] + (int)(g * 255.0f);
            is[2] = is[2] + (int)(h * 255.0f);
            ++j;
        }
        int k = is[0] / j;
        int o = is[1] / j;
        int p = is[2] / j;
        h = (float)i / (float)j;
        float q = Math.max(k, Math.max(o, p));
        k = (int)((float)k * h / q);
        o = (int)((float)o * h / q);
        p = (int)((float)p * h / q);
        int n = k;
        n = (n << 8) + o;
        n = (n << 8) + p;
        return n;
    }

    public static boolean itemHasValidPatterns(class_1799 stack) {
        int count = Legacy4J.getItemPatternsCount(stack);
        return count > 0 && count <= 6;
    }

    public static int getItemPatternsCount(class_1799 stack) {
        return ((class_9307)stack.method_57825(class_9334.field_49619, (Object)class_9307.field_49404)).comp_2428().size();
    }

    public static boolean anyArmorSlotMatch(class_1661 inventory, Predicate<class_1799> predicate) {
        return inventory.field_7548.stream().anyMatch(predicate);
    }

    public static void onServerPlayerJoin(class_3222 p) {
        if (p.method_5682() == null) {
            return;
        }
        int pos = 0;
        boolean b = true;
        block0: while (b) {
            b = false;
            for (class_3222 player : p.field_13995.method_3760().method_14571()) {
                if (player == p || ((LegacyPlayerInfo)player).getIdentifierIndex() != pos) continue;
                ++pos;
                b = true;
                continue block0;
            }
        }
        ((LegacyPlayerInfo)p).setIdentifierIndex(pos);
        CommonNetwork.sendToPlayers((Collection)p.method_5682().method_3760().method_14571().stream().filter(sp -> sp != p).collect(Collectors.toSet()), (CommonNetwork.Payload)new PlayerInfoSync.All(Map.of(p.method_5667(), (LegacyPlayerInfo)p), Collections.emptyMap(), p.field_13995.method_3790(), PlayerInfoSync.All.ID_S2C));
        CommonNetwork.sendToPlayer((class_3222)p, (CommonNetwork.Payload)PlayerInfoSync.All.fromPlayerList(p.method_5682()), (boolean)true);
        playerInitialPayloads.forEach(payload -> CommonNetwork.sendToPlayer((class_3222)p, (CommonNetwork.Payload)payload, (boolean)true));
        if (!p.field_13995.method_3816()) {
            Legacy4JClient.serverPlayerJoin(p);
        }
    }

    public static void onServerStart(MinecraftServer server) {
        playerInitialPayloads = Legacy4J.createPlayerInitialPayloads(server);
        LegacyWorldOptions.WORLD_STORAGE.withServerFile(server, "legacy_data.json").load();
    }

    public static void onResourcesReload(class_3324 playerList) {
        Legacy4J.onServerStart(playerList.method_14561());
        playerInitialPayloads.forEach(payload -> CommonNetwork.sendToPlayers((Collection)playerList.method_14571(), (CommonNetwork.Payload)payload));
    }

    public static Collection<CommonNetwork.Payload> createPlayerInitialPayloads(MinecraftServer server) {
        HashSet<CommonNetwork.Payload> payloads = new HashSet<CommonNetwork.Payload>();
        payloads.add(new ClientAdvancementsPayload(List.copyOf(server.method_3851().method_12893())));
        return payloads;
    }

    public static void copySaveToDirectory(InputStream stream, File directory) {
        if (directory.exists()) {
            FileUtils.deleteQuietly((File)directory);
        }
        try (ZipInputStream inputStream = new ZipInputStream(stream);){
            ZipEntry zipEntry;
            byte[] buffer = new byte[1024];
            while ((zipEntry = inputStream.getNextEntry()) != null) {
                int len;
                File newFile = new File(directory, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (newFile.isDirectory() || newFile.mkdirs()) continue;
                    throw new IOException("Failed to create directory " + String.valueOf(newFile));
                }
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + String.valueOf(parent));
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = inputStream.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

