/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Locale;
import net.minecraft.class_2960;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.util.ListMap;
import wily.legacy.client.CommonValue;

public class CommonColor
extends CommonValue<Integer> {
    public static final Codec<Integer> RGBA_INT_COLOR_CODEC = Codec.STRING.comapFlatMap(string -> {
        if (!string.startsWith("#")) {
            return DataResult.error(() -> "Not a color code: " + string);
        }
        try {
            int i = (int)Long.parseLong(string.substring(1), 16);
            return DataResult.success((Object)i);
        }
        catch (NumberFormatException var2) {
            return DataResult.error(() -> "Exception parsing color code: " + var2.getMessage());
        }
    }, i -> String.format(Locale.ROOT, "#%08X", i));
    public static final Codec<Integer> INT_COLOR_CODEC = Codec.either(RGBA_INT_COLOR_CODEC, (Codec)Codec.INT).xmap(e -> e.right().orElseGet(e.left()::get), Either::right);
    public static final ListMap<class_2960, CommonColor> COMMON_COLORS = new ListMap();
    public static final CommonColor CHAT_BACKGROUND = CommonColor.registerCommonColor("chat_background", 0x323232);
    public static final CommonColor INVENTORY_GRAY_TEXT = CommonColor.registerCommonColor("inventory_gray_text", 0x323232);
    public static final CommonColor WIDGET_TEXT = CommonColor.registerCommonColor("widget_text", 0xFFFFFF);
    public static final CommonColor HIGHLIGHTED_WIDGET_TEXT = CommonColor.registerCommonColor("highlighted_widget_text", 0xFFFF00);
    public static final CommonColor TITLE_TEXT = CommonColor.registerCommonColor("title_text", 0xFFFFFF);
    public static final CommonColor TITLE_TEXT_OUTLINE = CommonColor.registerCommonColor("title_text_outline", 0);
    public static final CommonColor STAGE_TEXT = CommonColor.registerCommonColor("stage_text", 0xFFFFFF);
    public static final CommonColor TIP_TITLE_TEXT = CommonColor.registerCommonColor("tip_title_text", 0xFFFFFF);
    public static final CommonColor TIP_TEXT = CommonColor.registerCommonColor("tip_text", 0xFFFFFF);
    public static final CommonColor ACTION_TEXT = CommonColor.registerCommonColor("action_text", 0xFFFFFF);
    public static final CommonColor SELECTED_STORAGE_SAVE = CommonColor.registerCommonColor("selected_storage_save", -256);
    public static final CommonColor STORAGE_SAVE = CommonColor.registerCommonColor("storage_save", -7561758);
    public static final CommonColor EXPERIENCE_TEXT = CommonColor.registerCommonColor("experience_text", 8453920);
    public static final CommonColor INSUFFICIENT_EXPERIENCE_TEXT = CommonColor.registerCommonColor("insufficient_experience_text", 13573917);
    public static final CommonColor ANVIL_ERROR_TEXT = CommonColor.registerCommonColor("anvil_error_text", 0xFF6060);
    public static final CommonColor ENCHANTMENT_TEXT = CommonColor.registerCommonColor("enchantment_text", 6839882);
    public static final CommonColor HIGHLIGHTED_ENCHANTMENT_TEXT = CommonColor.registerCommonColor("highlighted_enchantment_text", 0xFFFF80);
    public static final CommonColor BLACK = CommonColor.registerCommonColor("black", 0);
    public static final CommonColor DARK_BLUE = CommonColor.registerCommonColor("dark_blue", 170);
    public static final CommonColor DARK_GREEN = CommonColor.registerCommonColor("dark_green", 43520);
    public static final CommonColor DARK_AQUA = CommonColor.registerCommonColor("dark_aqua", 43690);
    public static final CommonColor DARK_RED = CommonColor.registerCommonColor("dark_red", 0xAA0000);
    public static final CommonColor DARK_PURPLE = CommonColor.registerCommonColor("dark_purple", 0xAA00AA);
    public static final CommonColor GOLD = CommonColor.registerCommonColor("gold", 0xFFAA00);
    public static final CommonColor GRAY = CommonColor.registerCommonColor("gray", 0xAAAAAA);
    public static final CommonColor DARK_GRAY = CommonColor.registerCommonColor("dark_gray", 0x555555);
    public static final CommonColor BLUE = CommonColor.registerCommonColor("blue", 0x7878FF);
    public static final CommonColor GREEN = CommonColor.registerCommonColor("green", 0x55FF55);
    public static final CommonColor AQUA = CommonColor.registerCommonColor("aqua", 0x55FFFF);
    public static final CommonColor RED = CommonColor.registerCommonColor("red", 0xFF5555);
    public static final CommonColor LIGHT_PURPLE = CommonColor.registerCommonColor("light_purple", 0xFF55FF);
    public static final CommonColor YELLOW = CommonColor.registerCommonColor("yellow", 0xFFFF55);
    public static final CommonColor WHITE = CommonColor.registerCommonColor("white", 0xFFFFFF);
    public static final CommonColor BLOCK_LIGHT = CommonColor.registerCommonColor("block_light", 0xFFFFFF);

    public CommonColor(Integer obj) {
        super(obj, INT_COLOR_CODEC);
    }

    public static CommonColor registerCommonColor(String path, int defaultValue) {
        return CommonColor.registerCommonColor(FactoryAPI.createVanillaLocation((String)path), defaultValue);
    }

    public static CommonColor registerCommonColor(class_2960 id, int defaultValue) {
        CommonColor color = new CommonColor(defaultValue);
        COMMON_COLORS.put((Object)id, (Object)color);
        return color;
    }
}

