/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.RegisterListing;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ControlTooltip;

public interface ControlType {
    public static final ListMap<String, ControlType> types = new ListMap();
    public static final List<ControlType> defaultTypes = new ArrayList<ControlType>();
    public static final ControlType KBM = ControlType.createDefault("java", true);
    public static final ControlType x360 = ControlType.createDefault("xbox_360");
    public static final ControlType xONE = ControlType.createDefault("xbox_one");
    public static final ControlType PS3 = ControlType.createDefault("playstation_3");
    public static final ControlType PS4 = ControlType.createDefault("playstation_4");
    public static final ControlType WII_U = ControlType.createDefault("wii_u");
    public static final ControlType SWITCH = ControlType.createDefault("switch");
    public static final ControlType STEAM = ControlType.createDefault("steam");
    public static final ControlType STADIA = ControlType.createDefault("stadia");
    public static final ControlType PSVITA = ControlType.createDefault("playstation_vita");
    public static final ControlType PS5 = ControlType.createDefault("playstation_5");

    public static ControlType createDefault(String name) {
        return ControlType.createDefault(name, false);
    }

    public static ControlType createDefault(String name, boolean kbm) {
        ControlType type = ControlType.create(Legacy4J.createModLocation(name), null, kbm);
        defaultTypes.add(type);
        return type;
    }

    public static ControlType create(class_2960 id, class_2561 displayName, boolean isKbm) {
        return ControlType.create(id, new HashMap<String, ControlTooltip.LegacyIcon>(), (class_2561)(displayName == null ? class_2561.method_43471((String)("legacy.options.controlType." + id.method_12832())) : displayName), class_2583.field_24360.method_27704(id), isKbm, id.method_45136("textures/gui/title/minecraft/%s.png".formatted(id.method_12832())));
    }

    public static ControlType create(final class_2960 id, final Map<String, ControlTooltip.LegacyIcon> map, final class_2561 displayName, final class_2583 style, final boolean isKbm, final class_2960 minecraftLogoLocation) {
        return new ControlType(){

            @Override
            public Map<String, ControlTooltip.LegacyIcon> getIcons() {
                return map;
            }

            @Override
            public boolean isKbm() {
                return isKbm;
            }

            @Override
            public class_2960 getId() {
                return id;
            }

            @Override
            public class_2561 getDisplayName() {
                return displayName;
            }

            @Override
            public class_2583 getStyle() {
                return style;
            }

            @Override
            public class_2960 getMinecraftLogo() {
                return minecraftLogoLocation;
            }
        };
    }

    public static ControlType getActiveControllerType() {
        if (((Holder)LegacyOptions.selectedControlType.get()).isAuto()) {
            if (Legacy4JClient.controllerManager.connectedController != null) {
                return Legacy4JClient.controllerManager.connectedController.getType();
            }
            return x360;
        }
        ControlType type = ((Holder)LegacyOptions.selectedControlType.get()).get();
        return type.isKbm() ? x360 : type;
    }

    public static ControlType getActiveType() {
        return (Boolean)LegacyOptions.lockControlTypeChange.get() == false && Legacy4JClient.controllerManager.isControllerTheLastInput() || (Boolean)LegacyOptions.lockControlTypeChange.get() != false && (Legacy4JClient.controllerManager.connectedController != null && ((Holder)LegacyOptions.selectedControlType.get()).isAuto() || !((Holder)LegacyOptions.selectedControlType.get()).orElse(KBM).isKbm()) ? ControlType.getActiveControllerType() : ControlType.getKbmActiveType();
    }

    public static ControlType getKbmActiveType() {
        if (((Holder)LegacyOptions.selectedControlType.get()).isAuto()) {
            return KBM;
        }
        ControlType type = ((Holder)LegacyOptions.selectedControlType.get()).get();
        return !type.isKbm() ? KBM : type;
    }

    public class_2960 getId();

    public Map<String, ControlTooltip.LegacyIcon> getIcons();

    public boolean isKbm();

    public class_2561 getDisplayName();

    public class_2583 getStyle();

    public class_2960 getMinecraftLogo();

    public static class Holder
    implements RegisterListing.Holder<ControlType> {
        public static final Holder AUTO = new Holder(null){

            @Override
            public ControlType get() {
                return null;
            }

            @Override
            public String toString() {
                return "auto";
            }
        };
        public static final Codec<Holder> CODEC = Codec.STRING.xmap(Holder::parse, Holder::toString);
        private final class_2960 id;
        private ControlType controlType;

        public static Holder parse(String stringId) {
            if (stringId.equals("auto")) {
                return AUTO;
            }
            class_2960 id = FactoryAPI.createLocation((String)stringId);
            return id == null ? AUTO : new Holder(id);
        }

        public static Holder of(final ControlType controlType) {
            return new Holder(controlType.getId()){

                @Override
                public ControlType get() {
                    return controlType;
                }
            };
        }

        public Holder(class_2960 id) {
            this.id = id;
        }

        public boolean isAuto() {
            return this.get() == null;
        }

        public ControlType orElse(ControlType alternative) {
            ControlType controlType = this.get();
            return controlType == null ? alternative : controlType;
        }

        public boolean equals(Object obj) {
            Holder h;
            return obj instanceof Holder && (h = (Holder)obj).get() == this.get();
        }

        public class_2960 getId() {
            return this.id;
        }

        public String toString() {
            return this.id.toString();
        }

        public ControlType get() {
            return this.controlType == null ? (this.controlType = (ControlType)types.get((Object)this.id.toString())) : this.controlType;
        }
    }

    public static interface UpdateEvent {
        public static final FactoryEvent<UpdateEvent> EVENT = new FactoryEvent(e -> (last, actual) -> e.invokeAll(l -> l.change(last, actual)));

        public void change(ControlType var1, ControlType var2);
    }
}

