/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.slf4j.Logger;
import wily.factoryapi.FactoryAPI;

public class KnownListing<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path path;
    public final List<class_2960> list = new ArrayList<class_2960>();
    private final class_2378<T> registry;
    private final String listingFile;

    public KnownListing(class_2378<T> registry, Path path) {
        this.registry = registry;
        this.listingFile = "known_" + this.registry.method_46765().method_29177().method_12832() + ".json";
        this.path = path.resolve(this.listingFile);
        if (Files.exists(this.path, new LinkOption[0])) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(this.path, Charsets.UTF_8);){
                JsonArray array = class_3518.method_37165((Reader)bufferedReader);
                array.forEach(e -> {
                    JsonPrimitive p;
                    if (e instanceof JsonPrimitive && (p = (JsonPrimitive)e).isString()) {
                        this.list.add(FactoryAPI.createLocation((String)p.getAsString()));
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.error("Failed to read {}, known " + this.registry.method_46765().method_29177().method_12832() + " will be reset", (Object)this.listingFile, (Object)exception);
            }
        }
    }

    public boolean contains(T obj) {
        return this.list.contains(this.registry.method_10221(obj));
    }

    public void add(T obj) {
        if (!this.contains(obj)) {
            this.list.add(this.registry.method_10221(obj));
        }
    }

    public void save() {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.path, Charsets.UTF_8, new OpenOption[0]);){
            JsonArray a = new JsonArray();
            this.list.forEach(l -> a.add(l.toString()));
            class_3518.method_43677((JsonWriter)new JsonWriter((Writer)bufferedWriter), (JsonElement)a, String::compareTo);
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to write {}, new known " + this.registry.method_46765().method_29177().method_12832() + " won't be present", (Object)this.listingFile, (Object)iOException);
        }
    }
}

