/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import net.minecraft.class_5321;
import wily.factoryapi.FactoryAPI;
import wily.legacy.Legacy4J;
import wily.legacy.util.JsonUtil;

public class LegacyBiomeOverride {
    public static final Map<class_2960, LegacyBiomeOverride> map = new HashMap<class_2960, LegacyBiomeOverride>();
    private static final String BIOME_OVERRIDES = "biome_overrides.json";
    public static final class_2960 DEFAULT_LOCATION = FactoryAPI.createVanillaLocation((String)"default");
    private class_1799 icon = class_1799.field_8037;
    Integer waterColor;
    Integer waterFogColor;
    Integer fogColor;
    Integer skyColor;
    Float waterTransparency;
    Float waterFogDistance;

    public static LegacyBiomeOverride getDefault() {
        return map.get(DEFAULT_LOCATION);
    }

    public static LegacyBiomeOverride getOrDefault(Optional<class_5321<class_1959>> optionalKey) {
        return optionalKey.isEmpty() ? LegacyBiomeOverride.getDefault() : LegacyBiomeOverride.getOrDefault(optionalKey.get().method_29177());
    }

    public static LegacyBiomeOverride getOrDefault(class_2960 location) {
        return map.getOrDefault(location, LegacyBiomeOverride.getDefault());
    }

    public class_1799 icon() {
        return this.icon;
    }

    public float waterTransparency() {
        return this.waterTransparency == null ? LegacyBiomeOverride.getDefault().waterTransparency() : this.waterTransparency.floatValue();
    }

    public Integer waterColor() {
        return this.waterColor == null ? LegacyBiomeOverride.getDefault().waterColor : this.waterColor;
    }

    public int getWaterARGBOrDefault(int defaultColor) {
        return (int)(this.waterTransparency() * 255.0f) << 24 | (this.waterColor() == null ? defaultColor : this.waterColor()) & 0xFFFFFF;
    }

    public Integer waterFogColor() {
        return this.waterFogColor == null ? LegacyBiomeOverride.getDefault().waterFogColor : this.waterFogColor;
    }

    public Integer fogColor() {
        return this.fogColor == null ? LegacyBiomeOverride.getDefault().fogColor : this.fogColor;
    }

    public Integer skyColor() {
        return this.skyColor == null ? LegacyBiomeOverride.getDefault().skyColor : this.skyColor;
    }

    public Float waterFogDistance() {
        return this.waterFogDistance == null ? LegacyBiomeOverride.getDefault().waterFogDistance : this.waterFogDistance;
    }

    public static class Manager
    implements class_4013 {
        public void method_14491(class_3300 resourceManager) {
            map.clear();
            map.put(DEFAULT_LOCATION, new LegacyBiomeOverride(this){

                @Override
                public float waterTransparency() {
                    return this.waterTransparency == null ? 1.0f : this.waterTransparency.floatValue();
                }
            });
            JsonUtil.getOrderedNamespaces(resourceManager).forEach(name -> resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)LegacyBiomeOverride.BIOME_OVERRIDES)).ifPresent(r -> {
                try {
                    BufferedReader bufferedReader = r.method_43039();
                    JsonObject obj = class_3518.method_15255((Reader)bufferedReader);
                    JsonElement ioElement = obj.get("overrides");
                    if (ioElement instanceof JsonObject) {
                        JsonObject jsonObject = (JsonObject)ioElement;
                        jsonObject.asMap().forEach((s, e) -> {
                            if (e instanceof JsonObject) {
                                JsonElement patt1$temp;
                                JsonPrimitive p;
                                JsonElement patt0$temp;
                                JsonObject o = (JsonObject)e;
                                LegacyBiomeOverride override = map.computeIfAbsent(FactoryAPI.createLocation((String)s), resourceLocation -> new LegacyBiomeOverride());
                                JsonUtil.getItemFromJson((JsonElement)o, true).ifPresent(i -> {
                                    override.icon = i;
                                });
                                Integer i2 = JsonUtil.optionalJsonColor(o, "water_color", null);
                                if (i2 != null) {
                                    override.waterColor = i2;
                                }
                                if ((i2 = JsonUtil.optionalJsonColor(o, "water_fog_color", null)) != null) {
                                    override.waterFogColor = i2;
                                }
                                if ((i2 = JsonUtil.optionalJsonColor(o, "fog_color", null)) != null) {
                                    override.fogColor = i2;
                                }
                                if ((i2 = JsonUtil.optionalJsonColor(o, "sky_color", null)) != null) {
                                    override.skyColor = i2;
                                }
                                if ((patt0$temp = o.get("water_fog_distance")) instanceof JsonPrimitive && (p = (JsonPrimitive)patt0$temp).isNumber()) {
                                    override.waterFogDistance = Float.valueOf(p.getAsFloat());
                                }
                                if ((patt1$temp = o.get("water_transparency")) instanceof JsonPrimitive && (p = (JsonPrimitive)patt1$temp).isNumber()) {
                                    override.waterTransparency = Float.valueOf(p.getAsFloat());
                                }
                            }
                        });
                    }
                    bufferedReader.close();
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            }));
        }

        public String method_22322() {
            return "legacy:biome_overrides";
        }
    }
}

