/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.ModInfo;
import wily.legacy.client.ControlType;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class ModsScreen
extends PanelVListScreen {
    protected final Map<ModInfo, SizedLocation> modLogosCache = new ConcurrentHashMap<ModInfo, SizedLocation>();
    protected ScrollableRenderer scrollableRenderer = new ScrollableRenderer(new LegacyScrollRenderer());
    protected final Panel tooltipBox = Panel.tooltipBoxOf(this.panel, 192);
    protected final Stocker.Sizeable sorting = new Stocker.Sizeable(Integer.valueOf(1), 1);
    protected ModInfo focusedMod;
    protected final LoadingCache<ModInfo, AdvancedTextWidget> modLabelsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ModInfo, AdvancedTextWidget>(){

        public AdvancedTextWidget load(ModInfo key) {
            ArrayList<class_2561> components = new ArrayList<class_2561>();
            SizedLocation logo = ModsScreen.this.modLogosCache.get(key);
            if (logo != null && logo.getScaledWidth(28) >= 120) {
                components.add((class_2561)class_2561.method_43470((String)ModsScreen.this.focusedMod.getName()));
                components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.id", (Object[])new Object[]{ModsScreen.this.focusedMod.getId()}));
            }
            if (!key.getAuthors().isEmpty()) {
                components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.authors", (Object[])new Object[]{String.join((CharSequence)", ", key.getAuthors())}));
            }
            if (!key.getCredits().isEmpty()) {
                components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.credits", (Object[])new Object[]{String.join((CharSequence)", ", key.getCredits())}));
            }
            key.getHomepage().ifPresent(s -> components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.homepage", (Object[])new Object[]{s}).method_27696(class_2583.field_24360.method_10958(ModsScreen.urlClickEvent(s)))));
            key.getIssues().ifPresent(s -> components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.issues", (Object[])new Object[]{s}).method_27696(class_2583.field_24360.method_10958(ModsScreen.urlClickEvent(s)))));
            key.getSources().ifPresent(s -> components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.sources", (Object[])new Object[]{s}).method_27696(class_2583.field_24360.method_10958(ModsScreen.urlClickEvent(s)))));
            if (key.getLicense() != null && !key.getLicense().isEmpty()) {
                components.add((class_2561)class_2561.method_43469((String)"legacy.menu.mods.license", (Object[])new Object[]{String.join((CharSequence)", ", key.getLicense())}));
            }
            components.add((class_2561)class_2561.method_43470((String)key.getDescription()));
            MultilineTooltip tooltip = new MultilineTooltip(components, ModsScreen.this.tooltipBox.method_25368() - 16);
            return new AdvancedTextWidget(ModsScreen.this.accessor).withWidth(ModsScreen.this.tooltipBox.method_25368() - 16).withLines(tooltip.method_47405(ModsScreen.this.field_22787));
        }
    });

    public static class_2558 urlClickEvent(String url) {
        return new class_2558(class_2558.class_2559.field_11749, url);
    }

    public ModsScreen(class_437 parent) {
        super(parent, 282, 243, (class_2561)class_2561.method_43473());
        this.renderableVList.layoutSpacing(l -> 0);
        this.fillMods();
    }

    public void fillMods() {
        List<ModInfo> mods = FactoryAPIPlatform.getMods();
        if ((Integer)this.sorting.get() != 0) {
            mods = mods.stream().sorted(Comparator.comparing(ModInfo::getName)).toList();
        }
        mods.forEach(mod -> {
            if (mod.isHidden()) {
                return;
            }
            this.renderableVList.addRenderable((class_4068)new class_4264(0, 0, 260, 30, (class_2561)class_2561.method_43470((String)mod.getName()), (ModInfo)mod){
                final /* synthetic */ ModInfo val$mod;
                {
                    this.val$mod = modInfo;
                    super(i, j, k, l, component);
                }

                public void method_25306() {
                    class_437 config;
                    if (this.method_25370() && (config = FactoryAPIClient.getConfigScreen((ModInfo)this.val$mod, (class_437)ModsScreen.this)) != null) {
                        ModsScreen.this.field_22787.method_1507(config);
                    }
                }

                protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
                    super.method_48579(guiGraphics, i, j, f);
                    if (this.method_25370()) {
                        ModsScreen.this.focusedMod = this.val$mod;
                    }
                    FactoryScreenUtil.enableBlend();
                    SizedLocation logo = ModsScreen.this.modLogosCache.computeIfAbsent(this.val$mod, m -> {
                        Optional opt = m.getLogoFile(100);
                        if (opt.isPresent() && this.val$mod.findResource((String)opt.get()).isPresent()) {
                            try {
                                class_1011 image = class_1011.method_4309((InputStream)Files.newInputStream((Path)this.val$mod.findResource((String)opt.get()).get(), new OpenOption[0]));
                                class_2960 location = FactoryAPI.createLocation((String)this.val$mod.getId(), (String)((String)opt.get()).toLowerCase(Locale.ENGLISH));
                                ModsScreen.this.field_22787.method_1531().method_4616(location, (class_1044)new class_1043(image));
                                if (location != null) {
                                    return new SizedLocation(location, image.method_4307(), image.method_4323());
                                }
                            }
                            catch (IOException image) {
                                // empty catch block
                            }
                        }
                        class_2960 defaultLogo = PackAlbum.Selector.DEFAULT_ICON;
                        if (this.val$mod.getId().equals("minecraft")) {
                            defaultLogo = PackAlbum.Selector.getPackIcon(ModsScreen.this.field_22787.method_1520().method_14449("vanilla"));
                        }
                        return new SizedLocation(defaultLogo, 1, 1);
                    });
                    if (logo != null) {
                        FactoryGuiGraphics.of((class_332)guiGraphics).blit(logo.location, this.method_46426() + 5, this.method_46427() + 5, 0.0f, 0.0f, logo.getScaledWidth(20), 20, logo.getScaledWidth(20), 20);
                    }
                    FactoryScreenUtil.disableBlend();
                }

                protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
                    SizedLocation logo = ModsScreen.this.modLogosCache.get(this.val$mod);
                    ScreenUtil.renderScrollingString(guiGraphics, font, this.method_25369(), this.method_46426() + 10 + (logo == null ? 20 : logo.getScaledWidth(20)), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), j, true);
                }

                protected void method_47399(class_6382 narrationElementOutput) {
                    this.method_37021(narrationElementOutput);
                }
            });
        });
    }

    @Override
    public void renderDefaultBackground(class_332 guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        this.tooltipBox.method_25394(guiGraphics, i, j, f);
        if (this.focusedMod != null) {
            AdvancedTextWidget label = ((AdvancedTextWidget)this.modLabelsCache.getUnchecked((Object)this.focusedMod)).withPos(this.panel.x + this.panel.width + 5, this.panel.y + 41);
            this.scrollableRenderer.scrolled.max = Math.max(0, class_3532.method_15386((float)((float)(label.method_25364() - (this.tooltipBox.method_25364() - 50)) / 12.0f)));
            SizedLocation logo = this.modLogosCache.get(this.focusedMod);
            int x = this.panel.x + this.panel.width + (logo == null ? 5 : logo.getScaledWidth(28) + 10);
            if (logo != null) {
                FactoryGuiGraphics.of((class_332)guiGraphics).blit(logo.location, this.panel.x + this.panel.width + 5, this.panel.y + 10, 0.0f, 0.0f, logo.getScaledWidth(28), 28, logo.getScaledWidth(28), 28);
            }
            if (logo == null || logo.getScaledWidth(28) < 120) {
                ScreenUtil.renderScrollingString(guiGraphics, this.field_22793, (class_2561)class_2561.method_43469((String)"legacy.menu.mods.id", (Object[])new Object[]{this.focusedMod.getId()}), x, this.panel.y + 12, this.panel.x + this.panel.width + 185, this.panel.y + 24, 0xFFFFFF, true);
                ScreenUtil.renderScrollingString(guiGraphics, this.field_22793, (class_2561)class_2561.method_43469((String)"legacy.menu.mods.version", (Object[])new Object[]{this.focusedMod.getVersion()}), x, this.panel.y + 24, this.panel.x + this.panel.width + 185, this.panel.y + 36, 0xFFFFFF, true);
            }
            this.scrollableRenderer.render(guiGraphics, this.panel.x + this.panel.width + 5, this.panel.y + 38, this.tooltipBox.method_25368() - 16, this.tooltipBox.method_25364() - 50, () -> label.method_25394(guiGraphics, i, j + Math.round(this.scrollableRenderer.getYOffset()), f));
        }
    }

    public boolean method_25402(double d, double e, int i) {
        AdvancedTextWidget label;
        if (this.focusedMod != null && ScreenUtil.isMouseOver(d, e, this.panel.x + this.panel.width + 5, this.panel.y + 38, this.tooltipBox.method_25368() - 16, this.tooltipBox.method_25364() - 50) && (label = (AdvancedTextWidget)this.modLabelsCache.getUnchecked((Object)this.focusedMod)).method_25402(d, e + (double)this.scrollableRenderer.getYOffset(), i)) {
            return true;
        }
        return super.method_25402(d, e, i);
    }

    @Override
    public boolean method_25401(double d, double e, double f, double g) {
        if ((this.tooltipBox.isHovered(d, e) || !ControlType.getActiveType().isKbm()) && this.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        return super.method_25401(d, e, f, g);
    }

    @Override
    public void renderableVListInit() {
        this.method_37060((guiGraphics, i, j, f) -> FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 7, this.panel.y + 7, this.panel.width - 14, this.panel.height - 14));
        this.tooltipBox.init();
        this.getRenderableVList().init(this.panel.x + 11, this.panel.y + 11, 260, this.panel.height - 21);
    }

    @Override
    public boolean method_25404(int i, int j, int k) {
        if (i == 88 && this.sorting.add(1, true) != 0) {
            this.renderableVList.renderables.clear();
            this.fillMods();
            this.method_48640();
            return true;
        }
        return super.method_25404(i, j, k);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> class_2561.method_43469((String)"legacy.menu.sorting", (Object[])new Object[]{(Integer)this.sorting.get() == 0 ? LegacyComponents.NONE : LegacyComponents.ALPHABETICAL}));
    }

    public record SizedLocation(class_2960 location, int width, int height) {
        public int getScaledWidth(int height) {
            return (int)((float)height * ((float)this.width / (float)this.height()));
        }
    }
}

