/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.inventory;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1270;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1735;
import net.minecraft.class_1745;
import net.minecraft.class_1746;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_747;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.FactoryIngredient;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.network.ServerMenuCraftPayload;

public abstract class LegacyCraftingMenu
extends class_1703
implements RecipeMenu {
    public static final class_2561 CRAFTING_TITLE = class_2561.method_43471((String)"container.crafting");
    public static final class_2561 STONECUTTER_TITLE = class_2561.method_43471((String)"container.stonecutter");
    public static final class_2561 LOOM_TITLE = class_2561.method_43471((String)"container.loom");
    public static final Map<class_5321<class_2582>, Optional<class_1856>> LOOM_PATTERN_EXTRA_INGREDIENT_CACHE = new ConcurrentHashMap<class_5321<class_2582>, Optional<class_1856>>();
    public final Predicate<class_1657> stillValid;
    public boolean inventoryActive = true;
    public static final class_243 DEFAULT_INVENTORY_OFFSET = new class_243(0.5, 0.5, 0.0);
    public class_243 inventoryOffset = DEFAULT_INVENTORY_OFFSET;
    public boolean showedNotEnoughIngredientsHint = false;

    public static LegacyCraftingMenu craftingMenu(class_1661 inventory, @Nullable class_3917<?> menuType, int i, class_2338 pos, final int gridDimension) {
        return new LegacyCraftingMenu(inventory, menuType, i, p -> pos == null || LegacyCraftingMenu.isValidBlock(p, pos, class_2246.field_9980)){
            class_8786<class_3955> customRcp;
            final class_8566 container;
            class_9694 input;
            {
                super(inventory, menuType, i, stillValid);
                this.container = new class_1715((class_1703)this, gridDimension, gridDimension);
            }

            @Override
            public void onCraft(class_1657 player, ServerMenuCraftPayload packet, class_1799 result) {
                super.onCraft(player, packet, result);
                if (packet.craftId().isPresent() || this.customRcp != null) {
                    player.method_5682().method_3772().method_8130((class_5321)(this.customRcp == null ? this.getRecipeKey(packet.craftId().get()) : this.customRcp.comp_1932())).ifPresent(h -> player.method_51283(h, this.container.method_51305()));
                }
            }

            @Override
            public class_1799 getResult(class_1657 player, ServerMenuCraftPayload packet) {
                this.input = this.container.method_59961();
                if (packet.craftId().isEmpty()) {
                    return player.method_5682().method_3772().method_8132(class_3956.field_17545, (class_9695)this.input, player.method_37908()).map(h -> {
                        this.customRcp = h;
                        return ((class_3955)this.customRcp.comp_1933()).method_8116((class_9695)this.input, (class_7225.class_7874)player.method_37908().method_30349());
                    }).orElse(class_1799.field_8037);
                }
                return player.method_5682().method_3772().method_8130(this.getRecipeKey(packet.craftId().get())).map(h -> {
                    class_1799 class_17992;
                    class_1860 patt0$temp = h.comp_1933();
                    if (patt0$temp instanceof class_3955) {
                        class_3955 rcp = (class_3955)patt0$temp;
                        class_17992 = rcp.method_8116((class_9695)this.input, (class_7225.class_7874)player.method_37908().method_30349());
                    } else {
                        class_17992 = null;
                    }
                    return class_17992;
                }).orElse(class_1799.field_8037);
            }

            @Override
            public List<class_1799> getRemainingItems(class_1657 player, ServerMenuCraftPayload packet) {
                return player.method_5682().method_3772().method_8132(class_3956.field_17545, (class_9695)this.input, player.method_37908()).map(h -> ((class_3955)h.comp_1933()).method_17704(this.input)).orElse(super.getRemainingItems(player, packet));
            }

            @Override
            public List<Optional<class_1856>> getIngredients(class_1657 player, ServerMenuCraftPayload packet) {
                return packet.craftId().isEmpty() || !packet.customIngredients().isEmpty() ? super.getIngredients(player, packet) : player.method_5682().method_3772().method_8130(this.getRecipeKey(packet.craftId().get())).map(r -> 1.getRecipeOptionalIngredients(r.comp_1933())).orElse(Collections.emptyList());
            }

            @Override
            public void setupActualItems(class_1657 player, ServerMenuCraftPayload packet, class_1799 setItem, int index) {
                if (setItem == null) {
                    this.container.method_5448();
                } else {
                    this.container.method_5447(index, setItem);
                }
            }
        };
    }

    public static List<Optional<class_1856>> getRecipeOptionalIngredients(class_1860<?> recipe) {
        List<Object> list;
        if (recipe instanceof class_1869) {
            class_1869 rcp = (class_1869)recipe;
            list = rcp.method_61693();
        } else if (recipe instanceof class_1867) {
            class_1867 sr = (class_1867)recipe;
            list = sr.method_61671().method_64675().stream().map(Optional::of).toList();
        } else if (recipe instanceof class_3975) {
            class_3975 stonecutterRecipe = (class_3975)recipe;
            list = Collections.singletonList(Optional.of(stonecutterRecipe.method_64720()));
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public static LegacyCraftingMenu playerCraftingMenu(int window, class_1661 inventory) {
        return LegacyCraftingMenu.craftingMenu(inventory, (class_3917)LegacyRegistries.PLAYER_CRAFTING_PANEL_MENU.get(), window, null, 2);
    }

    public static LegacyCraftingMenu craftingMenu(int window, class_1661 inventory, class_2338 pos) {
        return LegacyCraftingMenu.craftingMenu(inventory, (class_3917)LegacyRegistries.CRAFTING_PANEL_MENU.get(), window, pos, 3);
    }

    public static LegacyCraftingMenu craftingMenu(int window, class_1661 inventory) {
        return LegacyCraftingMenu.craftingMenu(window, inventory, null);
    }

    public static LegacyCraftingMenu loomMenu(int window, class_1661 inventory, class_2338 blockPos) {
        return new LegacyCraftingMenu(inventory, (class_3917)LegacyRegistries.LOOM_PANEL_MENU.get(), window, p -> LegacyCraftingMenu.isValidBlock(p, blockPos, class_2246.field_10083)){
            final class_1263 container = new class_1277(3);

            @Override
            public List<Optional<class_1856>> getIngredients(class_1657 player, ServerMenuCraftPayload packet) {
                List customIngredients = super.getIngredients(player, packet);
                if (packet.craftId().isPresent() && customIngredients.size() == 2 && Arrays.stream(FactoryIngredient.of((class_1856)((class_1856)((Optional)customIngredients.get(0)).get())).getStacks()).allMatch(i -> i.method_7909() instanceof class_1746) && Arrays.stream(FactoryIngredient.of((class_1856)((class_1856)((Optional)customIngredients.get(1)).get())).getStacks()).allMatch(i -> i.method_7909() instanceof class_1769)) {
                    return player.method_37908().method_30349().method_46759(class_7924.field_41252).flatMap(b -> b.method_46746(class_5321.method_29179((class_5321)class_7924.field_41252, (class_2960)packet.craftId().get())).map(p -> {
                        Optional<class_1856> extraIng = 2.getBannerPatternExtraIngredient(player.method_37908().method_30349(), (class_5321<class_2582>)p.method_40237());
                        if (extraIng.isEmpty()) {
                            return customIngredients;
                        }
                        return ImmutableList.builder().addAll((Iterable)customIngredients).add(extraIng).build();
                    })).orElse(Collections.emptyList());
                }
                return Collections.emptyList();
            }

            @Override
            public class_1799 getResult(class_1657 player, ServerMenuCraftPayload packet) {
                return player.method_37908().method_30349().method_46759(class_7924.field_41252).flatMap(b -> b.method_46746(class_5321.method_29179((class_5321)class_7924.field_41252, (class_2960)packet.craftId().get())).map(p -> {
                    class_1799 banner = this.container.method_5438(0);
                    banner.method_57379(class_9334.field_49619, (Object)new class_9307.class_3750().method_57575((class_9307)banner.method_57825(class_9334.field_49619, (Object)class_9307.field_49404)).method_16376((class_6880)p, ((class_1769)this.container.method_5438(1).method_7909()).method_7802()).method_57573());
                    return banner;
                })).orElse(class_1799.field_8037);
            }

            @Override
            public List<class_1799> getRemainingItems(class_1657 player, ServerMenuCraftPayload packet) {
                return this.container.method_5438(2).method_7960() ? super.getRemainingItems(player, packet) : List.of(this.container.method_5438(2));
            }

            @Override
            public void setupActualItems(class_1657 player, ServerMenuCraftPayload packet, class_1799 setItem, int index) {
                if (setItem == null) {
                    this.container.method_5448();
                } else {
                    this.container.method_5447(index, setItem);
                }
            }
        };
    }

    public static LegacyCraftingMenu loomMenu(int window, class_1661 inventory) {
        return LegacyCraftingMenu.loomMenu(window, inventory, null);
    }

    public static LegacyCraftingMenu stoneCutterMenu(int window, class_1661 inventory, final class_2338 blockPos) {
        return new LegacyCraftingMenu(inventory, (class_3917)LegacyRegistries.STONECUTTER_PANEL_MENU.get(), window, p -> LegacyCraftingMenu.isValidBlock(p, blockPos, class_2246.field_16335)){
            long lastSoundTime;

            @Override
            public void onCraft(class_1657 player, ServerMenuCraftPayload packet, class_1799 result) {
                super.onCraft(player, packet, result);
                long l = player.method_37908().method_8510();
                if (this.lastSoundTime != l) {
                    player.method_37908().method_8396(null, blockPos, class_3417.field_17710, class_3419.field_15245, 1.0f, 1.0f);
                    this.lastSoundTime = l;
                }
            }

            @Override
            public List<Optional<class_1856>> getIngredients(class_1657 player, ServerMenuCraftPayload packet) {
                return player.method_5682().method_3772().method_8130(this.getRecipeKey(packet.craftId().get())).map(r -> 3.getRecipeOptionalIngredients(r.comp_1933())).orElse(Collections.emptyList());
            }

            @Override
            public class_1799 getResult(class_1657 player, ServerMenuCraftPayload packet) {
                return player.method_5682().method_3772().method_8130(this.getRecipeKey(packet.craftId().get())).map(h -> {
                    class_1799 class_17992;
                    class_1860 patt0$temp = h.comp_1933();
                    if (patt0$temp instanceof class_3975) {
                        class_3975 rcp = (class_3975)patt0$temp;
                        class_17992 = rcp.method_59998(null, (class_7225.class_7874)player.method_37908().method_30349());
                    } else {
                        class_17992 = null;
                    }
                    return class_17992;
                }).orElse(class_1799.field_8037);
            }
        };
    }

    public static LegacyCraftingMenu stoneCutterMenu(int window, class_1661 inventory) {
        return LegacyCraftingMenu.stoneCutterMenu(window, inventory, null);
    }

    public LegacyCraftingMenu(@Nullable class_3917<?> menuType, int i, Predicate<class_1657> stillValid) {
        super(menuType, i);
        this.stillValid = stillValid;
    }

    public LegacyCraftingMenu(class_1661 inventory, @Nullable class_3917<?> menuType, int i, Predicate<class_1657> stillValid) {
        this(menuType, i, stillValid);
        this.addInventorySlotGrid((class_1263)inventory, 9, 186, 133, 3);
        this.addInventorySlotGrid((class_1263)inventory, 0, 186, 186, 1);
    }

    public static List<Optional<class_1856>> updateShapedIngredients(List<Optional<class_1856>> ingredientsGrid, List<Optional<class_1856>> recipeIngredients, int gridDimension, int rcpWidth, int rcpHeight) {
        int i;
        int rcpDimension = Math.max(rcpWidth, rcpHeight);
        if (rcpDimension > gridDimension) {
            return Collections.emptyList();
        }
        class_1856[] ingredients = new class_1856[rcpDimension * rcpDimension];
        for (i = 0; i < recipeIngredients.size(); ++i) {
            ingredients[rcpWidth < rcpHeight ? i / rcpWidth * rcpHeight + i % rcpWidth : i] = recipeIngredients.get(i).orElse(null);
        }
        for (i = 0; i < ingredients.length; ++i) {
            ingredientsGrid.set(i > 1 && gridDimension > rcpDimension ? i + 1 : i, Optional.ofNullable(ingredients[i]));
        }
        return ingredientsGrid;
    }

    public static Optional<class_1856> getBannerPatternExtraIngredient(class_5455 registryAccess, class_5321<class_2582> pattern) {
        return LOOM_PATTERN_EXTRA_INGREDIENT_CACHE.computeIfAbsent(pattern, key -> {
            class_6880.class_6883 holder = registryAccess.method_30530(class_7924.field_41252).method_46747(pattern);
            for (class_1792 item : class_7923.field_41178) {
                class_1745 p;
                if (!(item instanceof class_1745) || !holder.method_40220((p = (class_1745)item).method_7704())) continue;
                return Optional.of(class_1856.method_8101((class_1935)item));
            }
            return Optional.empty();
        });
    }

    public class_5321<class_1860<?>> getRecipeKey(class_2960 id) {
        return class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)id);
    }

    public void addInventorySlotGrid(class_1263 container, int startIndex, int x, int y, int rows) {
        for (int j = 0; j < rows; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.method_7621(LegacySlotDisplay.override(new class_1735(container, startIndex + j * 9 + k, x + k * 16, y + j * 16){

                    public void method_7668() {
                        super.method_7668();
                        LegacyCraftingMenu.this.method_7609(this.field_7871);
                    }

                    public boolean method_7682() {
                        return LegacyCraftingMenu.this.inventoryActive;
                    }
                }, new LegacySlotDisplay(){

                    @Override
                    public class_243 getOffset() {
                        return LegacyCraftingMenu.this.inventoryOffset;
                    }

                    @Override
                    public int getWidth() {
                        return 16;
                    }

                    @Override
                    public int getHeight() {
                        return 16;
                    }
                }));
            }
        }
    }

    public class_1799 method_7601(class_1657 player, int i) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(i);
        if (slot.method_7681()) {
            class_1799 itemStack2 = slot.method_7677();
            itemStack = itemStack2.method_7972();
            if (i >= 0 && i < 27 ? !this.method_7616(itemStack2, 27, 36, false) : !this.method_7616(itemStack2, 0, 27, false)) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot.method_48931(class_1799.field_8037, itemStack);
            } else {
                slot.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemStack2);
        }
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        return this.stillValid.test(player);
    }

    public static boolean isValidBlock(class_1657 player, class_2338 pos, class_2248 wantedBlock) {
        return player.method_37908().method_8320(pos).method_27852(wantedBlock) && player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 64.0;
    }

    public static class_3908 getMenuProvider(class_2338 pos, boolean is2x2) {
        return new class_747((i, inventory, player) -> is2x2 ? LegacyCraftingMenu.playerCraftingMenu(i, inventory) : LegacyCraftingMenu.craftingMenu(i, inventory, pos), CRAFTING_TITLE);
    }

    public static class_3908 getMenuProvider(class_1270 constructor, class_2561 component) {
        return new class_747(constructor, component);
    }

    public static class_3908 getLoomMenuProvider(class_2338 pos) {
        return LegacyCraftingMenu.getMenuProvider((i, inv, p) -> LegacyCraftingMenu.loomMenu(i, inv, pos), LOOM_TITLE);
    }

    public static class_3908 getStonecutterMenuProvider(class_2338 pos) {
        return LegacyCraftingMenu.getMenuProvider((i, inv, p) -> LegacyCraftingMenu.stoneCutterMenu(i, inv, pos), STONECUTTER_TITLE);
    }

    @Override
    public void onCraft(class_1657 player, ServerMenuCraftPayload packet, class_1799 result) {
        result.method_7982(player.method_37908(), player, result.method_7947());
    }
}

