/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ThrownTridentRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.projectile.ThrownTrident;
import wily.factoryapi.base.client.FactoryRenderStateExtension;

public class LoyaltyLinesRenderState
implements FactoryRenderStateExtension<ThrownTrident> {
    public boolean canRender;
    public double x;
    public double y;
    public double z;
    public float uniqueAge;
    public int clientSideReturnTridentTickCount;
    public double horizontalMovementFactor;

    public static LoyaltyLinesRenderState of(ThrownTridentRenderState renderState) {
        return (LoyaltyLinesRenderState)FactoryRenderStateExtension.Accessor.of((EntityRenderState)renderState).getExtension(LoyaltyLinesRenderState.class);
    }

    public Class<ThrownTrident> getEntityClass() {
        return ThrownTrident.class;
    }

    public void extractToRenderState(ThrownTrident trident, float partialTicks) {
        boolean bl = this.canRender = trident.getOwner() != null && trident.isNoPhysics();
        if (!this.canRender) {
            return;
        }
        this.horizontalMovementFactor = (double)Mth.lerp((float)(partialTicks * 0.5f), (float)trident.getOwner().yRotO, (float)trident.getOwner().getYRot()) * (Math.PI / 180);
        this.x = Mth.lerp((double)partialTicks, (double)trident.getOwner().xOld, (double)trident.getOwner().getX()) - Mth.lerp((double)partialTicks, (double)trident.xOld, (double)trident.getX());
        this.y = Mth.lerp((double)partialTicks, (double)(trident.getOwner().yOld + (double)trident.getOwner().getEyeHeight() * 0.8), (double)(trident.getOwner().getY() + (double)trident.getOwner().getEyeHeight() * 0.8)) - Mth.lerp((double)partialTicks, (double)trident.yOld, (double)trident.getY());
        this.z = Mth.lerp((double)partialTicks, (double)trident.getOwner().zOld, (double)trident.getOwner().getZ()) - Mth.lerp((double)partialTicks, (double)trident.zOld, (double)trident.getZ());
        this.uniqueAge = (float)(trident.getId() + trident.tickCount) + partialTicks;
        this.clientSideReturnTridentTickCount = trident.clientSideReturnTridentTickCount;
    }
}

