/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.entity;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;

public class BabyVillagerFollowIronGolemBehavior
extends Behavior<Villager> {
    private IronGolem ironGolem;
    private boolean tookGolemRose;
    private int takeGolemRoseTick;

    public BabyVillagerFollowIronGolemBehavior() {
        super((Map)ImmutableMap.of(), 60, 160);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Villager villager) {
        if (villager.getAge() >= 0) {
            return false;
        }
        if (!serverLevel.isBrightOutside()) {
            return false;
        }
        List list = serverLevel.getEntitiesOfClass(IronGolem.class, villager.getBoundingBox().inflate(6.0, 2.0, 6.0));
        if (list.isEmpty()) {
            return false;
        }
        for (IronGolem ironGolem : list) {
            if (ironGolem.getOfferFlowerTick() <= 0) continue;
            this.ironGolem = ironGolem;
            break;
        }
        return this.ironGolem != null;
    }

    protected boolean canStillUse(ServerLevel serverLevel, Villager livingEntity, long l) {
        return this.ironGolem.getOfferFlowerTick() > 0;
    }

    protected void start(ServerLevel serverLevel, Villager livingEntity, long l) {
        this.takeGolemRoseTick = serverLevel.random.nextInt(320);
        this.tookGolemRose = false;
        livingEntity.getNavigation().stop();
    }

    protected void stop(ServerLevel serverLevel, Villager livingEntity, long l) {
        this.ironGolem = null;
        livingEntity.getNavigation().stop();
    }

    protected void tick(ServerLevel serverLevel, Villager livingEntity, long l) {
        livingEntity.getLookControl().setLookAt((Entity)this.ironGolem, 30.0f, 30.0f);
        if (this.ironGolem.getOfferFlowerTick() == this.takeGolemRoseTick) {
            livingEntity.getNavigation().moveTo((Entity)this.ironGolem, 0.5);
            this.tookGolemRose = true;
        }
        if (this.tookGolemRose && (double)livingEntity.distanceTo((Entity)this.ironGolem) < 4.0) {
            this.ironGolem.offerFlower(false);
            livingEntity.getNavigation().stop();
        }
    }
}

