/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.mojang.serialization.Dynamic;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.PackAlbum;

@Mixin(value={LevelSettings.class})
public class ClientLevelSettingsMixin
implements LegacyClientWorldSettings {
    long seed;
    boolean difficultyLocked = false;
    boolean trustPlayers = true;
    String selectedResourceAssort = PackAlbum.MINECRAFT.id();
    @Mutable
    @Shadow
    @Final
    private boolean allowCommands;

    @Inject(method={"parse"}, at={@At(value="RETURN")})
    private static void parse(Dynamic<?> dynamic, WorldDataConfiguration worldDataConfiguration, CallbackInfoReturnable<LevelSettings> cir) {
        LegacyClientWorldSettings.of(cir.getReturnValue()).setDifficultyLocked(dynamic.get("DifficultyLocked").asBoolean(false));
        LegacyClientWorldSettings.of(cir.getReturnValue()).setTrustPlayers(dynamic.get("TrustPlayers").asBoolean(true));
        LegacyClientWorldSettings.of(cir.getReturnValue()).setDisplaySeed(dynamic.get("WorldGenSettings").orElseEmptyMap().get("seed").asLong(0L));
        LegacyClientWorldSettings.of(cir.getReturnValue()).setSelectedResourceAlbum(PackAlbum.resourceById(dynamic.get("SelectedResourceAssort").asString(PackAlbum.MINECRAFT.id())));
    }

    @Inject(method={"copy"}, at={@At(value="RETURN")})
    private void copy(CallbackInfoReturnable<LevelSettings> cir) {
        LegacyClientWorldSettings settings = LegacyClientWorldSettings.of(cir.getReturnValue());
        settings.setDifficultyLocked(this.isDifficultyLocked());
        settings.setTrustPlayers(this.trustPlayers());
        settings.setDisplaySeed(this.getDisplaySeed());
        settings.setSelectedResourceAlbum(this.getSelectedResourceAlbum());
    }

    @Override
    public long getDisplaySeed() {
        return this.seed;
    }

    @Override
    public void setDisplaySeed(long s) {
        this.seed = s;
    }

    @Override
    public boolean trustPlayers() {
        return this.trustPlayers;
    }

    @Override
    public void setTrustPlayers(boolean trust) {
        this.trustPlayers = trust;
    }

    @Override
    public boolean isDifficultyLocked() {
        return this.difficultyLocked;
    }

    @Override
    public void setDifficultyLocked(boolean locked) {
        this.difficultyLocked = locked;
    }

    @Override
    public void setAllowCommands(boolean allow) {
        this.allowCommands = allow;
    }

    @Override
    public PackAlbum getSelectedResourceAlbum() {
        return PackAlbum.resourceById(this.selectedResourceAssort);
    }

    @Override
    public void setSelectedResourceAlbum(PackAlbum album) {
        this.selectedResourceAssort = album.id();
    }
}

