/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.pause;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.ExitConfirmationScreen;
import wily.legacy.client.screen.HelpAndOptionsScreen;
import wily.legacy.client.screen.LeaderboardsScreen;
import wily.legacy.client.screen.LegacyAdvancementsScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.client.LegacyRenderUtil;

@Mixin(value={PauseScreen.class})
public class PauseScreenMixin
extends Screen
implements ControlTooltip.Event,
RenderableVList.Access {
    @Unique
    protected RenderableVList renderableVList;
    @Unique
    private List<RenderableVList> renderableVLists;
    private Button leaderboardsButton;
    private Button saveButton;

    protected PauseScreenMixin(Component component) {
        super(component);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.renderableVList.keyPressed(keyEvent.key())) {
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    @Unique
    private void setAutoSave(int autoSave, Button button) {
        LegacyOptions.autoSaveInterval.set((Object)autoSave);
        LegacyOptions.autoSaveInterval.save();
        button.setMessage((Integer)LegacyOptions.autoSaveInterval.get() > 0 ? LegacyComponents.DISABLE_AUTO_SAVE : LegacyComponents.SAVE_GAME);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initScreen(CallbackInfo ci) {
        this.renderableVList = new RenderableVList(this).layoutSpacing(l -> LegacyOptions.getUIMode().isSD() ? 4 : 5);
        this.renderableVLists = Collections.singletonList(this.renderableVList);
        Renderable[] renderableArray = new Renderable[4];
        renderableArray[0] = Button.builder((Component)Component.translatable((String)"menu.returnToGame"), button -> {
            this.minecraft.setScreen(null);
            this.minecraft.mouseHandler.grabMouse();
        }).build();
        renderableArray[1] = Button.builder((Component)Component.translatable((String)"menu.options"), button -> this.minecraft.setScreen((Screen)new HelpAndOptionsScreen(this))).build();
        this.leaderboardsButton = Button.builder((Component)Component.empty(), button -> this.minecraft.setScreen(LeaderboardsScreen.getActualLeaderboardsScreenInstance(this))).build();
        renderableArray[2] = this.leaderboardsButton;
        renderableArray[3] = Button.builder((Component)Component.translatable((String)"gui.advancements"), button -> this.minecraft.setScreen(LegacyAdvancementsScreen.getActualAdvancementsScreenInstance(this))).build();
        this.renderableVList.addRenderables(renderableArray);
        this.minecraft = Minecraft.getInstance();
        if (LegacySaveCache.hasSaveSystem(this.minecraft)) {
            this.saveButton = Button.builder((Component)((Integer)LegacyOptions.autoSaveInterval.get() > 0 ? LegacyComponents.DISABLE_AUTO_SAVE : LegacyComponents.SAVE_GAME), button -> this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)this, (Integer)LegacyOptions.autoSaveInterval.get() > 0 ? LegacyComponents.DISABLE_AUTO_SAVE : LegacyComponents.SAVE_GAME, (Integer)LegacyOptions.autoSaveInterval.get() > 0 ? LegacyComponents.DISABLE_AUTO_SAVE_MESSAGE : LegacyComponents.SAVE_GAME_MESSAGE, b -> {
                if ((Integer)LegacyOptions.autoSaveInterval.get() > 0) {
                    this.setAutoSave(0, button);
                    this.minecraft.setScreen((Screen)this);
                } else {
                    LegacySaveCache.retakeWorldIcon = true;
                    LegacySaveCache.manualSave = true;
                    this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)this, LegacyComponents.ENABLE_AUTO_SAVE, LegacyComponents.ENABLE_AUTO_SAVE_MESSAGE, b1 -> {
                        this.setAutoSave(1, button);
                        this.minecraft.setScreen((Screen)this);
                    }));
                }
            }))).build();
            this.renderableVList.addRenderable((Renderable)this.saveButton);
        }
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"menu.quit"), button -> this.minecraft.setScreen((Screen)new ExitConfirmationScreen(this))).build());
    }

    @Inject(method={"renderBackground"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        LegacyRenderUtil.renderDefaultBackground(UIAccessor.of((Screen)this), guiGraphics);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        super.render(guiGraphics, i, j, f);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.renderableVListInit();
        if (this.saveButton != null) {
            if (this.minecraft.isDemo()) {
                this.saveButton.active = false;
            } else if (LegacySaveCache.hasSaveSystem(this.minecraft)) {
                this.setAutoSave((Integer)LegacyOptions.autoSaveInterval.get(), this.saveButton);
            }
        }
        if (this.leaderboardsButton != null) {
            this.leaderboardsButton.setMessage((Component)((Boolean)LegacyOptions.legacyLeaderboards.get() != false ? Component.translatable((String)"legacy.menu.leaderboards") : Component.translatable((String)"gui.stats")));
        }
    }

    @Override
    public void renderableVListInit() {
        this.initRenderableVListHeight(20);
        this.renderableVList.init(this.width / 2 - 112, this.height / 3 + 5, 225, 0);
    }

    @Override
    public RenderableVList getRenderableVList() {
        return this.renderableVList;
    }

    @Override
    public List<RenderableVList> getRenderableVLists() {
        return this.renderableVLists;
    }
}

