/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.OversizedItemRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiItemRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.pip.OversizedItemRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.util.ColorUtil;
import wily.legacy.client.BufferSourceWrapper;
import wily.legacy.client.LegacyFeatureRenderDispatcher;
import wily.legacy.client.LegacyGuiItemRenderState;
import wily.legacy.client.LegacyOptions;

public class LegacyGuiItemRenderer
implements AutoCloseable {
    public static final Logger LOGGER = LogManager.getLogger((String)"legacy_gui_item_renderer");
    private static final int MAXIMUM_ITEM_ATLAS_SIZE = RenderSystem.getDevice().getMaxTextureSize();
    public static float OPACITY = 1.0f;
    private final int size;
    private final float opacity;
    private final Map<Object, AtlasPosition> atlasPositions = new Object2ObjectOpenHashMap();
    private final Map<Object, OversizedItemRenderer> oversizedItemRenderers = new Object2ObjectOpenHashMap();
    private final CachedOrthoProjectionMatrixBuffer itemsProjectionMatrixBuffer = new CachedOrthoProjectionMatrixBuffer("items", -1000.0f, 1000.0f, true);
    @Nullable
    private GpuTexture itemsAtlas;
    @Nullable
    private GpuTextureView itemsAtlasView;
    @Nullable
    private GpuTexture itemsAtlasDepth;
    @Nullable
    private GpuTextureView itemsAtlasDepthView;
    private int itemAtlasX;
    private int itemAtlasY;
    private int cachedGuiScale;
    private boolean isValid = true;

    public LegacyGuiItemRenderer(int size, float opacity) {
        this.size = size;
        this.opacity = opacity;
    }

    public LegacyGuiItemRenderer(long sizopacity) {
        this((int)(sizopacity >> 32), Float.intBitsToFloat((int)sizopacity));
    }

    public static void pushOpacity(float hudOpacity) {
        OPACITY = hudOpacity;
    }

    public static void popOpacity() {
        OPACITY = 1.0f;
    }

    public static void secureTranslucentRender(boolean translucent, float alpha, Consumer<Boolean> render) {
        if (!translucent) {
            render.accept(false);
            return;
        }
        LegacyGuiItemRenderer.pushOpacity(alpha);
        render.accept(true);
        LegacyGuiItemRenderer.popOpacity();
    }

    public static float getXScale(Matrix3x2f matrix) {
        return Mth.sqrt((float)(matrix.m00() * matrix.m00() + matrix.m01() * matrix.m01()));
    }

    public static float getYScale(Matrix3x2f matrix) {
        return Mth.sqrt((float)(matrix.m10() * matrix.m10() + matrix.m11() * matrix.m11()));
    }

    public static int getScale(Matrix3x2f matrix) {
        return Math.round(Math.max(LegacyGuiItemRenderer.getXScale(matrix), LegacyGuiItemRenderer.getYScale(matrix)) * 16.0f);
    }

    private void createAtlasTextures(int i) {
        GpuDevice gpuDevice = RenderSystem.getDevice();
        this.itemsAtlas = gpuDevice.createTexture("UI items atlas", 12, TextureFormat.RGBA8, i, i, 1, 1);
        this.itemsAtlas.setTextureFilter(FilterMode.NEAREST, false);
        this.itemsAtlasView = gpuDevice.createTextureView(this.itemsAtlas);
        this.itemsAtlasDepth = gpuDevice.createTexture("UI items atlas depth", 8, TextureFormat.DEPTH32, i, i, 1, 1);
        this.itemsAtlasDepthView = gpuDevice.createTextureView(this.itemsAtlasDepth);
        gpuDevice.createCommandEncoder().clearColorAndDepthTextures(this.itemsAtlas, 0, this.itemsAtlasDepth, 1.0);
    }

    public void prepareItemElements(FeatureRenderDispatcher dispatcher, SubmitNodeCollector submitNodeCollector, MultiBufferSource.BufferSource bufferSource, GuiRenderState renderState, int frameNumber) {
        if (!renderState.getItemModelIdentities().isEmpty()) {
            int i = this.getGuiScaleInvalidatingItemAtlasIfChanged();
            int j = this.size * i;
            int k = this.calculateAtlasSizeInPixels(renderState, j);
            if (this.itemsAtlas == null) {
                this.createAtlasTextures(k);
            }
            RenderSystem.outputColorTextureOverride = this.itemsAtlasView;
            RenderSystem.outputDepthTextureOverride = this.itemsAtlasDepthView;
            RenderSystem.setProjectionMatrix((GpuBufferSlice)this.itemsProjectionMatrixBuffer.getBuffer((float)k, (float)k), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
            PoseStack poseStack = new PoseStack();
            MutableBoolean mutableBoolean = new MutableBoolean(false);
            MutableBoolean mutableBoolean2 = new MutableBoolean(false);
            renderState.forEachItem(guiItemRenderState -> {
                if (LegacyGuiItemRenderState.of(guiItemRenderState).size() != this.size) {
                    return;
                }
                if (!((Boolean)LegacyOptions.enhancedItemTranslucency.get()).booleanValue() && LegacyGuiItemRenderState.of(guiItemRenderState).opacity() != this.opacity) {
                    return;
                }
                if (guiItemRenderState.oversizedItemBounds() != null) {
                    mutableBoolean2.setTrue();
                } else {
                    TrackingItemStackRenderState trackingItemStackRenderState = guiItemRenderState.itemStackRenderState();
                    AtlasPosition atlasPosition = this.atlasPositions.get(trackingItemStackRenderState.getModelIdentity());
                    if (atlasPosition == null || trackingItemStackRenderState.isAnimated() && atlasPosition.lastAnimatedOnFrame != frameNumber) {
                        boolean bl;
                        if (this.itemAtlasX + j > k) {
                            this.itemAtlasX = 0;
                            this.itemAtlasY += j;
                        }
                        boolean bl2 = bl = trackingItemStackRenderState.isAnimated() && atlasPosition != null;
                        if (!bl && this.itemAtlasY + j > k) {
                            if (mutableBoolean.isFalse()) {
                                LOGGER.warn("Trying to render too many items in GUI at the same time. Skipping some of them.");
                                mutableBoolean.setTrue();
                            }
                        } else {
                            int l;
                            int kx = bl ? atlasPosition.x : this.itemAtlasX;
                            int n = l = bl ? atlasPosition.y : this.itemAtlasY;
                            if (bl) {
                                RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(this.itemsAtlas, 0, this.itemsAtlasDepth, 1.0, kx, k - l - j, j, j);
                            }
                            this.renderItemToAtlas(dispatcher, submitNodeCollector, bufferSource, trackingItemStackRenderState, poseStack, kx, l, j);
                            float f = (float)kx / (float)k;
                            float g = (float)(k - l) / (float)k;
                            this.submitBlitFromItemAtlas(renderState, (GuiItemRenderState)guiItemRenderState, f, g, j, k);
                            if (bl) {
                                atlasPosition.lastAnimatedOnFrame = frameNumber;
                            } else {
                                this.atlasPositions.put(guiItemRenderState.itemStackRenderState().getModelIdentity(), new AtlasPosition(this.itemAtlasX, this.itemAtlasY, f, g, frameNumber));
                                this.itemAtlasX += j;
                            }
                        }
                    } else {
                        this.submitBlitFromItemAtlas(renderState, (GuiItemRenderState)guiItemRenderState, atlasPosition.u, atlasPosition.v, j, k);
                    }
                }
            });
            RenderSystem.outputColorTextureOverride = null;
            RenderSystem.outputDepthTextureOverride = null;
            if (mutableBoolean2.getValue().booleanValue()) {
                renderState.forEachItem(guiItemRenderState -> {
                    if (LegacyGuiItemRenderState.of(guiItemRenderState).size() != this.size) {
                        return;
                    }
                    if (!((Boolean)LegacyOptions.enhancedItemTranslucency.get()).booleanValue() && LegacyGuiItemRenderState.of(guiItemRenderState).opacity() != this.opacity) {
                        return;
                    }
                    if (guiItemRenderState.oversizedItemBounds() != null) {
                        TrackingItemStackRenderState trackingItemStackRenderState = guiItemRenderState.itemStackRenderState();
                        OversizedItemRenderer oversizedItemRenderer = this.oversizedItemRenderers.computeIfAbsent(trackingItemStackRenderState.getModelIdentity(), object -> new OversizedItemRenderer(bufferSource));
                        ScreenRectangle screenRectangle = guiItemRenderState.oversizedItemBounds();
                        OversizedItemRenderState oversizedItemRenderState = new OversizedItemRenderState(guiItemRenderState, screenRectangle.left(), screenRectangle.top(), screenRectangle.right(), screenRectangle.bottom());
                        oversizedItemRenderer.prepare((PictureInPictureRenderState)oversizedItemRenderState, renderState, i);
                    }
                });
            }
        }
    }

    private void submitBlitFromItemAtlas(GuiRenderState renderState, GuiItemRenderState guiItemRenderState, float u, float v, int size, int atlasSize) {
        float opacity;
        float h = u + (float)size / (float)atlasSize;
        float k = v + (float)(-size) / (float)atlasSize;
        if (FactoryAPI.isModLoaded((String)"vulkanmod")) {
            v = 1.0f - v;
            k = v + (float)size / (float)atlasSize;
        }
        renderState.submitBlitToCurrentLayer(new BlitRenderState((opacity = LegacyGuiItemRenderState.of(guiItemRenderState).opacity()) == 1.0f || (Boolean)LegacyOptions.enhancedItemTranslucency.get() == false ? RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA : RenderPipelines.GUI_TEXTURED, TextureSetup.singleTexture((GpuTextureView)this.itemsAtlasView), guiItemRenderState.pose(), guiItemRenderState.x(), guiItemRenderState.y(), guiItemRenderState.x() + 16, guiItemRenderState.y() + 16, u, h, v, k, opacity == 1.0f || (Boolean)LegacyOptions.enhancedItemTranslucency.get() == false ? -1 : ColorUtil.withAlpha((int)0xFFFFFF, (float)opacity), guiItemRenderState.scissorArea(), null));
    }

    private void renderItemToAtlas(FeatureRenderDispatcher featureRenderDispatcher, SubmitNodeCollector submitNodeCollector, MultiBufferSource.BufferSource bufferSource, TrackingItemStackRenderState trackingItemStackRenderState, PoseStack poseStack, int x, int y, int k) {
        boolean bl;
        poseStack.pushPose();
        poseStack.translate((float)x + (float)k / 2.0f, (float)y + (float)k / 2.0f, 0.0f);
        poseStack.scale((float)k, (float)(-k), (float)k);
        boolean bl2 = bl = !trackingItemStackRenderState.usesBlockLight();
        if (bl) {
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_FLAT);
        } else {
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
        }
        if (this.opacity != 1.0f && !((Boolean)LegacyOptions.enhancedItemTranslucency.get()).booleanValue()) {
            LegacyFeatureRenderDispatcher.of(featureRenderDispatcher).setBufferSource(BufferSourceWrapper.translucent(bufferSource, this.opacity));
        }
        RenderSystem.enableScissorForRenderTypeDraws((int)x, (int)(this.itemsAtlas.getHeight(0) - y - k), (int)k, (int)k);
        trackingItemStackRenderState.submit(poseStack, submitNodeCollector, 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
        featureRenderDispatcher.renderAllFeatures();
        bufferSource.endBatch();
        LegacyFeatureRenderDispatcher.of(featureRenderDispatcher).setBufferSource(bufferSource);
        RenderSystem.disableScissorForRenderTypeDraws();
        poseStack.popPose();
    }

    private int calculateAtlasSizeInPixels(GuiRenderState renderState, int i) {
        int j;
        Set set = renderState.getItemModelIdentities();
        if (this.atlasPositions.isEmpty()) {
            j = set.size();
        } else {
            j = this.atlasPositions.size();
            for (Object object : set) {
                if (this.atlasPositions.containsKey(object)) continue;
                ++j;
            }
        }
        if (this.itemsAtlas != null) {
            int k = this.itemsAtlas.getWidth(0) / i;
            int l = k * k;
            if (j < l) {
                return this.itemsAtlas.getWidth(0);
            }
            this.invalidateItemAtlas();
        }
        int k = set.size();
        int l = Mth.smallestSquareSide((int)(k + k / 2));
        return Math.clamp((long)Mth.smallestEncompassingPowerOfTwo((int)(l * i)), 512, MAXIMUM_ITEM_ATLAS_SIZE);
    }

    private int getGuiScaleInvalidatingItemAtlasIfChanged() {
        int i = Minecraft.getInstance().getWindow().getGuiScale();
        if (i != this.cachedGuiScale) {
            this.invalidateItemAtlas();
            for (OversizedItemRenderer oversizedItemRenderer : this.oversizedItemRenderers.values()) {
                oversizedItemRenderer.invalidateTexture();
            }
            this.cachedGuiScale = i;
        }
        return i;
    }

    @Override
    public void close() {
        this.invalidateItemAtlas();
    }

    private void invalidateItemAtlas() {
        this.itemAtlasX = 0;
        this.itemAtlasY = 0;
        this.atlasPositions.clear();
        if (this.itemsAtlas != null) {
            this.itemsAtlas.close();
            this.itemsAtlas = null;
        }
        if (this.itemsAtlasView != null) {
            this.itemsAtlasView.close();
            this.itemsAtlasView = null;
        }
        if (this.itemsAtlasDepth != null) {
            this.itemsAtlasDepth.close();
            this.itemsAtlasDepth = null;
        }
        if (this.itemsAtlasDepthView != null) {
            this.itemsAtlasDepthView.close();
            this.itemsAtlasDepthView = null;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void markValid() {
        this.isValid = true;
    }

    public void markInvalid() {
        this.isValid = false;
    }

    public static final class AtlasPosition {
        final int x;
        final int y;
        final float u;
        final float v;
        int lastAnimatedOnFrame;

        AtlasPosition(int i, int j, float f, float g, int k) {
            this.x = i;
            this.y = j;
            this.u = f;
            this.v = g;
            this.lastAnimatedOnFrame = k;
        }
    }
}

