/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.glfw.GLFW;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.util.IOUtil;

public record LegacyIntro(List<ResourceLocation> brands, ResourceLocation background, float brandDuration, float fadeIn, float fadeOut, boolean crossFade) {
    public static final ResourceLocation DEFAULT_BACKGROUND = Legacy4J.createModLocation("textures/gui/intro/background.png");
    public static final LegacyIntro EMPTY = new LegacyIntro(Collections.emptyList());
    public static final Codec<LegacyIntro> COMPLETE_CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.listOf().fieldOf("brands").forGetter(LegacyIntro::brands), (App)ResourceLocation.CODEC.fieldOf("background").orElse((Object)DEFAULT_BACKGROUND).forGetter(LegacyIntro::background), (App)Codec.FLOAT.fieldOf("brandDuration").forGetter(LegacyIntro::brandDuration), (App)Codec.FLOAT.fieldOf("fadeIn").orElse((Object)Float.valueOf(0.4f)).forGetter(LegacyIntro::fadeIn), (App)Codec.FLOAT.fieldOf("fadeOut").orElse((Object)Float.valueOf(0.4f)).forGetter(LegacyIntro::fadeOut), (App)Codec.BOOL.fieldOf("crossFade").orElse((Object)false).forGetter(LegacyIntro::crossFade)).apply((Applicative)i, LegacyIntro::new));
    public static final Codec<LegacyIntro> CODEC = IOUtil.createFallbackCodec(COMPLETE_CODEC, ResourceLocation.CODEC.listOf().xmap(LegacyIntro::new, LegacyIntro::brands));

    public LegacyIntro(List<ResourceLocation> brands) {
        this(brands, DEFAULT_BACKGROUND, 3200.0f, 0.4f, 0.4f, false);
    }

    public static float getTimer(long initTime, LegacyIntro intro) {
        return (float)(Util.getMillis() - initTime) / intro.brandDuration();
    }

    public static boolean canSkip(float timer, LegacyIntro intro) {
        return timer >= (float)intro.brands().size() || (Boolean)LegacyOptions.skipIntro.get() != false || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)257) || GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().handle(), (int)0) == 1 || ControllerBinding.DOWN_BUTTON.state().pressed;
    }

    public static void render(GuiGraphics guiGraphics, LegacyIntro intro, float timer) {
        guiGraphics.fill(0, 0, guiGraphics.guiWidth(), guiGraphics.guiHeight(), -1);
        if (intro.brands.isEmpty()) {
            return;
        }
        int actual = (int)(timer % (float)intro.brands().size());
        float last = (float)Math.ceil(timer) - timer;
        if (intro.crossFade() && last <= intro.fadeOut() && actual + 1 < intro.brands().size()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(intro.brands().get(actual + 1), (guiGraphics.guiWidth() - guiGraphics.guiHeight() * 320 / 180) / 2, 0, 0.0f, 0.0f, guiGraphics.guiHeight() * 320 / 180, guiGraphics.guiHeight(), guiGraphics.guiHeight() * 320 / 180, guiGraphics.guiHeight());
        } else {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(intro.background(), 0, 0, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
        }
        float alpha = last <= intro.fadeOut() ? last / intro.fadeOut() : (last > 1.0f - intro.fadeIn() && !intro.crossFade() ? (1.0f - last) / intro.fadeIn() : 1.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, alpha);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(intro.brands().get(actual), (guiGraphics.guiWidth() - guiGraphics.guiHeight() * 320 / 180) / 2, 0, 0.0f, 0.0f, guiGraphics.guiHeight() * 320 / 180, guiGraphics.guiHeight(), guiGraphics.guiHeight() * 320 / 180, guiGraphics.guiHeight());
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearBlitColor();
    }
}

