/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix4f;
import wily.legacy.client.LegacyOptions;

public interface LegacyNameTag {
    public static final LegacyNameTag NEXT_SUBMIT = new Instance();

    public static LegacyNameTag of(SubmitNodeStorage.NameTagSubmit nameTagSubmit) {
        return (LegacyNameTag)nameTagSubmit;
    }

    public static SubmitNodeStorage.NameTagSubmit withColor(SubmitNodeStorage.NameTagSubmit nameTagSubmit, float[] color) {
        LegacyNameTag.of(nameTagSubmit).setNameTagColor(color);
        return nameTagSubmit;
    }

    public static float getThickness(double distanceToCameraSq) {
        return Math.max(0.1f, (float)Math.sqrt(distanceToCameraSq) / 16.0f);
    }

    public static void renderNameTagOutline(Font font, MultiBufferSource.BufferSource bufferSource, SubmitNodeStorage.NameTagSubmit submit, boolean seeThrough) {
        float thickness = LegacyNameTag.getThickness(submit.distanceToCameraSq());
        float[] color = LegacyNameTag.of(submit).getNameTagColor();
        if (!((Boolean)LegacyOptions.displayNameTagBorder.get()).booleanValue() || thickness >= 1.0f || color == null) {
            return;
        }
        LegacyNameTag.renderOutline(bufferSource.getBuffer(seeThrough ? RenderType.textBackgroundSeeThrough() : RenderType.textBackground()), submit.pose(), submit.x() - 1.1f, submit.y() - 1.1f, (float)font.width((FormattedText)submit.text()) + 2.1f, 10.1f, thickness, color[0], color[1], color[2], 1.0f);
    }

    public static void renderOutline(VertexConsumer consumer, Matrix4f matrix4f, float x, float y, float width, float height, float thickness, float r, float g, float b, float a) {
        LegacyNameTag.fill(consumer, matrix4f, x, y, x + width, y + thickness, r, g, b, a);
        LegacyNameTag.fill(consumer, matrix4f, x, y + height - thickness, x + width, y + height, r, g, b, a);
        LegacyNameTag.fill(consumer, matrix4f, x, y + thickness, x + thickness, y + height - thickness, r, g, b, a);
        LegacyNameTag.fill(consumer, matrix4f, x + width - thickness, y + thickness, x + width, y + height - thickness, r, g, b, a);
    }

    public static void fill(VertexConsumer vertexConsumer, Matrix4f matrix4f, float i, float j, float k, float l, float r, float g, float b, float a) {
        float o;
        if (i < k) {
            o = i;
            i = k;
            k = o;
        }
        if (j < l) {
            o = j;
            j = l;
            l = o;
        }
        vertexConsumer.addVertex(matrix4f, i, j, 0.0f).setColor(r, g, b, a).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, i, l, 0.0f).setColor(r, g, b, a).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, k, l, 0.0f).setColor(r, g, b, a).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, k, j, 0.0f).setColor(r, g, b, a).setLight(0xF000F0);
    }

    public float[] getNameTagColor();

    public void setNameTagColor(float[] var1);

    default public boolean hasColor() {
        return this.getNameTagColor() != null;
    }

    default public void copyFrom(LegacyNameTag tag) {
        this.setNameTagColor(tag.getNameTagColor());
    }

    public static class Instance
    implements LegacyNameTag {
        float[] color;

        @Override
        public float[] getNameTagColor() {
            return this.color;
        }

        @Override
        public void setNameTagColor(float[] color) {
            this.color = color;
        }
    }
}

