/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyGuiItemRenderer;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.RecipesScreen;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyMerchantMenu;
import wily.legacy.inventory.LegacyMerchantOffer;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public class LegacyMerchantScreen
extends RecipesScreen<LegacyMerchantMenu, LegacyIconHolder> {
    protected final boolean[] displaySlotsWarning = new boolean[3];
    boolean initOffers = false;

    public LegacyMerchantScreen(LegacyMerchantMenu abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
    }

    @Override
    protected void updateRecipes() {
        this.recipeButtonsOffset.max = Math.max(0, ((LegacyMerchantMenu)this.menu).merchant.getOffers().size() - 10);
        ArrayList<ItemStack> compactList = new ArrayList<ItemStack>();
        RecipeMenu.handleCompactInventoryList(compactList, Minecraft.getInstance().player.getInventory(), ((LegacyMerchantMenu)this.menu).getCarried());
        this.recipeButtons.forEach(b -> {
            b.allowFocusedItemTooltip = true;
            int i = (Integer)this.recipeButtonsOffset.get() + this.recipeButtons.indexOf(b);
            boolean warning = false;
            if (i < ((LegacyMerchantMenu)this.menu).merchant.getOffers().size()) {
                MerchantOffer offer = (MerchantOffer)((LegacyMerchantMenu)this.menu).merchant.getOffers().get(i);
                boolean matchesCostA = compactList.stream().anyMatch(item -> offer.satisfiedBy(item, offer.getCostB()) && item.getCount() >= offer.getCostA().getCount());
                boolean matchesCostB = offer.getCostB().isEmpty() || compactList.stream().anyMatch(item -> offer.satisfiedBy(offer.getCostA(), item) && item.getCount() >= offer.getCostB().getCount());
                boolean bl = warning = !matchesCostA || !matchesCostB;
                if (offer == this.getSelectedMerchantOffer()) {
                    this.displaySlotsWarning[0] = !matchesCostA;
                    this.displaySlotsWarning[1] = !matchesCostB;
                    this.displaySlotsWarning[2] = warning;
                }
            }
            b.setWarning(warning);
        });
    }

    @Override
    protected LegacyIconHolder createRecipeButton(final int index) {
        LegacyIconHolder h = new LegacyIconHolder(27, 27){

            @Override
            @Nullable
            public Component getAction(ControlTooltip.ActionHolder.Context context) {
                return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 && !LegacyMerchantScreen.this.displaySlotsWarning[2] && this.isValidIndex() && this.isFocused() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).getRequiredLevel() <= ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchantLevel && !((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).isOutOfStock() ? LegacyComponents.TRADE : null);
            }

            @Override
            public void render(GuiGraphics graphics, int i, int j, float f) {
                this.itemIcon = this.isValidIndex() ? ((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).getResult() : ItemStack.EMPTY;
                super.render(graphics, i, j, f);
                graphics.pose().pushMatrix();
                graphics.nextStratum();
                if (this.isValidIndex() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).getRequiredLevel() > ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchantLevel) {
                    this.renderIcon(LegacySprites.PADLOCK, graphics, false, 16, 16);
                } else if (this.isValidIndex() && ((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).isOutOfStock()) {
                    this.renderIcon(LegacySprites.ERROR_CROSS, graphics, false, 15, 15);
                }
                graphics.pose().popMatrix();
            }

            @Override
            public void renderItem(GuiGraphics graphics, int i, int j, float f) {
                if (this.itemIcon.isEmpty()) {
                    return;
                }
                LegacyGuiItemRenderer.secureTranslucentRender(this.isValidIndex() && ((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).isOutOfStock(), 0.5f, u -> super.renderItem(graphics, i, j, f));
            }

            @Override
            public void renderSelection(GuiGraphics graphics, int i, int j, float f) {
                int xDiff = LegacyMerchantScreen.this.leftPos + LegacyMerchantScreen.this.accessor.getInteger("tradingGridPanel.x", 9);
                int yDiff = LegacyMerchantScreen.this.topPos + LegacyMerchantScreen.this.accessor.getInteger("bottomPanel.y", 79);
                int tradingSlotX = LegacyMerchantScreen.this.accessor.getInteger("tradingSlot.x", 8);
                int tradingSlotY = LegacyMerchantScreen.this.accessor.getInteger("tradingSlot.y", 51);
                int tradingSlotSize = LegacyMerchantScreen.this.accessor.getInteger("tradingSlot.size", 27);
                int firstTradingSlotY = LegacyMerchantScreen.this.accessor.getInteger("firstTradingSlot.y", 35);
                int secondTradingSlotY = LegacyMerchantScreen.this.accessor.getInteger("secondTradingSlot.y", 65);
                int resultSlotX = LegacyMerchantScreen.this.accessor.getInteger("resultSlot.x", 77);
                int resultSlotY = LegacyMerchantScreen.this.accessor.getInteger("tradingSlot.y", 51);
                for (int index2 = 0; index2 < 3; ++index2) {
                    MerchantOffer offer = LegacyMerchantScreen.this.getSelectedMerchantOffer();
                    if (index2 == 1 && (offer == null || offer.getCostB().isEmpty())) continue;
                    LegacyIconHolder iconHolder = LegacyRenderUtil.iconHolderRenderer.itemHolder(xDiff + (index2 == 2 ? resultSlotX : tradingSlotX), yDiff + (index2 == 0 ? (offer == null || offer.getCostB().isEmpty() ? tradingSlotY : firstTradingSlotY) : (index2 == 1 ? secondTradingSlotY : resultSlotY)), tradingSlotSize, tradingSlotSize, offer == null ? ItemStack.EMPTY : (index2 == 0 ? offer.getCostA() : (index2 == 1 ? offer.getCostB() : offer.getResult())), offer != null && LegacyMerchantScreen.this.displaySlotsWarning[index2], Vec2.ZERO);
                    if (index2 == 0) {
                        iconHolder.allowItemDecorations = false;
                    }
                    iconHolder.render(graphics, i, j, f);
                    iconHolder.renderTooltip(LegacyMerchantScreen.this.minecraft, graphics, i, j);
                    if (offer == null || index2 != 0) continue;
                    iconHolder.renderScaled(graphics, iconHolder.getX(), iconHolder.getY(), () -> {
                        ItemStack costA = offer.getCostA();
                        ItemStack baseCostA = offer.getBaseCostA();
                        if (baseCostA.getCount() == costA.getCount()) {
                            graphics.renderItemDecorations(LegacyMerchantScreen.this.font, costA, 0, 0);
                        } else {
                            graphics.renderItemDecorations(LegacyMerchantScreen.this.font, baseCostA, -12, 0, baseCostA.getCount() == 1 ? "1" : null);
                            graphics.renderItemDecorations(LegacyMerchantScreen.this.font, costA, 0, 0, costA.getCount() == 1 ? "1" : null);
                            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.DISCOUNT_STRIKETHRUOGH_SPRITE, -5, 12, 0, 9, 2);
                        }
                    });
                }
                super.renderSelection(graphics, i, j, f);
            }

            private int getIndex() {
                return (Integer)LegacyMerchantScreen.this.recipeButtonsOffset.get() + index;
            }

            @Override
            public void setFocused(boolean bl) {
                super.setFocused(bl);
                if (bl) {
                    LegacyMerchantScreen.this.selectedRecipeButton = index;
                    LegacyMerchantScreen.this.updateRecipesAndResetTimer();
                }
            }

            @Override
            public boolean keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isLeft() && index == 0 || keyEvent.isRight() && index == LegacyMerchantScreen.this.recipeButtons.size() - 1) {
                    int oldOffset = (Integer)LegacyMerchantScreen.this.recipeButtonsOffset.get();
                    LegacyMerchantScreen.this.recipeButtonsOffset.add(keyEvent.isLeft() ? -1 : 1, true);
                    if (oldOffset == LegacyMerchantScreen.this.recipeButtonsOffset.max && keyEvent.isRight() || oldOffset == 0 && keyEvent.isLeft()) {
                        LegacyMerchantScreen.this.setFocused((GuiEventListener)LegacyMerchantScreen.this.recipeButtons.get(keyEvent.isLeft() ? LegacyMerchantScreen.this.recipeButtons.size() - 1 : 0));
                    } else {
                        LegacyMerchantScreen.this.scrollRenderer.updateScroll(keyEvent.isLeft() ? ScreenDirection.LEFT : ScreenDirection.RIGHT);
                        LegacyMerchantScreen.this.updateRecipesAndResetTimer();
                    }
                    LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
                    return true;
                }
                return super.keyPressed(keyEvent);
            }

            @Override
            public ResourceLocation getIconHolderSprite() {
                return this.isValidIndex() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).getRequiredLevel() > ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchantLevel ? LegacySprites.GRAY_ICON_HOLDER : super.getIconHolderSprite();
            }

            @Override
            public boolean isWarning() {
                return super.isWarning() && this.isValidIndex() && ((LegacyMerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).getRequiredLevel() <= ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchantLevel && !((MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex())).isOutOfStock();
            }

            private boolean isValidIndex() {
                return this.getIndex() < ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().size();
            }

            @Override
            public void onPress(InputWithModifiers input) {
                if (this.isValidIndex() && this.isFocused()) {
                    MerchantOffer offer = (MerchantOffer)((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchant.getOffers().get(this.getIndex());
                    if (((LegacyMerchantOffer)offer).getRequiredLevel() <= ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).merchantLevel && !offer.isOutOfStock() && !LegacyMerchantScreen.this.displaySlotsWarning[2]) {
                        CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload(Collections.emptyList(), this.getIndex(), input.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed));
                    } else {
                        LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.CRAFT_FAIL.get(), 1.0f);
                    }
                }
            }
        };
        h.offset = new Vec2(0.5f, 0.0f);
        return h;
    }

    public static MutableComponent getMerchantTile(Component title, int i) {
        return Component.translatable((String)"merchant.title", (Object[])new Object[]{title, Component.translatable((String)("merchant.level." + i))});
    }

    @Override
    public int getMaxRecipeButtons() {
        return this.accessor.getInteger("maxTradingButtonsCount", 10);
    }

    @Override
    protected void init() {
        this.imageWidth = 294;
        this.imageHeight = 181;
        LegacyFontUtil.applySDFont(b -> {
            this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
            this.inventoryLabelX = this.accessor.getInteger("inventoryPanel.x", 126) + (this.accessor.getInteger("inventoryPanel.width", 157) - this.font.width((FormattedText)this.playerInventoryTitle)) / 2;
        });
        super.init();
        LegacySlotDisplay display = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return 16;
            }

            @Override
            public Vec2 getOffset() {
                return ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).inventoryOffset;
            }

            @Override
            public boolean isVisible() {
                return ((LegacyMerchantMenu)((LegacyMerchantScreen)LegacyMerchantScreen.this).menu).inventoryActive;
            }
        };
        for (int i = 0; i < 36; ++i) {
            Slot s = (Slot)((LegacyMerchantMenu)this.menu).slots.get(i);
            if (i < 27) {
                LegacySlotDisplay.override(s, 133 + (s.getContainerSlot() - 9) % 9 * 16, 98 + (s.getContainerSlot() - 9) / 9 * 16, display);
                continue;
            }
            LegacySlotDisplay.override(s, 133 + s.getContainerSlot() * 16, 154, display);
        }
        this.updateRecipesAndResetTimer();
        if (this.selectedRecipeButton < this.recipeButtons.size()) {
            this.setFocused((GuiEventListener)this.recipeButtons.get(this.selectedRecipeButton));
        }
        int tradingButtonsX = this.accessor.getInteger("tradingButtons.x", 13);
        int tradingButtonsY = this.accessor.getInteger("tradingButtons.y", 44);
        int tradingButtonsSize = this.accessor.getInteger("tradingButtons.size", 27);
        this.recipeButtons.forEach(holder -> {
            holder.width = holder.height = tradingButtonsSize;
            int i = this.recipeButtons.indexOf(holder);
            holder.setX(this.leftPos + tradingButtonsX + tradingButtonsSize * i);
            holder.setY(this.topPos + tradingButtonsY);
            this.addRenderableWidget((GuiEventListener)holder);
        });
    }

    public MerchantOffer getSelectedMerchantOffer() {
        return this.selectedRecipeButton < ((LegacyMerchantMenu)this.menu).merchant.getOffers().size() ? (MerchantOffer)((LegacyMerchantMenu)this.menu).merchant.getOffers().get(this.selectedRecipeButton) : null;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        if (!((LegacyMerchantMenu)this.menu).merchant.getOffers().isEmpty() && !this.initOffers) {
            this.initOffers = true;
            this.updateRecipesAndResetTimer();
        }
        super.render(guiGraphics, i, j, f);
    }

    protected void renderProgressBar(GuiGraphics guiGraphics) {
        int p;
        int k = ((LegacyMerchantMenu)this.menu).merchantLevel;
        int l = ((LegacyMerchantMenu)this.menu).merchant.getVillagerXp();
        if (k >= 5) {
            return;
        }
        int width = this.accessor.getInteger("progressBar.width", 243);
        int height = this.accessor.getInteger("progressBar.height", 6);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)(this.leftPos + this.accessor.getInteger("progressBar.x", (this.imageWidth - width) / 2)), (float)(this.topPos + this.accessor.getInteger("progressBar.y", 28)));
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_BACKGROUND, 0, 0, 0, width, height);
        int m = VillagerData.getMinXpPerLevel((int)k);
        if (l < m || !VillagerData.canLevelUp((int)k)) {
            guiGraphics.pose().popMatrix();
            return;
        }
        float f = (float)width / (float)(VillagerData.getMaxXpPerLevel((int)k) - m);
        int o = Math.min(Mth.floor((float)(f * (float)(l - m))), width);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_CURRENT, width, height, 0, 0, 0, 0, 0, o, height);
        int n = p = this.getSelectedMerchantOffer() != null ? this.getSelectedMerchantOffer().getXp() : 0;
        if (p > 0) {
            int q = Math.min(Mth.floor((float)((float)p * f)), width - o);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.EXPERIENCE_BAR_RESULT, width, height, o, 0, o, 0, 0, q, height);
        }
        guiGraphics.pose().popMatrix();
    }

    public void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LegacyFontUtil.applySDFont(b -> {
            int level;
            int titleY = this.accessor.getInteger("title.y", 12);
            int k = ((LegacyMerchantMenu)this.menu).merchantLevel;
            if (k > 0 && k <= 5 && ((LegacyMerchantMenu)this.menu).showProgressBar) {
                MutableComponent component = LegacyMerchantScreen.getMerchantTile(this.title, k);
                guiGraphics.drawString(this.font, (Component)component, (this.imageWidth - this.font.width((FormattedText)component)) / 2, titleY, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            } else {
                guiGraphics.drawString(this.font, this.title, this.titleLabelX, titleY, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            }
            int bottomPanelY = this.accessor.getInteger("bottomPanel.y", 79);
            guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, bottomPanelY + this.accessor.getInteger("inventoryTitle.y", 8), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            if (this.getSelectedMerchantOffer() != null && ((LegacyMerchantMenu)this.menu).showProgressBar && (level = ((LegacyMerchantOffer)this.getSelectedMerchantOffer()).getRequiredLevel()) > 0) {
                MutableComponent c = Component.translatable((String)("merchant.level." + level));
                int tradingGridPanelX = this.accessor.getInteger("tradingGridPanel.x", 12);
                int tradingPanelWidth = this.accessor.getInteger("tradingGridPanel.width", 110);
                guiGraphics.drawString(this.font, (Component)c, tradingGridPanelX + (tradingPanelWidth - this.font.width((FormattedText)c)) / 2, bottomPanelY + this.accessor.getInteger("levelTitle.y", 21), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            }
        });
    }

    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        LegacyMerchantOffer o;
        boolean sd = LegacyOptions.getUIMode().isSD();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.accessor.getResourceLocation("imageSprite", LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        int bottomPanelHeight = this.accessor.getInteger("bottomPanel.height", 93);
        int tradingPanelWidth = this.accessor.getInteger("tradingGridPanel.width", 110);
        int bottomPanelY = this.accessor.getInteger("bottomPanel.y", 79);
        int tradingGridPanelX = this.accessor.getInteger("tradingGridPanel.x", 12);
        int inventoryPanelX = this.accessor.getInteger("inventoryPanel.x", 126);
        int inventoryPanelWidth = this.accessor.getInteger("inventoryPanel.width", 157);
        int tradingArrowX = this.accessor.getInteger("tradingArrow.x", 35);
        int tradingArrowY = this.accessor.getInteger("tradingArrow.y", 52);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + tradingGridPanelX, this.topPos + bottomPanelY, tradingPanelWidth, bottomPanelHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + inventoryPanelX, this.topPos + bottomPanelY, inventoryPanelWidth, bottomPanelHeight);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)(this.leftPos + tradingGridPanelX + tradingArrowX), (float)(this.topPos + bottomPanelY + tradingArrowY));
        guiGraphics.pose().scale(1.5f, 1.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(sd ? LegacySprites.SMALL_ARROW : LegacySprites.ARROW, 0, 0, sd ? 16 : 22, sd ? 14 : 15);
        if (this.getSelectedMerchantOffer() != null && this.getSelectedMerchantOffer().isOutOfStock()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ERROR_CROSS, 4, 0, 15, 15);
        }
        guiGraphics.pose().popMatrix();
        MerchantOffer merchantOffer = this.getSelectedMerchantOffer();
        if (merchantOffer instanceof LegacyMerchantOffer && (o = (LegacyMerchantOffer)merchantOffer).getRequiredLevel() > ((LegacyMerchantMenu)this.menu).merchantLevel) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PADLOCK, this.leftPos + tradingGridPanelX + tradingArrowX + 9, this.topPos + bottomPanelY + tradingArrowY + 3, 16, 16);
        }
        if (this.accessor.getBoolean("showProgressBar", Boolean.valueOf(((LegacyMerchantMenu)this.menu).showProgressBar)).booleanValue()) {
            this.renderProgressBar(guiGraphics);
        }
        this.renderRecipesScroll(guiGraphics, 5, 52);
    }
}

