/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldOpenFlows;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.OptionsScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelBackgroundScreen;
import wily.legacy.client.screen.PublishScreen;
import wily.legacy.client.screen.SaveRenderableList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.WorldMoreOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class LoadSaveScreen
extends PanelBackgroundScreen {
    public static final Component GAME_MODEL_LABEL = Component.translatable((String)"selectWorld.gameMode");
    public static final List<ResourceKey<Level>> RESETTABLE_DIMENSIONS = new ArrayList<ResourceKey>(List.of(Level.NETHER, Level.END));
    public static final List<GameType> GAME_TYPES = Arrays.stream(GameType.values()).toList();
    public final List<ResourceKey<Level>> dimensionsToReset = new ArrayList<ResourceKey<Level>>();
    public final LevelSummary summary;
    protected final boolean isLocked;
    protected final LevelStorageSource.LevelStorageAccess access;
    protected final LegacySliderButton<GameType> gameTypeSlider;
    protected final PackAlbum.Selector resourceAlbumSelector;
    protected final TickBox onlineTickBox;
    protected final PublishScreen publishScreen;
    public BiConsumer<GameRules, MinecraftServer> applyGameRules = (r, s) -> {};
    public boolean trustPlayers;
    public boolean hostPrivileges;
    public Difficulty difficulty;

    public LoadSaveScreen(Screen screen, LevelSummary summary, LevelStorageSource.LevelStorageAccess access, boolean isLocked) {
        super((PanelBackgroundScreen s) -> Panel.createPanel(s, p -> (s.width - (p.width + (LegacyRenderUtil.hasTooltipBoxes(UIAccessor.of((Screen)s)) ? PackAlbum.Selector.getDefaultWidth() : 0))) / 2, p -> (s.height - p.height) / 2 + 21, 245, 233), (Component)Component.translatable((String)"legacy.menu.load_save.load"));
        this.isLocked = isLocked;
        this.parent = screen;
        this.summary = summary;
        this.access = access;
        this.difficulty = summary.getSettings().difficulty();
        this.gameTypeSlider = new LegacySliderButton<GameType>(0, 0, 220, 16, b -> b.getDefaultMessage(GAME_MODEL_LABEL, ((GameType)b.getObjectValue()).getShortDisplayName()), b -> Tooltip.create((Component)Component.translatable((String)("selectWorld.gameMode." + ((GameType)b.getObjectValue()).getName() + ".info"))), summary.getSettings().gameType(), () -> GAME_TYPES, b -> {});
        this.gameTypeSlider.active = !summary.isHardcore();
        this.publishScreen = new PublishScreen((Screen)this, this.gameTypeSlider.getObjectValue());
        this.onlineTickBox = new TickBox(0, 0, 220, this.publishScreen.publish, b -> PublishScreen.PUBLISH, b -> null, button -> {
            if (button.selected) {
                this.minecraft.setScreen((Screen)this.publishScreen);
            }
            this.publishScreen.publish = false;
            button.selected = false;
        });
        this.hostPrivileges = LoadSaveScreen.hasCommands(summary);
        this.trustPlayers = LegacyClientWorldSettings.of(summary.getSettings()).trustPlayers();
        this.resourceAlbumSelector = PackAlbum.Selector.resources(this.panel.x + 13, this.panel.y + 112, 220, 45, !LegacyRenderUtil.hasTooltipBoxes(this.accessor), LegacyClientWorldSettings.of(summary.getSettings()).getSelectedResourceAlbum());
        PackAlbum.Selector.resources(this.panel.x + 13, this.panel.y + 112, 220, 45, !LegacyRenderUtil.hasTooltipBoxes(this.accessor), LegacyClientWorldSettings.of(summary.getSettings()).getSelectedResourceAlbum()).active = !this.isLocked;
    }

    public LoadSaveScreen(Screen screen, LevelSummary summary, LevelStorageSource source) {
        this(screen, summary, LoadSaveScreen.getSummaryAccess(source, summary), false);
    }

    public static boolean hasCommands(LevelSummary levelSummary) {
        return levelSummary.hasCommands();
    }

    public static LevelStorageSource.LevelStorageAccess getSummaryAccess(LevelStorageSource source, LevelSummary summary) {
        LevelStorageSource.LevelStorageAccess levelStorageAccess;
        block8: {
            LevelStorageSource.LevelStorageAccess access = source.createAccess(summary.getLevelId());
            try {
                levelStorageAccess = access;
                if (access == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (access != null) {
                        try {
                            access.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            access.close();
        }
        return levelStorageAccess;
    }

    public static void deleteLevelDimension(LevelStorageSource.LevelStorageAccess access, ResourceKey<Level> dimension) throws IOException {
        Path path = access.getDimensionPath(dimension);
        Legacy4J.LOGGER.info("Deleting dimension {}", dimension);
        for (int i = 1; i <= 5; ++i) {
            Legacy4J.LOGGER.info("Attempt {}...", (Object)i);
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path pathx, BasicFileAttributes basicFileAttributes) throws IOException {
                        Legacy4J.LOGGER.debug("Deleting {}", (Object)pathx);
                        Files.delete(pathx);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path pathx, @Nullable IOException iOException) throws IOException {
                        if (iOException != null) {
                            throw iOException;
                        }
                        Files.delete(pathx);
                        return FileVisitResult.CONTINUE;
                    }
                });
                break;
            }
            catch (IOException var6) {
                if (i >= 5) {
                    throw var6;
                }
                Legacy4J.LOGGER.warn("Failed to delete {}", (Object)path, (Object)var6);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    public static void loadWorld(Screen screen, Minecraft minecraft, LevelStorageSource source, String levelId) {
        try (LevelStorageSource.LevelStorageAccess access = source.createAccess(levelId);){
            LoadSaveScreen.loadWorld(screen, minecraft, source, access.getSummary(access.getDataTag()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadWorld(Screen screen, Minecraft minecraft, LevelStorageSource source, LevelSummary summary) {
        SaveRenderableList.resetIconCache();
        PackAlbum.Selector.applyResourceChanges(minecraft, PackAlbum.getSelectedIds(minecraft.getResourcePackRepository()), LegacyClientWorldSettings.of(summary.getSettings()).getSelectedResourceAlbum().packs(), () -> new WorldOpenFlows(minecraft, source).openWorld(summary.getLevelId(), () -> minecraft.setScreen(screen)));
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        OptionsScreen.setupSelectorControlTooltips(renderer, this);
    }

    public int getLayoutWidth() {
        return this.accessor.getInteger("layout.width", 220);
    }

    public int getLayoutX() {
        return this.accessor.getInteger("layout.x", this.panel.x + 13);
    }

    @Override
    protected void init() {
        this.panel.init();
        int layoutX = this.getLayoutX();
        this.gameTypeSlider.setPosition(layoutX, this.panel.y + 65);
        this.gameTypeSlider.setWidth(this.getLayoutWidth());
        ((LegacySliderButton)this.addRenderableWidget((GuiEventListener)((LegacySliderButton)this.accessor.putWidget((String)"difficultySlider", new LegacySliderButton<Difficulty>((int)layoutX, (int)(this.panel.y + 90), (int)this.getLayoutWidth(), (int)16, (Function<LegacySliderButton<T>, Component>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$13(wily.legacy.client.screen.LegacySliderButton ), (Lwily/legacy/client/screen/LegacySliderButton;)Lnet/minecraft/network/chat/Component;)(), (Function<LegacySliderButton<T>, Tooltip>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$14(wily.legacy.client.screen.LegacySliderButton ), (Lwily/legacy/client/screen/LegacySliderButton;)Lnet/minecraft/client/gui/components/Tooltip;)((LoadSaveScreen)this), this.difficulty, (Supplier<List<T>>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$init$15(), ()Ljava/util/List;)(), (Consumer<LegacySliderButton<T>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$init$16(wily.legacy.client.screen.LegacySliderButton ), (Lwily/legacy/client/screen/LegacySliderButton;)V)((LoadSaveScreen)this)))))).active = !LegacyClientWorldSettings.of(this.summary.getSettings()).isDifficultyLocked() && !this.summary.isHardcore();
        this.addRenderableWidget((GuiEventListener)((Button)this.accessor.putWidget("moreOptionsButton", (AbstractWidget)Button.builder((Component)Component.translatable((String)"createWorld.tab.more.title"), button -> this.minecraft.setScreen((Screen)new WorldMoreOptionsScreen(this))).bounds(layoutX, this.panel.y + 178, this.getLayoutWidth(), 20).build())));
        Button loadButton = (Button)this.addRenderableWidget((GuiEventListener)((Button)this.accessor.putWidget("loadButton", (AbstractWidget)Button.builder((Component)Component.translatable((String)"legacy.menu.load_save.load"), button -> this.onLoad()).bounds(layoutX, this.panel.y + 203, this.getLayoutWidth(), 20).build())));
        this.addRenderableWidget((GuiEventListener)((LegacySliderButton)this.accessor.putWidget("gameTypeSlider", this.gameTypeSlider)));
        this.onlineTickBox.selected = this.publishScreen.publish;
        this.onlineTickBox.setPosition(layoutX + 1, this.panel.y + 161);
        this.onlineTickBox.updateHeight();
        this.onlineTickBox.setWidth(this.getLayoutWidth());
        this.addRenderableWidget((GuiEventListener)((TickBox)this.accessor.putWidget("onlineTickBox", (AbstractWidget)this.onlineTickBox)));
        this.setInitialFocus((GuiEventListener)loadButton);
        this.resourceAlbumSelector.setX(layoutX);
        this.resourceAlbumSelector.setY(this.panel.y + 112);
        this.resourceAlbumSelector.setWidth(this.getLayoutWidth());
        this.addRenderableWidget((GuiEventListener)((PackAlbum.Selector)this.accessor.putWidget("resourceAlbumSelector", (AbstractWidget)this.resourceAlbumSelector)));
    }

    public void onLoad() {
        if (this.dimensionsToReset.isEmpty()) {
            this.completeLoad();
        } else {
            this.confirmDimensionToReset(0);
        }
    }

    public void confirmDimensionToReset(final int index) {
        ResourceKey<Level> level = this.dimensionsToReset.get(index);
        final Component dimensionName = LegacyComponents.getDimensionName(level);
        this.minecraft.setScreen((Screen)new ConfirmationScreen(this, (Component)Component.translatable((String)"legacy.menu.load_save.reset", (Object[])new Object[]{dimensionName}), (Component)Component.translatable((String)"legacy.menu.load_save.reset_message", (Object[])new Object[]{dimensionName, dimensionName}), b -> {
            if (index == this.dimensionsToReset.size() - 1) {
                this.completeLoad();
            } else {
                this.confirmDimensionToReset(index + 1);
            }
        }){

            @Override
            protected void addButtons() {
                this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.load_save.reset_cancel", (Object[])new Object[]{dimensionName}), b -> {
                    LoadSaveScreen.this.dimensionsToReset.remove(index);
                    if (LoadSaveScreen.this.dimensionsToReset.isEmpty()) {
                        LoadSaveScreen.this.completeLoad();
                    } else {
                        LoadSaveScreen.this.confirmDimensionToReset(index);
                    }
                }).build());
                this.okButton = Button.builder((Component)this.getTitle(), b -> this.okAction.accept(this)).build();
                this.renderableVList.addRenderable((Renderable)this.okButton);
            }
        });
    }

    public void completeLoad() {
        this.dimensionsToReset.forEach(l -> {
            if (l == Level.OVERWORLD) {
                return;
            }
            try {
                LoadSaveScreen.deleteLevelDimension(this.access, (ResourceKey<Level>)l);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        LegacyClientWorldSettings.of(this.summary.getSettings()).setSelectedResourceAlbum(this.resourceAlbumSelector.getSelectedAlbum());
        LoadSaveScreen.loadWorld((Screen)this, this.minecraft, LegacySaveCache.getLevelStorageSource(), this.summary);
        Legacy4JClient.serverPlayerJoinConsumer = s -> {
            MinecraftServer server = FactoryAPIPlatform.getEntityServer((Entity)s);
            if (this.dimensionsToReset.contains(Level.END)) {
                server.getLevel(Level.END).setDragonFight(new EndDragonFight(this.minecraft.getSingleplayerServer().getLevel(Level.END), this.minecraft.getSingleplayerServer().getWorldData().worldGenOptions().seed(), EndDragonFight.Data.DEFAULT));
            }
            server.setDefaultGameType(this.gameTypeSlider.getObjectValue());
            server.setDifficulty(this.difficulty, false);
            this.applyGameRules.accept(server.getGameRules(), (MinecraftServer)this.minecraft.getSingleplayerServer());
            this.publishScreen.publish((IntegratedServer)server);
            LegacyClientWorldSettings.of(server.getWorldData()).setAllowCommands(this.hostPrivileges);
            server.getPlayerList().sendPlayerPermissionLevel(s);
            LegacyClientWorldSettings.of(server.getWorldData()).setSelectedResourceAlbum(this.resourceAlbumSelector.getSelectedAlbum());
            if (s.gameMode.getGameModeForPlayer() != this.gameTypeSlider.getObjectValue()) {
                s.setGameMode(this.gameTypeSlider.getObjectValue());
            }
        };
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.resourceAlbumSelector.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        return super.mouseScrolled(d, e, f, g);
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderDefaultBackground(guiGraphics, i, j, f);
        this.resourceAlbumSelector.renderTooltipBox(guiGraphics, (LayoutElement)this.panel);
        this.panel.render(guiGraphics, i, j, f);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(LegacyRenderUtil.hasHorizontalArtifacts() ? 0.46f : 0.5f, 0.0f);
        int iconSize = this.accessor.getInteger("saveIcon.size", 29);
        int iconX = this.accessor.getInteger("saveIcon.x", this.panel.x + 14);
        int iconY = this.accessor.getInteger("saveIcon.y", this.panel.y + 10);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_ENTITY_PANEL, iconX - 2, iconY - 1, iconSize + 3, iconSize + 3);
        guiGraphics.pose().popMatrix();
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(0.0f, 0.6f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(((FaviconTexture)SaveRenderableList.iconCache.getUnchecked((Object)this.summary)).textureLocation(), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        LegacyFontUtil.applySDFont(b -> {
            guiGraphics.drawString(this.font, this.summary.getLevelName(), this.accessor.getInteger("nameText.x", this.panel.x + 48), this.accessor.getInteger("nameText.y", this.panel.y + 12), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"legacy.menu.load_save.created_in", (Object[])new Object[]{(LoadSaveScreen.hasCommands(this.summary) ? GameType.CREATIVE : GameType.SURVIVAL).getShortDisplayName()}), this.accessor.getInteger("creationText.x", this.panel.x + 48), this.accessor.getInteger("creationText.y", this.panel.y + 29), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            guiGraphics.pose().popMatrix();
            if (!this.isLocked) {
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)"commands.seed.success", (Object[])new Object[]{LegacyClientWorldSettings.of(this.summary.getSettings()).getDisplaySeed()}), this.accessor.getInteger("seedText.x", this.panel.x + 13), this.accessor.getInteger("seedText.y", this.panel.y + 49), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            }
        });
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        if (LegacyRenderUtil.isMouseOver(i, j, (double)this.panel.x + 14.5, this.panel.y + 10, 29, 29)) {
            guiGraphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"selectWorld.targetFolder", (Object[])new Object[]{Component.literal((String)this.summary.getLevelId()).withStyle(ChatFormatting.ITALIC)}), i, j);
        }
    }

    private /* synthetic */ void lambda$init$16(LegacySliderButton b) {
        this.difficulty = (Difficulty)b.getObjectValue();
    }

    private static /* synthetic */ List lambda$init$15() {
        return Arrays.asList(Difficulty.values());
    }

    private /* synthetic */ Tooltip lambda$init$14(LegacySliderButton b) {
        return Tooltip.create((Component)this.difficulty.getInfo());
    }

    private static /* synthetic */ Component lambda$init$13(LegacySliderButton b) {
        return b.getDefaultMessage((Component)Component.translatable((String)"options.difficulty"), ((Difficulty)b.getObjectValue()).getDisplayName());
    }
}

