/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.ModInfo;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class ModsScreen
extends PanelVListScreen {
    public static final Function<ModInfo, SizedLocation> modLogosCache = Util.memoize(mod -> {
        Optional opt = mod.getLogoFile(100);
        if (opt.isPresent() && mod.containsResource((String)opt.get())) {
            try {
                NativeImage image = NativeImage.read((InputStream)mod.openResource((String)opt.get()));
                ResourceLocation location = FactoryAPI.createLocation((String)mod.getId(), (String)((String)opt.get()).toLowerCase(Locale.ENGLISH));
                Minecraft.getInstance().getTextureManager().register(location, (AbstractTexture)new DynamicTexture(() -> ((ResourceLocation)location).toString(), image));
                if (location != null) {
                    return new SizedLocation(location, image.getWidth(), image.getHeight());
                }
            }
            catch (IOException image) {
                // empty catch block
            }
        }
        ResourceLocation defaultLogo = PackAlbum.Selector.DEFAULT_ICON;
        if (mod.getId().equals("minecraft")) {
            defaultLogo = PackAlbum.Selector.getPackIcon(Minecraft.getInstance().getResourcePackRepository().getPack("vanilla"));
        }
        return new SizedLocation(defaultLogo, 1, 1);
    });
    protected final Panel panelRecess;
    protected final Panel tooltipBox;
    protected final Stocker.Sizeable sorting;
    protected ScrollableRenderer scrollableRenderer;
    protected ModInfo focusedMod;
    protected final LoadingCache<ModInfo, AdvancedTextWidget> modLabelsCache;

    public ModsScreen(Screen parent) {
        super(parent, 282, 243, (Component)Component.empty());
        this.tooltipBox = Panel.tooltipBoxOf(this.panel, 192);
        this.sorting = new Stocker.Sizeable(Integer.valueOf(1), 1);
        this.scrollableRenderer = new ScrollableRenderer(new LegacyScrollRenderer());
        this.modLabelsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ModInfo, AdvancedTextWidget>(){

            public AdvancedTextWidget load(ModInfo key) {
                ArrayList<Component> components = new ArrayList<Component>();
                SizedLocation logo = modLogosCache.apply(key);
                if (logo != null && logo.getScaledWidth(28) >= 120) {
                    components.add((Component)Component.literal((String)ModsScreen.this.focusedMod.getName()));
                    components.add((Component)Component.translatable((String)"legacy.menu.mods.id", (Object[])new Object[]{ModsScreen.this.focusedMod.getId()}));
                }
                if (!key.getAuthors().isEmpty()) {
                    components.add((Component)Component.translatable((String)"legacy.menu.mods.authors", (Object[])new Object[]{String.join((CharSequence)", ", key.getAuthors())}));
                }
                if (!key.getCredits().isEmpty()) {
                    components.add((Component)Component.translatable((String)"legacy.menu.mods.credits", (Object[])new Object[]{String.join((CharSequence)", ", key.getCredits())}));
                }
                key.getHomepage().ifPresent(s -> components.add((Component)Component.translatable((String)"legacy.menu.mods.homepage", (Object[])new Object[]{s}).withStyle(ModsScreen.urlClickStyle(s))));
                key.getIssues().ifPresent(s -> components.add((Component)Component.translatable((String)"legacy.menu.mods.issues", (Object[])new Object[]{s}).withStyle(ModsScreen.urlClickStyle(s))));
                key.getSources().ifPresent(s -> components.add((Component)Component.translatable((String)"legacy.menu.mods.sources", (Object[])new Object[]{s}).withStyle(ModsScreen.urlClickStyle(s))));
                if (key.getLicense() != null && !key.getLicense().isEmpty()) {
                    components.add((Component)Component.translatable((String)"legacy.menu.mods.license", (Object[])new Object[]{String.join((CharSequence)", ", key.getLicense())}));
                }
                components.add((Component)Component.literal((String)key.getDescription()));
                MultilineTooltip tooltip = new MultilineTooltip(components, ModsScreen.this.tooltipBox.getWidth() - 16);
                return new AdvancedTextWidget(ModsScreen.this.accessor).withWidth(ModsScreen.this.tooltipBox.getWidth() - 16).withLines(tooltip.toCharSequence(ModsScreen.this.minecraft));
            }
        });
        this.renderableVList.layoutSpacing(l -> 0);
        this.fillMods();
        this.panelRecess = Panel.createPanel(this, p -> p.appearance(LegacySprites.PANEL_RECESS, this.panel.width - 14, this.panel.height - 14), p -> p.pos(this.panel.x + 7, this.panel.y + 7));
    }

    public static Style urlClickStyle(String url) {
        Style style = Style.EMPTY;
        if (Minecraft.getInstance().player == null) {
            return style;
        }
        try {
            style = style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(url)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return style;
    }

    public void fillMods() {
        List<ModInfo> mods = FactoryAPIPlatform.getMods();
        if ((Integer)this.sorting.get() != 0) {
            mods = mods.stream().sorted(Comparator.comparing(ModInfo::getName)).toList();
        }
        mods.forEach(mod -> {
            if (mod.isHidden()) {
                return;
            }
            this.renderableVList.addRenderable((Renderable)new AbstractButton(0, 0, 260, 30, (Component)Component.literal((String)mod.getName()), (ModInfo)mod){
                final /* synthetic */ ModInfo val$mod;
                {
                    this.val$mod = modInfo;
                    super(i, j, k, l, arg);
                }

                public void onPress(InputWithModifiers input) {
                    Screen config;
                    if (this.isFocused() && (config = FactoryAPIClient.getConfigScreen((ModInfo)this.val$mod, (Screen)ModsScreen.this)) != null) {
                        ModsScreen.this.minecraft.setScreen(config);
                    }
                }

                protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
                    super.renderWidget(guiGraphics, i, j, f);
                    if (this.isFocused()) {
                        ModsScreen.this.focusedMod = this.val$mod;
                    }
                    FactoryScreenUtil.enableBlend();
                    SizedLocation logo = modLogosCache.apply(this.val$mod);
                    if (logo != null) {
                        int iconHeight = ModsScreen.this.accessor.getInteger(ModsScreen.this.getRenderableVList().name + ".buttonIcon.size", 20);
                        int iconPos = (this.height - iconHeight) / 2;
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(logo.location, this.getX() + iconPos, this.getY() + iconPos, 0.0f, 0.0f, logo.getScaledWidth(iconHeight), iconHeight, logo.getScaledWidth(iconHeight), iconHeight);
                    }
                    FactoryScreenUtil.disableBlend();
                }

                protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
                    SizedLocation logo = modLogosCache.apply(this.val$mod);
                    int iconHeight = ModsScreen.this.accessor.getInteger(ModsScreen.this.getRenderableVList().name + ".buttonIcon.size", 20);
                    int iconPos = (this.height - iconHeight) / 2;
                    int x = this.getX() + iconPos + ModsScreen.this.accessor.getInteger(ModsScreen.this.getRenderableVList().name + ".buttonMessage.xOffset", 10) + (logo == null ? iconHeight : logo.getScaledWidth(iconHeight));
                    LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.getMessage(), x, this.getY(), x + this.getWidth(), this.getY() + this.getHeight(), j, true);
                }

                protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                    this.defaultButtonNarrationText(narrationElementOutput);
                }
            });
        });
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        this.tooltipBox.render(guiGraphics, i, j, f);
        if (this.focusedMod != null) {
            AdvancedTextWidget label = ((AdvancedTextWidget)this.modLabelsCache.getUnchecked((Object)this.focusedMod)).withPos(this.panel.x + this.panel.width + 5, this.panel.y + 41);
            this.scrollableRenderer.scrolled.max = Math.max(0, Mth.ceil((float)((float)(label.getHeight() - (this.tooltipBox.getHeight() - 50)) / 12.0f)));
            SizedLocation logo = modLogosCache.apply(this.focusedMod);
            int x = this.panel.x + this.panel.width + (logo == null ? 5 : logo.getScaledWidth(28) + 10);
            if (logo != null) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(logo.location, this.panel.x + this.panel.width + 5, this.panel.y + 10, 0.0f, 0.0f, logo.getScaledWidth(28), 28, logo.getScaledWidth(28), 28);
            }
            if (logo == null || logo.getScaledWidth(28) < 120) {
                LegacyRenderUtil.renderScrollingString(guiGraphics, this.font, (Component)Component.translatable((String)"legacy.menu.mods.id", (Object[])new Object[]{this.focusedMod.getId()}), x, this.panel.y + 12, this.panel.x + this.panel.width + 185, this.panel.y + 24, -1, true);
                LegacyRenderUtil.renderScrollingString(guiGraphics, this.font, (Component)Component.translatable((String)"legacy.menu.mods.version", (Object[])new Object[]{this.focusedMod.getVersion()}), x, this.panel.y + 24, this.panel.x + this.panel.width + 185, this.panel.y + 36, -1, true);
            }
            this.scrollableRenderer.render(guiGraphics, this.panel.x + this.panel.width + 5, this.panel.y + 38, this.tooltipBox.getWidth() - 16, this.tooltipBox.getHeight() - 50, () -> label.render(guiGraphics, i, j + Math.round(this.scrollableRenderer.getYOffset()), f));
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
        AdvancedTextWidget label;
        if (this.focusedMod != null && LegacyRenderUtil.isMouseOver(event.x(), event.y(), this.panel.x + this.panel.width + 5, this.panel.y + 38, this.tooltipBox.getWidth() - 16, this.tooltipBox.getHeight() - 50) && (label = (AdvancedTextWidget)this.modLabelsCache.getUnchecked((Object)this.focusedMod)).mouseClicked(new MouseButtonEvent(event.x(), event.y() + (double)this.scrollableRenderer.getYOffset(), event.buttonInfo()), bl)) {
            return true;
        }
        return super.mouseClicked(event, bl);
    }

    @Override
    public boolean mouseScrolled(double d, double e, double f, double g) {
        if ((this.tooltipBox.isHovered(d, e) || !ControlType.getActiveType().isKbm()) && this.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        return super.mouseScrolled(d, e, f, g);
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.tooltipBox.init();
        this.panelRecess.init("panelRecess");
        this.addRenderableOnly((Renderable)this.panelRecess);
    }

    @Override
    public void renderableVListInit() {
        int buttonsHeight = this.accessor.getInteger("buttonsHeight", 30);
        for (Renderable renderable : this.getRenderableVList().renderables) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget w = (AbstractWidget)renderable;
            w.setHeight(buttonsHeight);
            w.setMessage((Component)w.getMessage().copy().withStyle(w.getMessage().getStyle().withFont((FontDescription)(LegacyOptions.getUIMode().isSD() ? LegacyFontUtil.MOJANGLES_11_FONT : FontDescription.DEFAULT))));
        }
        this.getRenderableVList().init(this.panel.x + 11, this.panel.y + 11, this.panel.width - 22, this.panel.height - 21);
    }

    @Override
    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.key() == 88 && this.sorting.add(1, true) != 0) {
            this.renderableVList.renderables.clear();
            this.fillMods();
            this.repositionElements();
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> Component.translatable((String)"legacy.menu.sorting", (Object[])new Object[]{(Integer)this.sorting.get() == 0 ? LegacyComponents.NONE : LegacyComponents.ALPHABETICAL}));
    }

    public record SizedLocation(ResourceLocation location, int width, int height) {
        public int getScaledWidth(int height) {
            return (int)((float)height * ((float)this.width() / (float)this.height()));
        }

        public int getScaledHeight(int width) {
            return (int)((float)width * ((float)this.height() / (float)this.width()));
        }
    }
}

