/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.LegacyScreen;
import wily.legacy.client.screen.RenderableVList;

public class RenderableVListScreen
extends LegacyScreen
implements RenderableVList.Access {
    protected final RenderableVList renderableVList;
    private final List<RenderableVList> renderableVLists;

    public RenderableVListScreen(Component component, Consumer<RenderableVList> vListBuild) {
        super(component);
        this.renderableVList = new RenderableVList(this.accessor).layoutSpacing(l -> LegacyOptions.getUIMode().isSD() ? 4 : 5);
        this.renderableVLists = Collections.singletonList(this.renderableVList);
        vListBuild.accept(this.renderableVList);
    }

    public RenderableVListScreen(Screen parent, Component component, Consumer<RenderableVList> vListBuild) {
        super(component);
        this.renderableVList = new RenderableVList(this.accessor).layoutSpacing(l -> LegacyOptions.getUIMode().isSD() ? 4 : 5);
        this.renderableVLists = Collections.singletonList(this.renderableVList);
        this.parent = parent;
        vListBuild.accept(this.renderableVList);
    }

    public static Button.Builder openScreenButton(Component component, Supplier<Screen> supplier) {
        return Button.builder((Component)component, button -> Minecraft.getInstance().setScreen((Screen)supplier.get()));
    }

    @Override
    public List<RenderableVList> getRenderableVLists() {
        return this.renderableVLists;
    }

    public void repositionElements() {
        super.repositionElements();
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.renderableVList.keyPressed(keyEvent.key())) {
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    protected void init() {
        this.renderableVListInit();
    }

    @Override
    public void renderableVListInit() {
        this.initRenderableVListHeight(20);
        this.renderableVList.init(this.width / 2 - 112, this.height / 3 + 5, 225, 0);
    }
}

