/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SugarCaneBlock.class})
public class SugarCanesBlockMixin
implements BonemealableBlock {
    @Unique
    protected int getPlantHeight(BlockGetter blockGetter, Function<Integer, BlockPos> blockPos) {
        int i;
        for (i = 0; i < 2 && blockGetter.getBlockState(blockPos.apply(i + 1)).is(Blocks.SUGAR_CANE); ++i) {
        }
        return i;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return this.getPlantHeight((BlockGetter)levelReader, arg_0 -> ((BlockPos)blockPos).below(arg_0)) + this.getPlantHeight((BlockGetter)levelReader, arg_0 -> ((BlockPos)blockPos).above(arg_0)) + 1 < 3;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        int h = 2 - this.getPlantHeight((BlockGetter)serverLevel, arg_0 -> ((BlockPos)blockPos).below(arg_0));
        for (int i = 0; i < h; ++i) {
            serverLevel.setBlock(blockPos.above(i + 1), Blocks.SUGAR_CANE.defaultBlockState(), 3);
        }
    }
}

