/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.datafixers.DataFixer;
import java.net.Proxy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.screen.LegacyLoadingScreen;
import wily.legacy.network.TopMessage;

@Mixin(value={MinecraftServer.class})
public abstract class ClientMinecraftServerMixin {
    @Shadow
    @Final
    public LevelStorageSource.LevelStorageAccess storageSource;
    @Shadow
    private volatile boolean isSaving;
    @Shadow
    @Final
    private Executor executor;
    @Shadow
    private int ticksUntilAutosave;

    @Shadow
    public abstract Iterable<ServerLevel> getAllLevels();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(Thread thread, LevelStorageSource.LevelStorageAccess levelStorageAccess, PackRepository packRepository, WorldStem worldStem, Proxy proxy, DataFixer dataFixer, Services services, LevelLoadListener levelLoadListener, CallbackInfo ci) {
        this.ticksUntilAutosave *= Math.max(1, (Integer)LegacyOptions.autoSaveInterval.get());
    }

    @ModifyReturnValue(method={"computeNextAutosaveInterval"}, at={@At(value="RETURN")})
    private int tickServer(int original) {
        return original * Math.max(1, (Integer)LegacyOptions.autoSaveInterval.get());
    }

    @Inject(method={"tickServer"}, at={@At(value="FIELD", target="Lnet/minecraft/server/MinecraftServer;ticksUntilAutosave:I", opcode=181, ordinal=0, shift=At.Shift.AFTER)})
    private void tickServer(BooleanSupplier booleanSupplier, CallbackInfo ci) {
        if ((Integer)LegacyOptions.autoSaveInterval.get() == 0 || Minecraft.getInstance().isDemo()) {
            ++this.ticksUntilAutosave;
            return;
        }
        if (!((Boolean)LegacyOptions.autoSaveCountdown.get()).booleanValue()) {
            return;
        }
        if (this.ticksUntilAutosave >= 20 && this.ticksUntilAutosave <= 120 && this.ticksUntilAutosave % 20 == 0) {
            TopMessage.setMedium(new TopMessage((Component)Component.translatable((String)"legacy.menu.autoSave_countdown", (Object[])new Object[]{this.ticksUntilAutosave / 20 - 1}), (Integer)CommonColor.INVENTORY_GRAY_TEXT.get(), 21, false, false, false));
        }
        if (this.ticksUntilAutosave <= 0) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.screen == null) {
                minecraft.execute(LegacyLoadingScreen::startFakeAutoSave);
            } else {
                ++this.ticksUntilAutosave;
            }
        }
    }

    @Redirect(method={"tickServer"}, at=@At(value="FIELD", target="Lnet/minecraft/server/MinecraftServer;ticksUntilAutosave:I", opcode=180, ordinal=1))
    private int tickServer(MinecraftServer instance) {
        return (Integer)LegacyOptions.autoSaveInterval.get() > 0 && !Minecraft.getInstance().isDemo() ? this.ticksUntilAutosave : 1;
    }

    @Inject(method={"stopServer"}, at={@At(value="RETURN")})
    private void stopServer(CallbackInfo ci) {
        if (LegacySaveCache.saveExit) {
            LegacySaveCache.saveExit = false;
            LegacySaveCache.saveLevel(this.storageSource);
        }
    }

    @Inject(method={"saveEverything"}, at={@At(value="RETURN")})
    public void saveEverything(boolean bl, boolean bl2, boolean bl3, CallbackInfoReturnable<Boolean> cir) {
        if (!LegacySaveCache.isCurrentWorldSource(this.storageSource)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            this.isSaving = true;
            Iterable<ServerLevel> levels = this.getAllLevels();
            levels.forEach(l -> {
                l.noSave = true;
            });
            LegacySaveCache.saveLevel(this.storageSource);
            levels.forEach(l -> {
                l.noSave = false;
            });
            this.isSaving = false;
        }, this.executor);
    }

    @Inject(method={"stopServer"}, at={@At(value="HEAD")})
    private void stopServerHead(CallbackInfo ci) {
        while (this.isSaving) {
            Thread.onSpinWait();
        }
    }
}

