/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.cartography;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CartographyTableScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryItemUtil;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RenameItemMenu;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;

@Mixin(value={CartographyTableScreen.class})
public abstract class CartographyTableScreenMixin
extends AbstractContainerScreen<CartographyTableMenu> {
    private static final LegacySlotDisplay SLOTS_DISPLAY = new LegacySlotDisplay(){

        @Override
        public int getWidth() {
            return 23;
        }
    };
    private static final LegacySlotDisplay SD_SLOTS_DISPLAY = new LegacySlotDisplay(){

        @Override
        public int getWidth() {
            return 15;
        }
    };
    private EditBox name;
    private final ContainerListener listener = new ContainerListener(){

        public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
            if (i == 0) {
                CartographyTableScreenMixin.this.name.setValue(itemStack.isEmpty() ? "" : itemStack.getHoverName().getString());
                CartographyTableScreenMixin.this.name.setEditable(!itemStack.isEmpty());
            }
        }

        public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int j) {
        }
    };

    public CartographyTableScreenMixin(CartographyTableMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    public void init() {
        final boolean sd = LegacyOptions.getUIMode().isSD();
        this.imageWidth = sd ? 130 : 207;
        this.imageHeight = sd ? 165 : 254;
        this.inventoryLabelX = sd ? 7 : 10;
        this.inventoryLabelY = sd ? 96 : 144;
        LegacyFontUtil.applySDFont(b -> {
            this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.getTitle())) / 2;
        });
        this.titleLabelY = sd ? 5 : 10;
        final int slotsSize = sd ? 13 : 21;
        LegacySlotDisplay defaultDisplay = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return slotsSize;
            }
        };
        super.init();
        for (int i = 0; i < ((CartographyTableMenu)this.menu).slots.size(); ++i) {
            Slot s2 = (Slot)((CartographyTableMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s2, this.inventoryLabelX, sd ? 41 : 62, sd ? SD_SLOTS_DISPLAY : SLOTS_DISPLAY);
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s2, this.inventoryLabelX, sd ? 70 : 105, sd ? SD_SLOTS_DISPLAY : SLOTS_DISPLAY);
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s2, sd ? 110 : 166, sd ? 54 : 82, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return sd ? 16 : 27;
                    }
                });
                continue;
            }
            if (i < ((CartographyTableMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s2, this.inventoryLabelX + (s2.getContainerSlot() - 9) % 9 * slotsSize, (sd ? 104 : 156) + (s2.getContainerSlot() - 9) / 9 * slotsSize, defaultDisplay);
                continue;
            }
            LegacySlotDisplay.override(s2, this.inventoryLabelX + s2.getContainerSlot() * slotsSize, sd ? 148 : 225, defaultDisplay);
        }
        ((CartographyTableMenu)this.menu).addSlotListener(this.listener);
        this.name = new EditBox(this.font, this.leftPos + this.inventoryLabelX, this.topPos + (sd ? 25 : 38), sd ? 70 : 120, sd ? 13 : 18, (Component)Component.empty());
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setMaxLength(50);
        this.name.setResponder(s -> {
            Slot slot = ((CartographyTableMenu)this.menu).getSlot(0);
            if (!slot.hasItem()) {
                return;
            }
            if (!FactoryItemUtil.hasCustomName((ItemStack)slot.getItem()) && s.equals(slot.getItem().getHoverName().getString())) {
                s = "";
            }
            ((RenameItemMenu)this.menu).setResultItemName((String)s);
            this.minecraft.player.connection.send((Packet)new ServerboundRenameItemPacket(s));
        });
        this.name.setValue("");
        this.addWidget((GuiEventListener)this.name);
        this.name.setEditable(((CartographyTableMenu)this.menu).getSlot(0).hasItem());
    }

    public Component getCartographyAction() {
        ItemStack input = ((CartographyTableMenu)this.menu).getSlot(0).getItem();
        ItemStack input2 = ((CartographyTableMenu)this.menu).getSlot(1).getItem();
        if (input.is(Items.FILLED_MAP)) {
            if (input2.is(Items.PAPER)) {
                return LegacyComponents.ZOOM_MAP;
            }
            if (input2.is(Items.MAP)) {
                return LegacyComponents.COPY_MAP;
            }
            if (input2.is(Items.GLASS_PANE)) {
                return LegacyComponents.LOCK_MAP;
            }
            return LegacyComponents.RENAME_MAP;
        }
        return null;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isEscape() && (this.name.keyPressed(keyEvent) || this.name.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LegacyFontUtil.applySDFont(b -> {
            super.renderLabels(guiGraphics, i, j);
            guiGraphics.drawString(this.font, LegacyComponents.MAP_NAME, this.inventoryLabelX, b != false ? 18 : 27, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            Component cartographyAction = this.getCartographyAction();
            if (cartographyAction != null) {
                guiGraphics.drawString(this.font, cartographyAction, (this.imageWidth - this.font.width((FormattedText)cartographyAction)) / 2, b != false ? 86 : 130, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            }
        });
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    public void repositionElements() {
        String string = this.name.getValue();
        super.repositionElements();
        this.name.setValue(string);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ResourceLocation cartographySprite;
        ci.cancel();
        boolean sd = LegacyOptions.getUIMode().isSD();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(UIAccessor.of((Screen)this).getResourceLocation("imageSprite", sd ? LegacySprites.PANEL : LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        this.name.render(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.COMBINER_PLUS, this.leftPos + (sd ? 7 : 14), this.topPos + (sd ? 56 : 88), 13, 13);
        ItemStack input2 = ((CartographyTableMenu)this.menu).getSlot(1).getItem();
        boolean copy = input2.is(Items.MAP);
        boolean zoom = input2.is(Items.PAPER);
        boolean lock = input2.is(Items.GLASS_PANE);
        ItemStack input = ((CartographyTableMenu)this.menu).getSlot(0).getItem();
        int arrowWidth = sd ? 16 : 22;
        int arrowHeight = sd ? 14 : 15;
        int arrowY = this.topPos + (sd ? 55 : 87);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, this.leftPos + (sd ? 24 : 36), arrowY, arrowWidth, arrowHeight);
        if (input.is(Items.FILLED_MAP)) {
            MapItemSavedData mapItemSavedData = MapItem.getSavedData((MapId)((MapId)input.get(DataComponents.MAP_ID)), (Level)this.minecraft.level);
            if (mapItemSavedData != null && (mapItemSavedData.locked && (zoom || lock) || zoom && mapItemSavedData.scale >= 4)) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ERROR_CROSS, this.leftPos + (sd ? 26 : 40), arrowY, 15, 15);
            }
            cartographySprite = copy ? LegacySprites.CARTOGRAPHY_TABLE_COPY : (zoom ? LegacySprites.CARTOGRAPHY_TABLE_ZOOM : (lock ? LegacySprites.CARTOGRAPHY_TABLE_LOCKED : LegacySprites.CARTOGRAPHY_TABLE_MAP));
        } else {
            cartographySprite = LegacySprites.CARTOGRAPHY_TABLE;
        }
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(cartographySprite, this.leftPos + (sd ? 43 : 70), this.topPos + (sd ? 40 : 61), sd ? 44 : 66, sd ? 44 : 66);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, this.leftPos + (sd ? 91 : 139), arrowY, arrowWidth, arrowHeight);
    }
}

