/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.gui;

import com.mojang.authlib.GameProfile;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;

@Mixin(value={PlayerTabOverlay.class})
public abstract class PlayerTabOverlayMixin {
    @Shadow
    @Nullable
    private Component footer;
    @Shadow
    @Nullable
    private Component header;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    protected abstract List<PlayerInfo> getPlayerInfos();

    @Shadow
    public abstract Component getNameForDisplay(PlayerInfo var1);

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void render(GuiGraphics guiGraphics, int i, Scoreboard scoreboard, Objective objective, CallbackInfo ci) {
        boolean bl;
        int o;
        int width = 0;
        int height = 0;
        List<PlayerInfo> list = this.getPlayerInfos();
        int j = this.minecraft.font.width(" ");
        int k = 0;
        int l = 0;
        for (PlayerInfo playerInfo : list) {
            Component component = this.getNameForDisplay(playerInfo);
            k = Math.max(k, this.minecraft.font.width((FormattedText)component));
            if (objective == null) continue;
            ScoreHolder scoreHolder = ScoreHolder.fromGameProfile((GameProfile)playerInfo.getProfile());
            ReadOnlyScoreInfo readOnlyScoreInfo = scoreboard.getPlayerScoreInfo(scoreHolder, objective);
            if (objective.getRenderType() == ObjectiveCriteria.RenderType.HEARTS) continue;
            NumberFormat numberFormat = objective.numberFormatOrDefault((NumberFormat)StyledFormat.PLAYER_LIST_DEFAULT);
            int n = this.minecraft.font.width((FormattedText)ReadOnlyScoreInfo.safeFormatValue((ReadOnlyScoreInfo)readOnlyScoreInfo, (NumberFormat)numberFormat));
            l = Math.max(l, n > 0 ? j + n : 0);
        }
        int p = o = list.size();
        int q = 1;
        while (p > 20) {
            p = (o + ++q - 1) / q;
        }
        boolean bl2 = bl = this.minecraft.isLocalServer() || this.minecraft.getConnection().getConnection().isEncrypted();
        int r = objective != null ? (objective.getRenderType() == ObjectiveCriteria.RenderType.HEARTS ? 90 : l) : 0;
        int n = Math.min(q * ((bl ? 9 : 0) + k + r + 13), i - 50) / q;
        int u = n * q + (q - 1) * 5;
        List list3 = null;
        if (this.header != null) {
            list3 = this.minecraft.font.split((FormattedText)this.header, i - 50);
            for (FormattedCharSequence formattedCharSequence : list3) {
                u = Math.max(u, this.minecraft.font.width(formattedCharSequence));
            }
        }
        List list4 = null;
        if (this.footer != null) {
            list4 = this.minecraft.font.split((FormattedText)this.footer, i - 50);
            for (FormattedCharSequence formattedCharSequence2 : list4) {
                u = Math.max(u, this.minecraft.font.width(formattedCharSequence2));
            }
        }
        if (list3 != null) {
            height += list3.size() * 9 + 1;
        }
        height += p * 9 + 1;
        width += u + 10;
        if (list4 != null) {
            height += list4.size() * 9 + 1;
        }
        LegacyRenderUtil.blitTranslucentSprite(guiGraphics, LegacySprites.POINTER_PANEL, (guiGraphics.guiWidth() - width) / 2, 6, width, height + 8);
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=0))
    public void noHeaderBackground(GuiGraphics instance, int i, int j, int k, int l, int m) {
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=1))
    public void renderBackground(GuiGraphics instance, int i, int j, int k, int l, int m) {
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=2))
    public void noPlayerBackground(GuiGraphics instance, int i, int j, int k, int l, int m) {
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=3))
    public void noFooterBackground(GuiGraphics instance, int i, int j, int k, int l, int m) {
    }
}

