/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.gui;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.SubtitleOverlay;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;

@Mixin(value={SubtitleOverlay.class})
public class SubtitleOverlayMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private boolean isListening;
    @Shadow
    @Final
    private List<SubtitleOverlay.Subtitle> audibleSubtitles;
    @Shadow
    @Final
    private List<SubtitleOverlay.Subtitle> subtitles;

    @Unique
    private SubtitleOverlay self() {
        return (SubtitleOverlay)this;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, CallbackInfo ci) {
        ci.cancel();
        SoundManager soundManager = this.minecraft.getSoundManager();
        if (!this.isListening && ((Boolean)this.minecraft.options.showSubtitles().get()).booleanValue()) {
            soundManager.addListener((SoundEventListener)this.self());
            this.isListening = true;
        } else if (this.isListening && !((Boolean)this.minecraft.options.showSubtitles().get()).booleanValue()) {
            soundManager.removeListener((SoundEventListener)this.self());
            this.isListening = false;
        }
        if (this.isListening) {
            List<SubtitleOverlay.Subtitle> list = this.audibleSubtitles;
            Vec3 vec3 = soundManager.getListenerTransform().position();
            Vec3 vec32 = soundManager.getListenerTransform().forward();
            Vec3 vec33 = soundManager.getListenerTransform().right();
            this.audibleSubtitles.clear();
            for (SubtitleOverlay.Subtitle subtitle : this.subtitles) {
                if (!subtitle.isAudibleFrom(vec3)) continue;
                this.audibleSubtitles.add(subtitle);
            }
            if (!list.isEmpty()) {
                int j = 0;
                double d = (Double)this.minecraft.options.notificationDisplayTime().get();
                Iterator<SubtitleOverlay.Subtitle> iterator = list.iterator();
                while (iterator.hasNext()) {
                    SubtitleOverlay.Subtitle subtitle2 = iterator.next();
                    subtitle2.purgeOldInstances(3000.0 * d);
                    if (!subtitle2.isStillActive()) {
                        iterator.remove();
                        continue;
                    }
                    j = Math.max(j, this.minecraft.font.width((FormattedText)subtitle2.getText()));
                }
                if (list.isEmpty()) {
                    return;
                }
                j += 36;
                int lineHeight = 12;
                guiGraphics.pose().pushMatrix();
                guiGraphics.pose().translate((float)(guiGraphics.guiWidth() - 10), (float)(guiGraphics.guiHeight() - 35));
                int height = list.size() * 12;
                LegacyRenderUtil.renderPointerPanel(guiGraphics, -j, -height, j, height + 10);
                guiGraphics.pose().translate(-((float)j / 2.0f) - 2.0f, 0.0f);
                for (SubtitleOverlay.Subtitle subtitle2 : list) {
                    Component component = subtitle2.getText();
                    SubtitleOverlay.SoundPlayedAt soundPlayedAt = subtitle2.getClosest(vec3);
                    if (soundPlayedAt == null) continue;
                    Vec3 vec34 = soundPlayedAt.location().subtract(vec3).normalize();
                    double e = vec33.dot(vec34);
                    double f = vec32.dot(vec34);
                    boolean bl = f > 0.5;
                    int l = j / 2;
                    Objects.requireNonNull(this.minecraft.font);
                    int n = lineHeight / 2;
                    int o = this.minecraft.font.width((FormattedText)component);
                    int p = Mth.floor((double)Mth.clampedLerp((double)255.0, (double)75.0, (double)((double)(Util.getMillis() - soundPlayedAt.time()) / 3000.0 * d)));
                    int q = p << 16 | p << 8 | p;
                    int r = q - 0x1000000;
                    if (!bl && e != 0.0) {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, (float)p / 255.0f);
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(e > 0.0 ? LegacySprites.SCROLL_RIGHT : LegacySprites.SCROLL_LEFT, e > 0.0 ? l - 8 : -l + 4, -n - 2, 6, 11);
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearBlitColor();
                    }
                    guiGraphics.drawString(this.minecraft.font, component, -o / 2, -n, r);
                    guiGraphics.pose().translate(0.0f, (float)(-lineHeight));
                }
                guiGraphics.pose().popMatrix();
            }
        }
    }
}

