/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.inventory;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.phys.Vec2;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.CreativeModeScreen;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.client.screen.ReplaceableScreen;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin
extends AbstractContainerScreen<InventoryMenu>
implements ReplaceableScreen,
LegacyMenuAccess<InventoryMenu> {
    private static final Vec2 EQUIP_SLOT_OFFSET = new Vec2(50.0f, 0.0f);
    private static final Vec2 EQUIP_SLOT_OFFSET_SD = new Vec2(31.0f, 0.0f);
    private static final ResourceLocation[] EQUIPMENT_SLOT_SPRITES = new ResourceLocation[]{LegacySprites.HEAD_SLOT, LegacySprites.CHEST_SLOT, LegacySprites.LEGS_SLOT, LegacySprites.FEET_SLOT};
    private boolean canReplace = true;

    public InventoryScreenMixin(InventoryMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @ModifyExpressionValue(method={"containerTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;hasInfiniteMaterials()Z")})
    public boolean containerTick(boolean original) {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        final boolean sd = LegacyOptions.getUIMode().isSD();
        this.imageWidth = sd ? 130 : 215;
        this.imageHeight = sd ? 140 : 217;
        this.inventoryLabelX = sd ? 7 : 14;
        this.inventoryLabelY = sd ? 65 : 103;
        final int slotsSize = sd ? 13 : 21;
        super.init();
        LegacySlotDisplay craftingDisplay = new LegacySlotDisplay(){

            @Override
            public boolean isVisible() {
                return LegacyOptions.hasClassicCrafting();
            }

            @Override
            public int getWidth() {
                return slotsSize;
            }
        };
        LegacySlotDisplay defaultDisplay = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return slotsSize;
            }
        };
        for (int i = 0; i < ((InventoryMenu)this.menu).slots.size(); ++i) {
            final Slot s = (Slot)((InventoryMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, sd ? 110 : 180, sd ? 25 : 40, craftingDisplay);
                continue;
            }
            if (i < 5) {
                LegacySlotDisplay.override(s, (sd ? 64 : 111) + s.getContainerSlot() % 2 * slotsSize, (sd ? 19 : 30) + s.getContainerSlot() / 2 * slotsSize, craftingDisplay);
                continue;
            }
            if (i < 9) {
                final int index = 39 - s.getContainerSlot();
                LegacySlotDisplay.override(s, this.inventoryLabelX, (sd ? 9 : 14) + index * slotsSize, new LegacySlotDisplay(){

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.getItem().isEmpty() ? EQUIPMENT_SLOT_SPRITES[index] : null;
                    }

                    @Override
                    public Vec2 getOffset() {
                        return LegacyOptions.hasClassicCrafting() ? Vec2.ZERO : (sd ? EQUIP_SLOT_OFFSET_SD : EQUIP_SLOT_OFFSET);
                    }

                    @Override
                    public int getWidth() {
                        return slotsSize;
                    }
                });
                continue;
            }
            if (i < ((InventoryMenu)this.menu).slots.size() - 10) {
                LegacySlotDisplay.override(s, this.inventoryLabelX + (s.getContainerSlot() - 9) % 9 * slotsSize, (sd ? 76 : 116) + (s.getContainerSlot() - 9) / 9 * slotsSize, defaultDisplay);
                continue;
            }
            if (i < ((InventoryMenu)this.menu).slots.size() - 1) {
                LegacySlotDisplay.override(s, this.inventoryLabelX + s.getContainerSlot() * slotsSize, sd ? 120 : 186, defaultDisplay);
                continue;
            }
            LegacySlotDisplay.override(s, sd ? 64 : 111, sd ? 48 : 77, new LegacySlotDisplay(){

                @Override
                public Vec2 getOffset() {
                    return LegacyOptions.hasClassicCrafting() ? Vec2.ZERO : (sd ? EQUIP_SLOT_OFFSET_SD : EQUIP_SLOT_OFFSET);
                }

                @Override
                public ResourceLocation getIconSprite() {
                    return s.getItem().isEmpty() ? LegacySprites.SHIELD_SLOT : null;
                }

                @Override
                public int getWidth() {
                    return slotsSize;
                }
            });
        }
    }

    @Inject(method={"getRecipeBookButtonPosition"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getRecipeBookButtonPosition(CallbackInfoReturnable<ScreenPosition> cir) {
        cir.setReturnValue((Object)new ScreenPosition(this.leftPos + (LegacyOptions.getUIMode().isSD() ? 90 : 180), this.topPos + (LegacyOptions.getUIMode().isSD() ? 50 : 71)));
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics graphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        boolean sd = LegacyOptions.getUIMode().isSD();
        int playerPanelX = this.leftPos + (sd ? 23 : 40) + (LegacyOptions.hasClassicCrafting() ? 0 : (sd ? 31 : 50));
        int playerPanelY = this.topPos + (sd ? 8 : 13);
        int playerPanelWidth = sd ? 39 : 63;
        int playerPanelHeight = sd ? 52 : 84;
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(UIAccessor.of((Screen)this).getResourceLocation("imageSprite", sd ? LegacySprites.PANEL : LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(sd ? LegacySprites.SQUARE_ENTITY_PANEL : LegacySprites.ENTITY_PANEL, playerPanelX, playerPanelY, playerPanelWidth, playerPanelHeight);
        Pose pose = this.minecraft.player.getPose();
        this.minecraft.player.setPose(Pose.STANDING);
        LegacyRenderUtil.renderEntityInInventoryFollowsMouse(graphics, playerPanelX, playerPanelY, playerPanelX + playerPanelWidth, playerPanelY + playerPanelHeight, sd ? 20 : 35, 0.0625f, i, j, (LivingEntity)this.minecraft.player);
        this.minecraft.player.setPose(pose);
        if (LegacyOptions.hasClassicCrafting()) {
            LegacyFontUtil.applySDFont(b -> graphics.drawString(this.font, this.title, this.leftPos + (sd ? 64 : 111), this.topPos + (sd ? 9 : 16), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SMALL_ARROW, this.leftPos + (sd ? 92 : 158), this.topPos + (sd ? 24 : 42), 16, 14);
        }
    }

    @Inject(method={"renderLabels"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderLabels(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        ci.cancel();
        LegacyFontUtil.applySDFont(b -> guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
    }

    @Override
    public boolean canReplace() {
        return Legacy4JClient.playerHasInfiniteMaterials() && this.canReplace;
    }

    @Override
    public void setCanReplace(boolean canReplace) {
        this.canReplace = canReplace;
    }

    @Override
    public Screen getReplacement() {
        return CreativeModeScreen.getActualCreativeScreenInstance(this.minecraft);
    }

    @Override
    public int getTipXOffset() {
        return -186;
    }

    @Override
    public boolean allowItemPopping() {
        return true;
    }
}

