/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.sign;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.KeyboardScreen;
import wily.legacy.client.screen.WidgetPanel;
import wily.legacy.util.client.LegacySoundUtil;

@Mixin(value={AbstractSignEditScreen.class})
public abstract class AbstractSignEditScreenMixin
extends Screen
implements ControlTooltip.Event {
    @Shadow
    @Final
    private SignBlockEntity sign;
    @Shadow
    private int line;
    @Shadow
    private TextFieldHelper signField;
    private final WidgetPanel panel = new WidgetPanel(this){

        public boolean charTyped(CharacterEvent characterEvent) {
            if (AbstractSignEditScreenMixin.this.signField.charTyped(characterEvent)) {
                return true;
            }
            return super.charTyped(characterEvent);
        }

        @Override
        public void init(String name) {
            super.init(name);
            this.size(100, 100);
            this.pos(this.centeredLeftPos(AbstractSignEditScreenMixin.this), this.centeredTopPos(AbstractSignEditScreenMixin.this));
        }

        public boolean keyPressed(KeyEvent keyEvent) {
            if (KeyboardScreen.isOpenKey(keyEvent.key())) {
                AbstractSignEditScreenMixin.this.minecraft.setScreen((Screen)new KeyboardScreen(AbstractSignEditScreenMixin.this.isSign() ? 60 : -100, () -> this, (Screen)AbstractSignEditScreenMixin.this));
                return true;
            }
            if (keyEvent.isUp() && AbstractSignEditScreenMixin.this.line > 0) {
                --AbstractSignEditScreenMixin.this.line;
                AbstractSignEditScreenMixin.this.signField.setCursorToEnd();
                return true;
            }
            if (!keyEvent.isDown() && keyEvent.key() != 257) {
                return AbstractSignEditScreenMixin.this.signField.keyPressed(keyEvent) || super.keyPressed(keyEvent);
            }
            if (AbstractSignEditScreenMixin.this.line < 3) {
                ++AbstractSignEditScreenMixin.this.line;
                AbstractSignEditScreenMixin.this.signField.setCursorToEnd();
                return true;
            }
            return super.keyPressed(keyEvent);
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return this.isFocused() ? context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, ControlTooltip::getKeyboardAction) : null;
        }
    };

    protected AbstractSignEditScreenMixin(Component component) {
        super(component);
    }

    @ModifyArg(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/Button$Builder;bounds(IIII)Lnet/minecraft/client/gui/components/Button$Builder;"), index=1)
    private int init(int i) {
        return this.height / 2 + 80;
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void init(CallbackInfo ci) {
        this.addWidget(this.panel);
        this.setFocused(this.panel);
    }

    @Inject(method={"renderSignText"}, at={@At(value="HEAD")})
    private void renderSignText(GuiGraphics guiGraphics, CallbackInfo ci) {
        guiGraphics.pose().translate(0.0f, this.isSign() ? -14.5f : 10.0f);
    }

    @Unique
    private boolean isSign() {
        return this.sign.getBlockState().getBlock() instanceof StandingSignBlock || this.sign.getBlockState().getBlock() instanceof WallSignBlock;
    }

    @Redirect(method={"renderSignText"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/SignBlockEntity;getTextLineHeight()I"))
    private int renderSignText(SignBlockEntity instance) {
        return instance.getTextLineHeight() + 5;
    }

    @Redirect(method={"renderSignText"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)V", ordinal=1))
    private void renderSignText(GuiGraphics instance, Font arg, String string, int i, int j, int k, boolean bl) {
        if (this.getFocused() == this.panel) {
            instance.drawString(arg, string, i, j, k, bl);
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawCenteredString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;III)V"))
    public void render(GuiGraphics guiGraphics, Font font, Component component, int i, int j, int k) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(((float)this.width - (float)font.width((FormattedText)this.title) * 1.5f) / 2.0f, (float)this.height / 2.0f - 96.0f);
        guiGraphics.pose().scale(1.5f, 1.5f);
        guiGraphics.drawString(this.font, this.title, 0, 0, -1);
        guiGraphics.pose().popMatrix();
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)super.keyPressed(keyEvent));
    }

    @Inject(method={"charTyped"}, at={@At(value="HEAD")}, cancellable=true)
    public void charTyped(CharacterEvent characterEvent, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)super.charTyped(characterEvent));
    }

    @Inject(method={"onClose"}, at={@At(value="RETURN")})
    public void onClose(CallbackInfo info) {
        LegacySoundUtil.playBackSound();
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }
}

