/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;

public record ClientMerchantTradingPayload(int entityID, Optional<UUID> player, CommonNetwork.Identifier<ClientMerchantTradingPayload> identifier) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<ClientMerchantTradingPayload> ID_C2S = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("client_merchant_trading_c2s"), b -> new ClientMerchantTradingPayload((CommonNetwork.PlayBuf)b, ID_C2S));
    public static final CommonNetwork.Identifier<ClientMerchantTradingPayload> ID_S2C = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("client_merchant_trading_s2c"), b -> new ClientMerchantTradingPayload((CommonNetwork.PlayBuf)b, ID_S2C));

    public ClientMerchantTradingPayload(CommonNetwork.PlayBuf buf, CommonNetwork.Identifier<ClientMerchantTradingPayload> identifier) {
        this(((RegistryFriendlyByteBuf)buf.get()).readVarInt(), ((RegistryFriendlyByteBuf)buf.get()).readOptional(b -> b.readUUID()), identifier);
    }

    public static ClientMerchantTradingPayload of(AbstractVillager villager) {
        return new ClientMerchantTradingPayload(villager.getId(), Optional.ofNullable(villager.getTradingPlayer()).map(Entity::getUUID), ID_S2C);
    }

    public static void sync(AbstractVillager entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            ClientMerchantTradingPayload packet = null;
            for (ServerPlayer player : l.getServer().getPlayerList().getPlayers()) {
                if (player.level() != entity.level() || !(player.distanceTo((Entity)entity) < (float)(l.getServer().getPlayerList().getViewDistance() * 16))) continue;
                CommonNetwork.sendToPlayer((ServerPlayer)player, packet == null ? ClientMerchantTradingPayload.of(entity) : packet);
            }
        }
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((RegistryFriendlyByteBuf)buf.get()).writeVarInt(this.entityID());
        ((RegistryFriendlyByteBuf)buf.get()).writeOptional(this.player, (b, u) -> b.writeUUID(u));
    }

    public void apply(CommonNetwork.Payload.Context context) {
        Entity entity = context.player().level().getEntity(this.entityID);
        if (!(entity instanceof AbstractVillager)) {
            return;
        }
        AbstractVillager v = (AbstractVillager)entity;
        if (context.player().level().isClientSide()) {
            v.setTradingPlayer((Player)this.player.map(u -> v.level().getPlayerByUUID(u)).orElse(null));
        } else {
            ClientMerchantTradingPayload.sync(v);
        }
    }
}

