/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.util.IOUtil;

public class LegacyTipBuilder {
    public static final Codec<LegacyTipBuilder> COMPLETE_CODEC = RecordCodecBuilder.create(i -> i.group((App)DynamicUtil.getComponentCodec().optionalFieldOf("title").forGetter(LegacyTipBuilder::getTitle), (App)DynamicUtil.getComponentCodec().optionalFieldOf("tip").forGetter(LegacyTipBuilder::getTip), (App)DynamicUtil.ITEM_CODEC.fieldOf("itemIcon").orElse((Object)ItemStack.EMPTY).forGetter(LegacyTipBuilder::getItem), (App)Codec.INT.fieldOf("time").orElse((Object)-1).forGetter(LegacyTipBuilder::getTime)).apply((Applicative)i, LegacyTipBuilder::create));
    public static final Codec<LegacyTipBuilder> SIMPLE_CODEC = DynamicUtil.getComponentCodec().xmap(c -> new LegacyTipBuilder().tip((Component)c), b -> b.tip);
    public static final Codec<LegacyTipBuilder> CODEC = new IOUtil.FallbackCodec<LegacyTipBuilder>((Encoder<LegacyTipBuilder>)COMPLETE_CODEC, (Decoder<LegacyTipBuilder>)SIMPLE_CODEC, COMPLETE_CODEC);
    public static final Codec<Map<String, LegacyTipBuilder>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, CODEC).xmap(HashMap::new, Function.identity());
    public static final Codec<List<LegacyTipBuilder>> LIST_CODEC = CODEC.listOf();
    private Component title = null;
    private Component tip = null;
    private ItemStack itemIcon = ItemStack.EMPTY;
    private int time = -1;

    public static LegacyTipBuilder create(Optional<Component> title, Optional<Component> tip, ItemStack itemIcon, int time) {
        return LegacyTipBuilder.create(title.orElse(null), tip.orElse(null), itemIcon, time);
    }

    public static LegacyTipBuilder create(Component title, Component tip, ItemStack itemIcon, int time) {
        return new LegacyTipBuilder().title(title).tip(tip).itemIcon(itemIcon).disappearTime(time);
    }

    public static String getTipId(Item item) {
        return item.getDescriptionId() + ".tip";
    }

    public static Component getTip(ItemStack stack) {
        ComponentContents componentContents = stack.getHoverName().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            return Component.translatable((String)(contents.getKey() + ".tip"));
        }
        return Component.translatable((String)LegacyTipBuilder.getTipId(stack.getItem()));
    }

    public static String getTipId(EntityType<?> item) {
        return item.getDescriptionId() + ".tip";
    }

    public static LegacyTipBuilder decode(CommonNetwork.PlayBuf buf) {
        return LegacyTipBuilder.create(((RegistryFriendlyByteBuf)buf.get()).readOptional(b -> CommonNetwork.decodeComponent((CommonNetwork.PlayBuf)buf)), ((RegistryFriendlyByteBuf)buf.get()).readOptional(b -> CommonNetwork.decodeComponent((CommonNetwork.PlayBuf)buf)), CommonNetwork.decodeItemStack((CommonNetwork.PlayBuf)buf), ((RegistryFriendlyByteBuf)buf.get()).readInt());
    }

    public LegacyTipBuilder title(Component title) {
        this.title = title;
        return this;
    }

    public LegacyTipBuilder tip(Component tip) {
        this.tip = tip;
        return this;
    }

    public LegacyTipBuilder itemIcon(ItemStack itemIcon) {
        this.itemIcon = itemIcon;
        return this;
    }

    public LegacyTipBuilder item(ItemStack itemIcon) {
        if (!itemIcon.isEmpty()) {
            return this.itemIcon(itemIcon).title(itemIcon.getHoverName()).tip(LegacyTipBuilder.getTip(itemIcon));
        }
        return this;
    }

    public LegacyTipBuilder disappearTime(int time) {
        this.time = time;
        return this;
    }

    public LegacyTipBuilder copyFrom(LegacyTipBuilder builder) {
        return this.copyFrom(builder, false);
    }

    public LegacyTipBuilder copyFrom(LegacyTipBuilder builder, boolean modifier) {
        if (!builder.getItem().isEmpty()) {
            if (modifier) {
                this.itemIcon(builder.getItem());
            } else {
                this.item(builder.getItem());
            }
        }
        if (builder.title != null) {
            this.title(builder.title);
        }
        if (builder.tip != null) {
            this.tip(builder.tip);
        }
        if (builder.getTime() >= 0) {
            this.disappearTime(builder.getTime());
        }
        return this;
    }

    public Optional<Component> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Optional<Component> getTip() {
        return Optional.ofNullable(this.tip);
    }

    public ItemStack getItem() {
        return this.itemIcon;
    }

    public int getTime() {
        return this.time;
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((RegistryFriendlyByteBuf)buf.get()).writeOptional(this.getTitle(), (b, t) -> CommonNetwork.encodeComponent((CommonNetwork.PlayBuf)buf, (Component)t));
        ((RegistryFriendlyByteBuf)buf.get()).writeOptional(this.getTip(), (b, t) -> CommonNetwork.encodeComponent((CommonNetwork.PlayBuf)buf, (Component)t));
        CommonNetwork.encodeItemStack((CommonNetwork.PlayBuf)buf, (ItemStack)this.itemIcon);
        ((RegistryFriendlyByteBuf)buf.get()).writeInt(this.time);
    }
}

