/*
 * Decompiled with CFR 0.152.
 */
package dev.faultyfunctions.fourEyes.tasks;

import dev.faultyfunctions.fourEyes.utils.Utils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.ChiseledBookshelf;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ChiseledBookshelfInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Ldev/faultyfunctions/fourEyes/tasks/ChiseledBookshelfTask;", "Lorg/bukkit/scheduler/BukkitRunnable;", "<init>", "()V", "run", "", "four-eyes"})
public final class ChiseledBookshelfTask
extends BukkitRunnable {
    public void run() {
        for (Object e : Bukkit.getOnlinePlayers()) {
            ChiseledBookshelfInventory shelfInventory;
            Vector slotVector;
            BlockFace rayTraceBlockFace;
            RayTraceResult lookRayTrace;
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Player player = (Player)e;
            Block targetBlock = Utils.INSTANCE.getTargetBlock(player);
            if (targetBlock == null || targetBlock.getBlockData().getMaterial() != Material.CHISELED_BOOKSHELF) continue;
            BlockState blockState = targetBlock.getState();
            Intrinsics.checkNotNull(blockState, "null cannot be cast to non-null type org.bukkit.block.ChiseledBookshelf");
            ChiseledBookshelf shelf = (ChiseledBookshelf)blockState;
            if (player.rayTraceBlocks(6.0) == null) {
                return;
            }
            if (lookRayTrace.getHitBlockFace() == null) {
                return;
            }
            BlockData blockData = shelf.getBlockData();
            Intrinsics.checkNotNull(blockData, "null cannot be cast to non-null type org.bukkit.block.data.Directional");
            Directional blockDirectional = (Directional)blockData;
            if (blockDirectional.getFacing() != rayTraceBlockFace) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue(lookRayTrace.getHitPosition().subtract(shelf.getLocation().toVector()), "subtract(...)");
            int slot = shelf.getSlot(slotVector);
            Intrinsics.checkNotNullExpressionValue(shelf.getInventory(), "getInventory(...)");
            ItemStack bookInSlot = shelfInventory.getItem(slot);
            if (bookInSlot == null) {
                player.sendActionBar((Component)Component.text((String)""));
                return;
            }
            ItemMeta bookInSlotMeta = bookInSlot.getItemMeta();
            if (bookInSlotMeta instanceof BookMeta && ((BookMeta)bookInSlotMeta).hasTitle() && ((BookMeta)bookInSlotMeta).hasAuthor()) {
                if (((BookMeta)bookInSlotMeta).hasCustomName()) {
                    Component component = ((BookMeta)bookInSlotMeta).customName();
                    Intrinsics.checkNotNull(component);
                    player.sendActionBar(component.append((Component)Component.text((String)(" by " + ((BookMeta)bookInSlotMeta).getAuthor()))));
                    continue;
                }
                player.sendActionBar((Component)Component.text((String)(((BookMeta)bookInSlotMeta).getTitle() + " by " + ((BookMeta)bookInSlotMeta).getAuthor())));
                continue;
            }
            if (bookInSlotMeta instanceof EnchantmentStorageMeta) {
                ComponentBuilder componentBuilder = ((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Enchanted Book", (TextColor)((TextColor)NamedTextColor.YELLOW)))).append((Component)Component.text((String)" ("));
                Intrinsics.checkNotNullExpressionValue(componentBuilder, "append(...)");
                TextComponent.Builder bookTitle = (TextComponent.Builder)componentBuilder;
                int i = 0;
                Map map = ((EnchantmentStorageMeta)bookInSlotMeta).getStoredEnchants();
                Intrinsics.checkNotNullExpressionValue(map, "getStoredEnchants(...)");
                for (Map.Entry entry : map.entrySet()) {
                    Enchantment enchantment = (Enchantment)entry.getKey();
                    Integer level = (Integer)entry.getValue();
                    String namespaceString = enchantment.getKey().getNamespace() + ":";
                    String string = enchantment.getKey().toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    bookTitle = (TextComponent.Builder)bookTitle.append((Component)Component.text((String)Utils.capitalizeWords$default(Utils.INSTANCE, StringsKt.replace$default(StringsKt.replace$default(string, namespaceString, "", false, 4, null), "_", " ", false, 4, null), null, 1, null)));
                    Intrinsics.checkNotNull(level);
                    bookTitle = (TextComponent.Builder)bookTitle.append((Component)Component.text((String)(" " + Utils.INSTANCE.intToRoman(level))));
                    if (((EnchantmentStorageMeta)bookInSlotMeta).getStoredEnchants().size() > 1 && i != ((EnchantmentStorageMeta)bookInSlotMeta).getStoredEnchants().size() - 1) {
                        bookTitle = (TextComponent.Builder)bookTitle.append((Component)Component.text((String)", "));
                    }
                    ++i;
                }
                bookTitle = (TextComponent.Builder)bookTitle.append((Component)Component.text((String)")"));
                player.sendActionBar((Component)bookTitle.build());
                continue;
            }
            if (bookInSlotMeta == null) continue;
            if (bookInSlotMeta.hasDisplayName()) {
                player.sendActionBar((Component)Component.text((String)bookInSlotMeta.getDisplayName()));
                continue;
            }
            player.sendActionBar((Component)Component.text((String)""));
        }
    }
}

