/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.regionplus;

import dev.akatriggered.regionplus.listeners.RegionTracker;
import dev.akatriggered.regionplus.placeholders.RegionPlaceholders;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RegionPlus
extends JavaPlugin {
    private static RegionPlus instance;
    private RegionTracker regionTracker;

    public void onEnable() {
        instance = this;
        if (!this.checkDependencies()) {
            this.getLogger().severe("Missing required dependencies! Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.regionTracker = new RegionTracker(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.regionTracker, (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new RegionPlaceholders(this).register();
            this.getLogger().info("PlaceholderAPI integration enabled!");
        }
        this.getLogger().info("RegionPlus enabled successfully!");
    }

    public void onDisable() {
        this.getLogger().info("RegionPlus disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("regionplus")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cThis command can only be used by players!");
                return true;
            }
            Player player = (Player)sender;
            sender.sendMessage("\u00a76=== RegionPlus Debug ===");
            sender.sendMessage("\u00a77Player regions: " + String.valueOf(this.regionTracker.getPlayerRegions(player.getUniqueId())));
            sender.sendMessage("\u00a77Total regions on server: " + this.regionTracker.getAllRegions().size());
            sender.sendMessage("\u00a77All regions: " + String.valueOf(this.regionTracker.getAllRegions()));
            this.regionTracker.updatePlayerRegions(player);
            sender.sendMessage("\u00a7aForced region update!");
            return true;
        }
        return false;
    }

    private boolean checkDependencies() {
        return this.getServer().getPluginManager().getPlugin("WorldGuard") != null;
    }

    public static RegionPlus getInstance() {
        return instance;
    }

    public RegionTracker getRegionTracker() {
        return this.regionTracker;
    }
}

