/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.regionplus.listeners;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import dev.akatriggered.regionplus.RegionPlus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class RegionTracker
implements Listener {
    private final RegionPlus plugin;
    private final Map<UUID, Set<String>> playerRegions = new ConcurrentHashMap<UUID, Set<String>>();
    private final Map<String, Set<UUID>> regionPlayers = new ConcurrentHashMap<String, Set<UUID>>();

    public RegionTracker(RegionPlus plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        this.updatePlayerRegions(event.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.updatePlayerRegions(event.getPlayer()), 20L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        Set<String> regions = this.playerRegions.remove(playerId);
        if (regions != null) {
            for (String region : regions) {
                Set<UUID> players = this.regionPlayers.get(region);
                if (players == null) continue;
                players.remove(playerId);
                if (!players.isEmpty()) continue;
                this.regionPlayers.remove(region);
            }
        }
    }

    public void updatePlayerRegions(Player player) {
        try {
            RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)player.getWorld()));
            if (manager == null) {
                this.plugin.getLogger().warning("RegionManager is null for world: " + player.getWorld().getName());
                return;
            }
            ApplicableRegionSet regions = manager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)player.getLocation()));
            HashSet<String> currentRegions = new HashSet<String>();
            for (ProtectedRegion region : regions) {
                currentRegions.add(region.getId());
                this.plugin.getLogger().info("Player " + player.getName() + " is in region: " + region.getId());
            }
            UUID playerId = player.getUniqueId();
            Set previousRegions = this.playerRegions.getOrDefault(playerId, new HashSet());
            for (String region : previousRegions) {
                Set<UUID> players;
                if (currentRegions.contains(region) || (players = this.regionPlayers.get(region)) == null) continue;
                players.remove(playerId);
                if (!players.isEmpty()) continue;
                this.regionPlayers.remove(region);
            }
            for (String region : currentRegions) {
                this.regionPlayers.computeIfAbsent(region, k -> new HashSet()).add(playerId);
            }
            this.playerRegions.put(playerId, currentRegions);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error updating player regions: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Set<String> getPlayerRegions(UUID playerId) {
        return this.playerRegions.getOrDefault(playerId, new HashSet());
    }

    public int getRegionPlayerCount(String regionName) {
        Set<UUID> players = this.regionPlayers.get(regionName);
        int count = players != null ? players.size() : 0;
        this.plugin.getLogger().info("Region " + regionName + " has " + count + " players");
        return count;
    }

    public Set<UUID> getRegionPlayers(String regionName) {
        return this.regionPlayers.getOrDefault(regionName, new HashSet());
    }

    public List<String> getAllRegions() {
        ArrayList<String> allRegions = new ArrayList<String>();
        for (World world : this.plugin.getServer().getWorlds()) {
            RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
            if (manager == null) continue;
            allRegions.addAll(manager.getRegions().keySet());
        }
        return allRegions;
    }
}

