/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.regionplus.placeholders;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import dev.akatriggered.regionplus.RegionPlus;
import java.util.Set;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class RegionPlaceholders
extends PlaceholderExpansion {
    private final RegionPlus plugin;

    public RegionPlaceholders(RegionPlus plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "regionplus";
    }

    public String getAuthor() {
        return "akatriggered";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, String params) {
        if (player == null) {
            return "";
        }
        if (params.equals("current_region")) {
            Set<String> regions = this.plugin.getRegionTracker().getPlayerRegions(player.getUniqueId());
            return regions.isEmpty() ? "wilderness" : regions.iterator().next();
        }
        if (params.equals("current_regions")) {
            Set<String> regions = this.plugin.getRegionTracker().getPlayerRegions(player.getUniqueId());
            return regions.isEmpty() ? "wilderness" : String.join((CharSequence)", ", regions);
        }
        if (params.equals("region_count")) {
            return String.valueOf(this.plugin.getRegionTracker().getPlayerRegions(player.getUniqueId()).size());
        }
        if (params.startsWith("players_")) {
            String regionName = params.substring(8);
            return String.valueOf(this.plugin.getRegionTracker().getRegionPlayerCount(regionName));
        }
        if (params.startsWith("in_")) {
            String regionName = params.substring(3);
            Set<String> regions = this.plugin.getRegionTracker().getPlayerRegions(player.getUniqueId());
            return regions.contains(regionName) ? "true" : "false";
        }
        if (params.startsWith("priority_")) {
            ProtectedRegion region;
            String regionName = params.substring(9);
            RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)player.getWorld()));
            if (manager != null && (region = manager.getRegion(regionName)) != null) {
                return String.valueOf(region.getPriority());
            }
            return "0";
        }
        if (params.startsWith("owner_")) {
            ProtectedRegion region;
            String regionName = params.substring(6);
            RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)player.getWorld()));
            if (manager != null && (region = manager.getRegion(regionName)) != null && !region.getOwners().getPlayers().isEmpty()) {
                return ((String)region.getOwners().getPlayers().iterator().next()).toString();
            }
            return "none";
        }
        if (params.startsWith("is_owner_")) {
            ProtectedRegion region;
            String regionName = params.substring(9);
            RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)player.getWorld()));
            if (manager != null && (region = manager.getRegion(regionName)) != null) {
                return region.getOwners().contains(player.getUniqueId()) ? "true" : "false";
            }
            return "false";
        }
        if (params.startsWith("is_member_")) {
            ProtectedRegion region;
            String regionName = params.substring(10);
            RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)player.getWorld()));
            if (manager != null && (region = manager.getRegion(regionName)) != null) {
                return region.getMembers().contains(player.getUniqueId()) ? "true" : "false";
            }
            return "false";
        }
        if (params.equals("total_regions")) {
            return String.valueOf(this.plugin.getRegionTracker().getAllRegions().size());
        }
        return null;
    }
}

