/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.GhostEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GhostPlaceGoal
extends Goal {
    private final GhostEntity ghost;
    private final Ingredient placeables;
    private final Predicate<BlockState> preference;
    private final int minLight;
    private final int retryCooldown;
    private final double approachSpeed;
    private static final double DIST_2_PLACE_TORCH = 1.0;
    private static final double STOP_DIST = 49.0;
    private static final double APPROACH_BACKSLASH = 0.5;
    private static final int IGNORE_RECENT_TORCH = 100;
    private int nextTryTickk = 0;
    private BlockPos basePos = null;
    private Vec3 approachPos = null;
    private int stuckTicks = 0;
    private Vec3 lastPos = null;
    private BlockPos recentUp = null;
    private int avoidLatest = 0;

    public GhostPlaceGoal(GhostEntity ghost, Ingredient placeables, Predicate<BlockState> pref, int lightThreshold, int retry, double speed) {
        this.ghost = ghost;
        this.placeables = placeables;
        this.preference = pref;
        this.minLight = lightThreshold;
        this.retryCooldown = Math.max(5, retry);
        this.approachSpeed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.ghost.m_21825_() || this.ghost.m_20159_()) {
            return false;
        }
        if (this.ghost.f_19797_ < this.nextTryTickk) {
            return false;
        }
        ItemStack stack = this.ghost.getHoldItem();
        if (stack.m_41619_() || !this.placeables.test(stack) || !(stack.m_41720_() instanceof BlockItem)) {
            return false;
        }
        BlockPos base = this.findBlock(this.ghost.m_9236_());
        if (base == null) {
            return false;
        }
        BlockPos above = base.m_7494_();
        Level level = this.ghost.m_9236_();
        if (!this.preference.test(level.m_8055_(base))) {
            return false;
        }
        if (!level.m_8055_(above).m_247087_()) {
            return false;
        }
        if (level.m_46803_(above) > this.minLight) {
            return false;
        }
        if (!((BlockItem)stack.m_41720_()).m_40614_().m_49966_().m_60710_((LevelReader)level, above)) {
            return false;
        }
        this.basePos = base;
        this.approachPos = new Vec3((double)this.basePos.m_123341_() + 0.5, (double)this.basePos.m_123342_() + 1.2, (double)this.basePos.m_123343_() + 0.5);
        this.stuckTicks = 0;
        this.lastPos = this.ghost.m_20182_();
        return true;
    }

    private boolean isRecentlyPlacedInA(BlockPos up) {
        if (this.recentUp == null) {
            return false;
        }
        if (this.ghost.f_19797_ > this.avoidLatest) {
            return false;
        }
        int dx = Math.abs(up.m_123341_() - this.recentUp.m_123341_());
        int dy = Math.abs(up.m_123342_() - this.recentUp.m_123342_());
        int dz = Math.abs(up.m_123343_() - this.recentUp.m_123343_());
        return dx <= 1 && dy <= 1 && dz <= 1;
    }

    public boolean m_8045_() {
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.basePos == null || this.approachPos == null) {
            return false;
        }
        ItemStack stack = this.ghost.getHoldItem();
        if (stack.m_41619_() || !this.placeables.test(stack) || !(stack.m_41720_() instanceof BlockItem)) {
            return false;
        }
        if (!this.ghost.m_9236_().m_8055_(this.basePos.m_7494_()).m_247087_()) {
            return false;
        }
        if (this.ghost.m_9236_().m_46803_(this.basePos.m_7494_()) > this.minLight) {
            return false;
        }
        return this.ghost.m_269323_() == null || !(this.ghost.m_20280_((Entity)this.ghost.m_269323_()) > 49.0);
    }

    public void m_8056_() {
        Vec3 to = this.goBackAfterPlacing(this.approachPos);
        this.ghost.m_21573_().m_26519_(to.f_82479_, to.f_82480_, to.f_82481_, this.approachSpeed);
        this.ghost.m_21566_().m_6849_(to.f_82479_, to.f_82480_, to.f_82481_, this.approachSpeed);
    }

    public void m_8041_() {
        this.basePos = null;
        this.approachPos = null;
        this.lastPos = null;
        this.stuckTicks = 0;
        this.ghost.m_21573_().m_26573_();
        this.nextTryTickk = this.ghost.f_19797_ + this.retryCooldown;
    }

    public void m_8037_() {
        if (this.basePos == null) {
            return;
        }
        BlockPos up = this.basePos.m_7494_();
        Vec3 u = new Vec3((double)up.m_123341_() + 0.5, (double)up.m_123342_() + 0.5, (double)up.m_123343_() + 0.5);
        this.ghost.m_21563_().m_24946_(u.f_82479_, u.f_82480_, u.f_82481_);
        if (this.lastPos != null) {
            this.stuckTicks = this.lastPos.m_82554_(this.ghost.m_20182_()) < 0.02 ? ++this.stuckTicks : 0;
        }
        this.lastPos = this.ghost.m_20182_();
        Vec3 wanted = this.goBackAfterPlacing(this.approachPos);
        if (this.stuckTicks > 8) {
            this.ghost.m_21573_().m_26519_(wanted.f_82479_, wanted.f_82480_, wanted.f_82481_, this.approachSpeed);
            this.ghost.m_21566_().m_6849_(wanted.f_82479_, wanted.f_82480_, wanted.f_82481_, this.approachSpeed);
            this.stuckTicks = 0;
        }
        if (this.ghost.m_20182_().m_82554_(u) <= 1.0 && this.canSeePos(up)) {
            this.place(up);
            return;
        }
        if (this.ghost.m_20182_().m_82554_(wanted) > 0.25) {
            this.ghost.m_21573_().m_26519_(wanted.f_82479_, wanted.f_82480_, wanted.f_82481_, this.approachSpeed);
            this.ghost.m_21566_().m_6849_(wanted.f_82479_, wanted.f_82480_, wanted.f_82481_, this.approachSpeed);
        }
    }

    private void place(BlockPos up) {
        Item item;
        ItemStack stack = this.ghost.getHoldItem();
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BlockItem)) {
            this.m_8041_();
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!this.ghost.m_9236_().m_8055_(up).m_247087_() || !blockItem.m_40614_().m_49966_().m_60710_((LevelReader)this.ghost.m_9236_(), up)) {
            this.m_8041_();
            return;
        }
        this.ghost.triggerAnim("torch_place_controller", "torch_place");
        this.ghost.m_9236_().m_7731_(up, blockItem.m_40614_().m_49966_(), 3);
        stack.m_41774_(1);
        if (stack.m_41619_()) {
            this.ghost.setHoldItem(ItemStack.f_41583_);
        }
        this.recentUp = up.m_7949_();
        this.avoidLatest = this.ghost.f_19797_ + 100;
        this.m_8041_();
    }

    public boolean m_183429_() {
        return true;
    }

    private Vec3 goBackAfterPlacing(Vec3 target) {
        double d = target.m_82546_(this.ghost.m_20182_()).m_82553_();
        if (d < 0.001) {
            return target;
        }
        return this.ghost.m_20182_().m_82549_(target.m_82546_(this.ghost.m_20182_()).m_82490_(Math.max(0.0, d - 0.5) / d));
    }

    private boolean canSeePos(BlockPos up) {
        Vec3 target = new Vec3((double)up.m_123341_() + 0.5, (double)up.m_123342_() + 0.5, (double)up.m_123343_() + 0.5);
        BlockHitResult hit = this.ghost.m_9236_().m_45547_(new ClipContext(this.ghost.m_146892_(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.ghost));
        if (hit.m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        if (hit instanceof BlockHitResult) {
            BlockHitResult bhr = hit;
            return bhr.m_82425_().equals((Object)up);
        }
        return false;
    }

    private BlockPos findBlock(Level level) {
        for (int dy = 0; dy <= 4; ++dy) {
            BlockPos[] possiblePositions;
            BlockPos pos = new BlockPos(Mth.m_14107_((double)this.ghost.m_20185_()), Mth.m_14107_((double)this.ghost.m_20186_()) - 1 - dy, Mth.m_14107_((double)this.ghost.m_20189_()));
            if (level.m_8055_(pos).m_60795_()) continue;
            for (BlockPos b : possiblePositions = new BlockPos[]{pos, pos.m_122029_(), pos.m_122024_(), pos.m_122012_(), pos.m_122019_()}) {
                BlockPos up = b.m_7494_();
                if (this.isRecentlyPlacedInA(up) || !this.preference.test(level.m_8055_(b)) || !level.m_8055_(up).m_247087_() || level.m_46803_(up) > this.minLight) continue;
                return b;
            }
        }
        return null;
    }
}

