/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ghost;

import dev.xylonity.bonsai.ghosts.common.entity.AbstractGhostEntity;
import dev.xylonity.bonsai.ghosts.common.entity.ai.control.GhostMoveControl;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.GhostApproachHeldGlowBerriesGoal;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.GhostFollowOwnerGoal;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.GhostPlaceGoal;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.GhostWanderGoal;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.StayWhenOrderedToGoal;
import dev.xylonity.bonsai.ghosts.registry.GhostsSounds;
import dev.xylonity.bonsai.ghosts.tag.GhostsTags;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GhostEntity
extends AbstractGhostEntity {
    private static final EntityDataAccessor<Boolean> SHOULD_RESET_CD = SynchedEntityData.m_135353_(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BLINK_CD = SynchedEntityData.m_135353_(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BLINK_ANIM_CD = SynchedEntityData.m_135353_(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOULD_UNENCHANT = SynchedEntityData.m_135353_(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int cdUnenchant = 0;

    public GhostEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, -1.0f);
        this.m_21441_(BlockPathTypes.LEAVES, -1.0f);
        this.f_21342_ = new GhostMoveControl(this);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, level);
        navigator.m_26440_(false);
        navigator.m_7008_(true);
        navigator.m_26443_(true);
        return navigator;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return AbstractGolem.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22280_, (double)0.3f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new StayWhenOrderedToGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new GhostApproachHeldGlowBerriesGoal(this, 0.6, 1.6, 6.0, 0.1f, 12));
        this.f_21345_.m_25352_(7, (Goal)new GhostFollowOwnerGoal(this, 0.6, 3.0, 7.0, 0.2f));
        this.f_21345_.m_25352_(6, (Goal)new GhostPlaceGoal(this, Ingredient.m_204132_(GhostsTags.GHOST_PLACEABLE), state -> true, 6, 10, 0.75));
        this.f_21345_.m_25352_(9, (Goal)new GhostWanderGoal(this, 0.43f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOULD_RESET_CD, (Object)false);
        this.f_19804_.m_135372_(BLINK_CD, (Object)0);
        this.f_19804_.m_135372_(BLINK_ANIM_CD, (Object)0);
        this.f_19804_.m_135372_(SHOULD_UNENCHANT, (Object)false);
    }

    public void setHoldItem(ItemStack holdItem) {
        if (this.shouldUnechant()) {
            this.setShouldUnenchant(false);
            this.setCdUnenchant(0);
        }
        if (holdItem.m_41793_()) {
            this.setShouldUnenchant(true);
            this.setCdUnenchant(82);
        }
        this.m_21468_(EquipmentSlot.MAINHAND, holdItem);
    }

    public int getCdUnenchant() {
        return this.cdUnenchant;
    }

    public void setCdUnenchant(int cd) {
        this.cdUnenchant = cd;
    }

    public int getBlinkCd() {
        return (Integer)this.f_19804_.m_135370_(BLINK_CD);
    }

    public void setBlinkCd(int cd) {
        this.f_19804_.m_135381_(BLINK_CD, (Object)cd);
    }

    public int getBlinkAnimCd() {
        return (Integer)this.f_19804_.m_135370_(BLINK_ANIM_CD);
    }

    public void setBlinkAnimCd(int cd) {
        this.f_19804_.m_135381_(BLINK_ANIM_CD, (Object)cd);
    }

    public void setShouldResetCd(boolean shouldResetCd) {
        this.f_19804_.m_135381_(SHOULD_RESET_CD, (Object)shouldResetCd);
    }

    public boolean getShouldResetCd() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_RESET_CD);
    }

    private void setShouldUnenchant(boolean shouldUnenchant) {
        this.f_19804_.m_135381_(SHOULD_UNENCHANT, (Object)shouldUnenchant);
    }

    private boolean shouldUnechant() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_UNENCHANT);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("CdUnenchant", this.getCdUnenchant());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.m_21824_() && stack.m_41720_() == Items.f_151079_) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(player);
                this.m_21530_();
                this.f_21344_.m_26573_();
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                return InteractionResult.SUCCESS;
            }
            this.m_9236_().m_7605_((Entity)this, (byte)6);
            return InteractionResult.FAIL;
        }
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && player == this.m_269323_()) {
            if (player.m_6144_()) {
                if (stack.m_41720_() == Items.f_151079_ && this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(4.0f);
                } else {
                    if (this.m_6844_(EquipmentSlot.HEAD).m_41619_() && (Mob.m_147233_((ItemStack)stack) == EquipmentSlot.HEAD || stack.m_150930_(Items.f_41952_) || stack.m_150930_(Items.f_41953_))) {
                        ItemStack copy = stack.m_41777_();
                        copy.m_41764_(1);
                        this.m_21468_(EquipmentSlot.HEAD, copy);
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (!stack.m_41619_() && this.getHoldItem().m_41619_()) {
                        this.setHoldItem(stack.m_41777_());
                        stack.m_41764_(0);
                    } else if (!this.getHoldItem().m_41619_()) {
                        this.m_5552_(this.getHoldItem(), 0.5f);
                        this.setHoldItem(ItemStack.f_41583_);
                    } else if (!this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                        this.m_5552_(this.m_6844_(EquipmentSlot.HEAD), 0.5f);
                        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
            } else {
                this.cycleMainInteraction(player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int m_213860_() {
        return 1 + this.m_9236_().f_46441_.m_216339_(2, 4);
    }

    public void m_8119_() {
        ItemStack heldItemStack;
        super.m_8119_();
        this.m_20242_(true);
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.rotateBody();
        if (this.getBlinkCd() > 0) {
            this.setBlinkCd(this.getBlinkCd() - 1);
        } else if (this.getBlinkAnimCd() > 0) {
            this.setBlinkAnimCd(this.getBlinkAnimCd() - 1);
        } else if (this.getShouldResetCd()) {
            this.setShouldResetCd(false);
            this.setBlinkCd(this.f_19796_.m_216339_(80, 120));
        } else {
            this.setShouldResetCd(true);
            this.setBlinkAnimCd(6);
        }
        if (this.getCdUnenchant() > 0) {
            this.setCdUnenchant(this.getCdUnenchant() - 1);
        }
        if ((heldItemStack = this.getHoldItem()).m_41793_()) {
            if (this.getCdUnenchant() == 10 && this.shouldUnechant()) {
                this.m_5552_(this.removeEnchants(heldItemStack), 0.5f);
                this.setHoldItem(ItemStack.f_41583_);
                this.setShouldUnenchant(false);
            } else if (this.getCdUnenchant() == 0) {
                if (!this.shouldUnechant()) {
                    this.startUnenchantAnim();
                } else {
                    this.m_5552_(this.removeEnchants(heldItemStack), 0.5f);
                    this.setHoldItem(ItemStack.f_41583_);
                    this.setShouldUnenchant(false);
                }
            }
        }
    }

    private void startUnenchantAnim() {
        this.setCdUnenchant(82);
        this.setShouldUnenchant(true);
    }

    private ItemStack removeEnchants(ItemStack item) {
        ItemStack itemstack = item.m_41777_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ExperienceOrb.m_147082_((ServerLevel)level2, (Vec3)this.m_20318_(0.0f), (int)this.getExperienceFromItem(itemstack));
        }
        if (!itemstack.m_41785_().isEmpty()) {
            int i = this.f_19796_.m_188503_(itemstack.m_41785_().size());
            itemstack.m_41785_().remove(i);
        }
        itemstack.m_41749_("StoredEnchantments");
        itemstack.m_41742_(AnvilMenu.m_39025_((int)itemstack.m_41610_()));
        return itemstack.m_41777_();
    }

    private int getExperienceFromItem(ItemStack p_39637_) {
        int l = 0;
        Map map = EnchantmentHelper.m_44831_((ItemStack)p_39637_);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            if (enchantment.m_6589_()) continue;
            l += enchantment.m_6183_(integer.intValue());
        }
        return l;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("CdUnenchant")) {
            this.setCdUnenchant(compound.m_128451_("CdUnenchant"));
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return GhostsSounds.GHOST_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return GhostsSounds.GHOST_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return GhostsSounds.GHOST_HURT.get();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        return super.m_6518_(levelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "bodyController", 4, this::bodyAC)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "armsController", 4, this::armsAC)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "blinkController", 2, this::blinkAC)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "torch_place_controller", 2, state -> PlayState.STOP).triggerableAnim("torch_place", RawAnimation.begin().thenPlay("torch_place"))});
    }

    private <E extends GeoAnimatable> PlayState bodyAC(AnimationState<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_move"));
        } else if (this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_sitting"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState blinkAC(AnimationState<E> event) {
        if (this.getBlinkCd() == 0) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_blink"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState armsAC(AnimationState<E> event) {
        boolean hasItem;
        boolean bl = hasItem = !this.getHoldItem().m_41619_();
        if (hasItem) {
            if (this.shouldUnechant()) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_unenchant"));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_arms_hold"));
            }
        } else if (this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_idle_arms"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop(event.isMoving() ? "ghost_move_arms" : "ghost_idle_arms"));
        }
        return PlayState.CONTINUE;
    }
}

