/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ghost;

import dev.xylonity.bonsai.ghosts.common.entity.AbstractGhostEntity;
import dev.xylonity.bonsai.ghosts.common.entity.ai.control.GhostMoveControl;
import dev.xylonity.bonsai.ghosts.common.entity.ai.generic.GhostWanderGoal;
import dev.xylonity.bonsai.ghosts.common.entity.variant.SmallGhostVariant;
import dev.xylonity.bonsai.ghosts.registry.GhostsSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SmallGhostEntity
extends AbstractGhostEntity {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(SmallGhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CD_FULL_HIDE = SynchedEntityData.m_135353_(SmallGhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_STAYING = SynchedEntityData.m_135353_(SmallGhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SLEEPING = SynchedEntityData.m_135353_(SmallGhostEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SmallGhostEntity(EntityType<? extends TamableAnimal> entity, Level world) {
        super(entity, world);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, -1.0f);
        this.m_21441_(BlockPathTypes.LEAVES, -1.0f);
        this.f_21342_ = new GhostMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new GhostWanderGoal(this, 0.43f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !SmallGhostEntity.this.getIsSleeping();
            }
        });
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, level);
        navigator.m_26440_(false);
        navigator.m_7008_(true);
        navigator.m_26443_(true);
        return navigator;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return AbstractGolem.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, (double)0.3f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_STAYING, (Object)false);
        this.f_19804_.m_135372_(IS_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(CD_FULL_HIDE, (Object)0);
    }

    public void setIsStaying(boolean isStaying) {
        this.f_19804_.m_135381_(IS_STAYING, (Object)isStaying);
    }

    public boolean getIsStaying() {
        return (Boolean)this.f_19804_.m_135370_(IS_STAYING);
    }

    public void setHoldItem(ItemStack holdItem) {
        this.m_21468_(EquipmentSlot.MAINHAND, holdItem);
    }

    @Override
    public ItemStack getHoldItem() {
        return this.m_6844_(EquipmentSlot.MAINHAND);
    }

    public void setIsSleeping(boolean isSleeping) {
        this.f_19804_.m_135381_(IS_SLEEPING, (Object)isSleeping);
    }

    public boolean getIsSleeping() {
        return (Boolean)this.f_19804_.m_135370_(IS_SLEEPING);
    }

    public int getCdFullHide() {
        return (Integer)this.f_19804_.m_135370_(CD_FULL_HIDE);
    }

    public void setCdFullHide(int cd) {
        this.f_19804_.m_135381_(CD_FULL_HIDE, (Object)cd);
    }

    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public SmallGhostVariant getVariant() {
        return SmallGhostVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(SmallGhostVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant & 0xFF));
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Variant", this.getVariant().getId());
        compoundTag.m_128405_("CdFullHide", this.getCdFullHide());
        compoundTag.m_128379_("IsStaying", this.getIsStaying());
        compoundTag.m_128379_("IsSleeping", this.getIsSleeping());
    }

    public int m_213860_() {
        return 1 + this.m_9236_().f_46441_.m_216339_(2, 4);
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(Entity entity) {
        if (!this.getIsSleeping()) {
            super.m_7334_(entity);
        }
    }

    protected void m_7324_(Entity entity) {
        if (!this.getIsSleeping()) {
            super.m_7324_(entity);
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_8119_() {
        SmallGhostVariant variant;
        super.m_8119_();
        this.m_20242_(true);
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.getIsSleeping() && this.getCdFullHide() == 36) {
            BlockPos targetBlock = this.m_20183_().m_7495_();
            BlockState belowState = this.m_9236_().m_8055_(targetBlock);
            if (!belowState.m_60795_() && this.m_9236_() instanceof ServerLevel) {
                this.f_19794_ = true;
                this.m_20256_(Vec3.f_82478_);
                this.m_6034_(this.m_20185_(), (double)targetBlock.m_123342_() + 1.0 + 0.15 - (double)this.m_20206_() / 2.0, this.m_20189_());
            }
        }
        this.rotateBody();
        if (this.getCdFullHide() > 0) {
            this.setCdFullHide(this.getCdFullHide() - 1);
        }
        if ((variant = this.getVariant()) == SmallGhostVariant.PLANT) {
            BlockState belowBlockState = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
            if (!this.m_9236_().m_46461_() && (belowBlockState.m_60713_(Blocks.f_50440_) || belowBlockState.m_60713_(Blocks.f_50493_))) {
                if (!this.getIsSleeping()) {
                    this.setCdFullHide(36);
                }
                this.setIsSleeping(true);
            } else {
                this.setIsSleeping(false);
            }
        }
        if (this.f_19794_ && this.m_20184_().m_82556_() < 1.0E-4) {
            this.f_19794_ = false;
            this.m_20256_(Vec3.f_82478_);
        }
        if (this.getIsSleeping() && this.getCdFullHide() == 26) {
            Level level;
            BlockPos belowPos = this.m_20183_().m_7495_();
            BlockState belowState = this.m_9236_().m_8055_(belowPos);
            if (!belowState.m_60795_() && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                for (int i = 0; i < 10; ++i) {
                    double ox = (this.f_19796_.m_188500_() - 0.5) * 0.6;
                    double oz = (this.f_19796_.m_188500_() - 0.5) * 0.6;
                    double oy = this.f_19796_.m_188500_() * 0.15;
                    sl.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, belowState), this.m_20185_() + ox, this.m_20186_() + 0.05 + oy, this.m_20189_() + oz, 1, 0.0, 0.02, 0.0, 0.0);
                }
                sl.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), belowState.m_60827_().m_56775_(), this.m_5720_(), 0.8f, 0.9f + this.f_19796_.m_188501_() * 0.2f);
            }
        }
    }

    private void moveToPos(Vec3 target, double speed, float lerp) {
        Vec3 tetha = target.m_82546_(this.m_20182_());
        if (tetha.m_82553_() < 0.001) {
            return;
        }
        this.f_19794_ = true;
        Vec3 vel = tetha.m_82490_(1.0 / tetha.m_82553_()).m_82490_(speed);
        Vec3 v = this.m_20184_();
        this.m_20334_(Mth.m_14139_((double)lerp, (double)v.f_82479_, (double)vel.f_82479_), Mth.m_14139_((double)lerp, (double)v.f_82480_, (double)vel.f_82480_), Mth.m_14139_((double)lerp, (double)v.f_82481_, (double)vel.f_82481_));
        this.m_21563_().m_24946_(target.f_82479_, target.f_82480_, target.f_82481_);
    }

    @Override
    public boolean m_6469_(DamageSource source, float p) {
        Vec3 vec;
        if (source.m_7639_() != null && (vec = AirRandomPos.m_148387_((PathfinderMob)this, (int)32, (int)32, (int)32, (Vec3)new Vec3(32.0, 32.0, 32.0), (double)32.0)) != null) {
            this.moveToPos(vec, 0.55, 0.6f);
        }
        return super.m_6469_(source, p);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("Variant")) {
            this.setVariant(compoundTag.m_128451_("Variant"));
        }
        if (compoundTag.m_128441_("CdFullHide")) {
            this.setCdFullHide(compoundTag.m_128451_("CdFullHide"));
        }
        if (compoundTag.m_128441_("IsStaying")) {
            this.setIsStaying(compoundTag.m_128471_("IsStaying"));
        }
        if (compoundTag.m_128441_("IsSleeping")) {
            this.setIsSleeping(compoundTag.m_128471_("IsSleeping"));
        } else if (compoundTag.m_128441_("IsHiding")) {
            this.setIsSleeping(compoundTag.m_128471_("IsHiding"));
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return GhostsSounds.SMALL_GHOST_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return GhostsSounds.SMALL_GHOST_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return GhostsSounds.SMALL_GHOST_HURT.get();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setVariant(levelAccessor.m_213780_().m_188499_() ? SmallGhostVariant.PLANT : SmallGhostVariant.NORMAL);
        return super.m_6518_(levelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag);
    }

    private <E extends GeoAnimatable> PlayState bodyAC(AnimationState<E> event) {
        if (event.isMoving() && !this.getIsSleeping()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_move"));
            return PlayState.CONTINUE;
        }
        if (this.getIsSleeping()) {
            if (this.getCdFullHide() > 0) {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("ghost_bury"));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenPlay("mini_ghost_buried"));
            }
            return PlayState.CONTINUE;
        }
        if (!this.getIsSleeping() && !event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("ghost_idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState armsAC(AnimationState<E> event) {
        if (!this.getHoldItem().m_41619_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("mini_ghost_arms_hold"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop(event.isMoving() ? "ghost_move_arms" : "ghost_idle_arms"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "small_ghost_animation_controller_body", 1, this::bodyAC)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "small_ghost_animation_controller_arms", 1, this::armsAC)});
    }
}

