/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.kodama;

import dev.xylonity.bonsai.ghosts.common.entity.PassiveEntity;
import dev.xylonity.bonsai.ghosts.registry.GhostsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.InstancedAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class KodamaEntity
extends PassiveEntity {
    private final AnimatableInstanceCache cache = new InstancedAnimatableInstanceCache((GeoAnimatable)this);
    private final RawAnimation RATTLE = RawAnimation.begin().thenPlay("rattle");
    private final RawAnimation RATTLE_2 = RawAnimation.begin().thenPlay("rattle_2");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RATTLING_TICKS = SynchedEntityData.m_135353_(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int ANIMATION_RATTLING_TICKS = 38;
    private float flashAlpha = 0.0f;
    private int rattleAnimationType;

    public KodamaEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return AbstractGolem.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, (double)0.3f).m_22268_(Attributes.f_22279_, (double)0.24f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f, 1.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(RATTLING_TICKS, (Object)0);
    }

    public void setFlashAlpha(float flashAlpha) {
        this.flashAlpha = flashAlpha;
    }

    public float getFlashAlpha() {
        return this.flashAlpha;
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setRattlingTicks(int variant) {
        this.f_19804_.m_135381_(RATTLING_TICKS, (Object)variant);
    }

    public int getRattlingTicks() {
        return (Integer)this.f_19804_.m_135370_(RATTLING_TICKS);
    }

    protected boolean shouldPanic() {
        return this.m_21188_() != null || this.m_203117_() || this.m_6060_();
    }

    public void m_8119_() {
        Vec3 currentPos = this.m_20182_();
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean ok;
            long dayTime = this.m_9236_().m_46468_() % 24000L;
            if (!this.shouldPanic() && this.getRattlingTicks() <= 0) {
                if (dayTime >= 13000L && dayTime <= 13200L) {
                    this.startRattling(0.3f);
                } else {
                    this.startRattling(0.001f);
                }
            }
            boolean bl = ok = !this.shouldPanic() && this.getRattlingTicks() > 0 && this.m_20096_();
            if (!ok) {
                this.setRattlingTicks(0);
            }
            if (this.getRattlingTicks() > 0) {
                this.setRattlingTicks(this.getRattlingTicks() - 1);
            }
            if (this.getRattlingTicks() > 0) {
                this.m_21573_().m_26573_();
                this.m_146884_(currentPos);
            }
        }
    }

    private void startRattling(float chance) {
        if (this.m_9236_().f_46441_.m_188501_() > chance) {
            return;
        }
        this.setRattlingTicks(38);
        this.m_9236_().m_5594_(null, this.m_20183_(), GhostsSounds.KODAMA_RATTLE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Variant")) {
            this.setVariant(compound.m_128451_("Variant"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public static boolean checkKodamaSpawnRules(EntityType<? extends Animal> kodama, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return KodamaEntity.isDarkEnoughToSpawn(level, pos, random) && KodamaEntity.m_217057_(kodama, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        if (level.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        DimensionType dimensiontype = level.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && level.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = level.m_6018_().m_46470_() ? level.m_46849_(pos, 10) : level.m_46803_(pos);
        return j <= dimensiontype.m_223569_().m_214085_(random);
    }

    public int m_213860_() {
        return this.m_9236_().f_46441_.m_188503_(4) + 2;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData, CompoundTag dataTag) {
        if (this.getVariant() == 0) {
            this.setVariant(level.m_6018_().f_46441_.m_188503_(4) + 1);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected SoundEvent m_7515_() {
        return GhostsSounds.KODAMA_IDLE.get();
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getRattlingTicks() == 37) {
            this.rattleAnimationType = this.m_9236_().f_46441_.m_188503_(2);
        }
        if (this.getRattlingTicks() > 0) {
            event.setAnimation(this.rattleAnimationType == 0 ? this.RATTLE : this.RATTLE_2);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

