/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.GhostEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public class GhostPlaceGoal
extends class_1352 {
    private final GhostEntity ghost;
    private final class_1856 placeables;
    private final Predicate<class_2680> preference;
    private final int minLight;
    private final int retryCooldown;
    private final double approachSpeed;
    private static final double DIST_2_PLACE_TORCH = 1.0;
    private static final double STOP_DIST = 49.0;
    private static final double APPROACH_BACKSLASH = 0.5;
    private static final int IGNORE_RECENT_TORCH = 100;
    private int nextTryTickk = 0;
    private class_2338 basePos = null;
    private class_243 approachPos = null;
    private int stuckTicks = 0;
    private class_243 lastPos = null;
    private class_2338 recentUp = null;
    private int avoidLatest = 0;

    public GhostPlaceGoal(GhostEntity ghost, class_1856 placeables, Predicate<class_2680> pref, int lightThreshold, int retry, double speed) {
        this.ghost = ghost;
        this.placeables = placeables;
        this.preference = pref;
        this.minLight = lightThreshold;
        this.retryCooldown = Math.max(5, retry);
        this.approachSpeed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.ghost.method_6172() || this.ghost.method_5765()) {
            return false;
        }
        if (this.ghost.field_6012 < this.nextTryTickk) {
            return false;
        }
        class_1799 stack = this.ghost.getHoldItem();
        if (stack.method_7960() || !this.placeables.method_8093(stack) || !(stack.method_7909() instanceof class_1747)) {
            return false;
        }
        class_2338 base = this.findBlock(this.ghost.method_37908());
        if (base == null) {
            return false;
        }
        class_2338 above = base.method_10084();
        class_1937 level = this.ghost.method_37908();
        if (!this.preference.test(level.method_8320(base))) {
            return false;
        }
        if (!level.method_8320(above).method_45474()) {
            return false;
        }
        if (level.method_22339(above) > this.minLight) {
            return false;
        }
        if (!((class_1747)stack.method_7909()).method_7711().method_9564().method_26184((class_4538)level, above)) {
            return false;
        }
        this.basePos = base;
        this.approachPos = new class_243((double)this.basePos.method_10263() + 0.5, (double)this.basePos.method_10264() + 1.2, (double)this.basePos.method_10260() + 0.5);
        this.stuckTicks = 0;
        this.lastPos = this.ghost.method_19538();
        return true;
    }

    private boolean isRecentlyPlacedInA(class_2338 up) {
        if (this.recentUp == null) {
            return false;
        }
        if (this.ghost.field_6012 > this.avoidLatest) {
            return false;
        }
        int dx = Math.abs(up.method_10263() - this.recentUp.method_10263());
        int dy = Math.abs(up.method_10264() - this.recentUp.method_10264());
        int dz = Math.abs(up.method_10260() - this.recentUp.method_10260());
        return dx <= 1 && dy <= 1 && dz <= 1;
    }

    public boolean method_6266() {
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.basePos == null || this.approachPos == null) {
            return false;
        }
        class_1799 stack = this.ghost.getHoldItem();
        if (stack.method_7960() || !this.placeables.method_8093(stack) || !(stack.method_7909() instanceof class_1747)) {
            return false;
        }
        if (!this.ghost.method_37908().method_8320(this.basePos.method_10084()).method_45474()) {
            return false;
        }
        if (this.ghost.method_37908().method_22339(this.basePos.method_10084()) > this.minLight) {
            return false;
        }
        return this.ghost.method_35057() == null || !(this.ghost.method_5858((class_1297)this.ghost.method_35057()) > 49.0);
    }

    public void method_6269() {
        class_243 to = this.goBackAfterPlacing(this.approachPos);
        this.ghost.method_5942().method_6337(to.field_1352, to.field_1351, to.field_1350, this.approachSpeed);
        this.ghost.method_5962().method_6239(to.field_1352, to.field_1351, to.field_1350, this.approachSpeed);
    }

    public void method_6270() {
        this.basePos = null;
        this.approachPos = null;
        this.lastPos = null;
        this.stuckTicks = 0;
        this.ghost.method_5942().method_6340();
        this.nextTryTickk = this.ghost.field_6012 + this.retryCooldown;
    }

    public void method_6268() {
        if (this.basePos == null) {
            return;
        }
        class_2338 up = this.basePos.method_10084();
        class_243 u = new class_243((double)up.method_10263() + 0.5, (double)up.method_10264() + 0.5, (double)up.method_10260() + 0.5);
        this.ghost.method_5988().method_20248(u.field_1352, u.field_1351, u.field_1350);
        if (this.lastPos != null) {
            this.stuckTicks = this.lastPos.method_1022(this.ghost.method_19538()) < 0.02 ? ++this.stuckTicks : 0;
        }
        this.lastPos = this.ghost.method_19538();
        class_243 wanted = this.goBackAfterPlacing(this.approachPos);
        if (this.stuckTicks > 8) {
            this.ghost.method_5942().method_6337(wanted.field_1352, wanted.field_1351, wanted.field_1350, this.approachSpeed);
            this.ghost.method_5962().method_6239(wanted.field_1352, wanted.field_1351, wanted.field_1350, this.approachSpeed);
            this.stuckTicks = 0;
        }
        if (this.ghost.method_19538().method_1022(u) <= 1.0 && this.canSeePos(up)) {
            this.place(up);
            return;
        }
        if (this.ghost.method_19538().method_1022(wanted) > 0.25) {
            this.ghost.method_5942().method_6337(wanted.field_1352, wanted.field_1351, wanted.field_1350, this.approachSpeed);
            this.ghost.method_5962().method_6239(wanted.field_1352, wanted.field_1351, wanted.field_1350, this.approachSpeed);
        }
    }

    private void place(class_2338 up) {
        class_1792 class_17922;
        class_1799 stack = this.ghost.getHoldItem();
        if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof class_1747)) {
            this.method_6270();
            return;
        }
        class_1747 blockItem = (class_1747)class_17922;
        if (!this.ghost.method_37908().method_8320(up).method_45474() || !blockItem.method_7711().method_9564().method_26184((class_4538)this.ghost.method_37908(), up)) {
            this.method_6270();
            return;
        }
        this.ghost.triggerAnim("torch_place_controller", "torch_place");
        this.ghost.method_37908().method_8652(up, blockItem.method_7711().method_9564(), 3);
        stack.method_7934(1);
        if (stack.method_7960()) {
            this.ghost.setHoldItem(class_1799.field_8037);
        }
        this.recentUp = up.method_10062();
        this.avoidLatest = this.ghost.field_6012 + 100;
        this.method_6270();
    }

    public boolean method_38846() {
        return true;
    }

    private class_243 goBackAfterPlacing(class_243 target) {
        double d = target.method_1020(this.ghost.method_19538()).method_1033();
        if (d < 0.001) {
            return target;
        }
        return this.ghost.method_19538().method_1019(target.method_1020(this.ghost.method_19538()).method_1021(Math.max(0.0, d - 0.5) / d));
    }

    private boolean canSeePos(class_2338 up) {
        class_243 target = new class_243((double)up.method_10263() + 0.5, (double)up.method_10264() + 0.5, (double)up.method_10260() + 0.5);
        class_3965 hit = this.ghost.method_37908().method_17742(new class_3959(this.ghost.method_33571(), target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.ghost));
        if (hit.method_17783() == class_239.class_240.field_1333) {
            return true;
        }
        if (hit instanceof class_3965) {
            class_3965 bhr = hit;
            return bhr.method_17777().equals((Object)up);
        }
        return false;
    }

    private class_2338 findBlock(class_1937 level) {
        for (int dy = 0; dy <= 4; ++dy) {
            class_2338[] possiblePositions;
            class_2338 pos = new class_2338(class_3532.method_15357((double)this.ghost.method_23317()), class_3532.method_15357((double)this.ghost.method_23318()) - 1 - dy, class_3532.method_15357((double)this.ghost.method_23321()));
            if (level.method_8320(pos).method_26215()) continue;
            for (class_2338 b : possiblePositions = new class_2338[]{pos, pos.method_10078(), pos.method_10067(), pos.method_10095(), pos.method_10072()}) {
                class_2338 up = b.method_10084();
                if (this.isRecentlyPlacedInA(up) || !this.preference.test(level.method_8320(b)) || !level.method_8320(up).method_45474() || level.method_22339(up) > this.minLight) continue;
                return b;
            }
        }
        return null;
    }
}

