/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.AbstractGhostEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class GhostWanderGoal
extends class_1352 {
    protected final AbstractGhostEntity ghost;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    private final boolean checkNoActionTime;
    private final float lerp;
    private class_243 targetPos;

    public GhostWanderGoal(AbstractGhostEntity ghost, double speedModifier, int interval, boolean checkNoActionTime, float lerpFactor) {
        this.ghost = ghost;
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.checkNoActionTime = checkNoActionTime;
        this.lerp = lerpFactor;
        this.forceTrigger = false;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public GhostWanderGoal(AbstractGhostEntity ghost, double speedModifier) {
        this(ghost, speedModifier, 120, false, 0.1f);
    }

    public boolean method_6264() {
        class_243 pos;
        if (this.ghost.method_5782() || this.ghost.method_6172()) {
            return false;
        }
        if (this.ghost.method_6181()) {
            boolean allow;
            int inter = this.ghost.getMainInteraction();
            boolean bl = allow = inter == 2 || inter == 1 && this.isOwnerStill();
            if (!allow) {
                return false;
            }
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.ghost.method_6131() >= 100) {
                return false;
            }
            if (this.ghost.method_6051().method_43048(GhostWanderGoal.method_38848((int)this.interval)) != 0) {
                return false;
            }
        }
        if ((pos = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = pos.field_1352;
        this.wantedY = pos.field_1351;
        this.wantedZ = pos.field_1350;
        this.forceTrigger = false;
        return true;
    }

    @Nullable
    protected class_243 getPosition() {
        class_243 origin = this.ghost.method_19538();
        for (int i = 0; i < 12; ++i) {
            double dx = (this.ghost.method_6051().method_43058() * 2.0 - 1.0) * 4.0;
            double dz = (this.ghost.method_6051().method_43058() * 2.0 - 1.0) * 4.0;
            double dy = this.ghost.method_6051().method_43058() * 2.0 - 1.0;
            class_243 c = origin.method_1031(dx, dy, dz);
            c = new class_243(c.field_1352, class_3532.method_15350((double)c.field_1351, (double)(this.ghost.method_37908().method_31607() + 1), (double)(this.ghost.method_37908().method_31600() - 1)), c.field_1350);
            if (!this.isSafePosition(c)) continue;
            return c;
        }
        return null;
    }

    private boolean isSafePosition(class_243 pos) {
        if (!this.ghost.method_37908().method_8587((class_1297)this.ghost, this.ghost.method_5829().method_989(pos.field_1352 - this.ghost.method_23317(), pos.field_1351 - this.ghost.method_23318(), pos.field_1350 - this.ghost.method_23321()))) {
            return false;
        }
        class_2338 min = new class_2338(class_3532.method_15357((double)(pos.field_1352 - (double)(this.ghost.method_17681() / 2.0f))), class_3532.method_15357((double)pos.field_1351), class_3532.method_15357((double)(pos.field_1350 - (double)(this.ghost.method_17681() / 2.0f))));
        class_2338 max = new class_2338(class_3532.method_15357((double)(pos.field_1352 + (double)(this.ghost.method_17681() / 2.0f))), class_3532.method_15357((double)(pos.field_1351 + (double)this.ghost.method_17682())), class_3532.method_15357((double)(pos.field_1350 + (double)(this.ghost.method_17681() / 2.0f))));
        for (class_2338 check : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            class_2680 state = this.ghost.method_37908().method_8320(check);
            if (state.method_26215() || !state.method_26227().method_15769()) continue;
            return false;
        }
        return true;
    }

    public void method_6269() {
        this.targetPos = new class_243(this.wantedX, this.wantedY, this.wantedZ);
        this.ghost.field_5960 = true;
    }

    public boolean method_6266() {
        double dz;
        double dy;
        double dx;
        if (this.ghost.method_5782() || this.ghost.method_6172() || this.targetPos == null) {
            return false;
        }
        if (this.ghost.method_6181()) {
            boolean allow;
            int inter = this.ghost.getMainInteraction();
            boolean bl = allow = inter == 2 || inter == 1 && this.isOwnerStill();
            if (!allow) {
                return false;
            }
        }
        return (dx = this.targetPos.field_1352 - this.ghost.method_23317()) * dx + (dy = this.targetPos.field_1351 - this.ghost.method_23318()) * dy + (dz = this.targetPos.field_1350 - this.ghost.method_23321()) * dz > 1.0;
    }

    public void method_6268() {
        if (this.targetPos == null) {
            return;
        }
        this.ghost.method_5702(class_2183.class_2184.field_9851, this.targetPos);
        class_243 delta = this.targetPos.method_1020(this.ghost.method_19538());
        double len = delta.method_1033();
        if (len < 0.001) {
            return;
        }
        class_243 dir = delta.method_1021(1.0 / len);
        class_243 vel = dir.method_1021(this.speedModifier);
        class_243 cur = this.ghost.method_18798();
        double vx = class_3532.method_16436((double)this.lerp, (double)cur.field_1352, (double)vel.field_1352);
        double vy = class_3532.method_16436((double)this.lerp, (double)cur.field_1351, (double)vel.field_1351);
        double vz = class_3532.method_16436((double)this.lerp, (double)cur.field_1350, (double)vel.field_1350);
        this.ghost.method_18800(vx, vy, vz);
    }

    public void method_6270() {
        this.ghost.field_5960 = false;
        this.targetPos = null;
    }

    private boolean isOwnerStill() {
        class_1309 owner = this.ghost.method_35057();
        if (owner == null) {
            return false;
        }
        return owner.method_18798().method_1027() < 0.01;
    }
}

