/*
 * Decompiled with CFR 0.152.
 */
package sleepy_evelyn.packwizsu.command;

import com.moandjiezana.toml.Toml;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import sleepy_evelyn.packwizsu.Packwizsu;
import sleepy_evelyn.packwizsu.command.CommandExceptions;
import sleepy_evelyn.packwizsu.util.HashedFileDownloader;
import sleepy_evelyn.packwizsu.util.TickCounter;

public final class PackwizsuCommands {
    private static final String BOOTSTRAP_URL = "https://github.com/packwiz/packwiz-installer-bootstrap/releases/download/v0.0.3/packwiz-installer-bootstrap.jar";
    private static final String BOOTSTRAP_HASH = "a8fbb24dc604278e97f4688e82d3d91a318b98efc08d5dbfcbcbcab6443d116c";
    private static final String BOOTSTRAP_TASK_NAME = "downloadBootstrap";
    private static final String UPDATE_PACKWIZ_TASK_NAME = "updatePackwiz";
    private static final class_5250 UPDATE_START = class_2561.method_43470((String)"Updating modpack. This may take a while...").method_27692(class_124.field_1080);
    private static final class_5250 UPDATE_START_NO_BOOTSTRAP = class_2561.method_43470((String)"Downloading the Packwiz Bootstrap and updating the modpack. This may take a while...").method_27692(class_124.field_1080);
    private static final class_5250 UPDATE_FINISHED = class_2561.method_43470((String)"Packwiz has finished updating. Restart for changes to take effect.").method_27692(class_124.field_1060);
    private static final class_5250 BOOTSTRAP_DOWNLOAD_FINISHED = class_2561.method_43470((String)"Bootstrap downloaded successfully.");
    private static final class_5250 UPDATED_TOML_LINK = class_2561.method_43470((String)"Successfully linked a Packwiz modpack. Use /packwiz update for the changes to take effect.").method_27692(class_124.field_1060);
    private static final class_5250 COMMAND_FAILED = class_2561.method_43470((String)"Command failed. Check the console for errors.").method_27692(class_124.field_1061);
    private static final class_5250 PROCESS_INTERRUPTED = class_2561.method_43470((String)"Process was interrupted. Check the console for details.").method_27692(class_124.field_1061);
    private static final class_5250 FILE_HANDLING_ERROR = class_2561.method_43470((String)"Read/write process failed. Check the console for details.").method_27692(class_124.field_1061);
    private static final Set<String> PACK_TOML_REQUIRED_KEYS = Set.of("name", "version", "index");
    private static final LinkedList<AsyncCommandTask> TASKS = new LinkedList();
    private static final Predicate<String> HAS_TASK = name -> TASKS.stream().anyMatch(task -> task.hasName((String)name));
    private static int _minPermissionLevel = 4;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        String minPermissionLevel = Packwizsu.getConfigHandler().getValue("minimum_permission_level");
        if (minPermissionLevel == null) {
            Packwizsu.LOGGER.warn("Failed to read minimum permission level from config. Defaulting to 4 (Operator).");
        } else {
            _minPermissionLevel = Integer.parseInt(minPermissionLevel);
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"packwiz").then(class_2170.method_9247((String)"link").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(PackwizsuCommands::setTomlLink)))).then(class_2170.method_9247((String)"update").executes(PackwizsuCommands::restartAndUpdate))).requires(source -> source.method_9259(_minPermissionLevel)));
    }

    private static int setTomlLink(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        try {
            URL url = PackwizsuCommands.testPackTomlLink(StringArgumentType.getString(ctx, (String)"url"));
            Packwizsu.getConfigHandler().setValue("pack_toml", url.toExternalForm());
            Packwizsu.getConfigHandler().update();
            PackwizsuCommands.getCommandOutput(ctx).method_43496((class_2561)UPDATED_TOML_LINK);
            return 1;
        }
        catch (PackTomlURLException ptue) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)ptue.getMessage())).create();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw CommandExceptions.FILE_UPDATE_FAILED.create();
        }
    }

    private static int restartAndUpdate(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        try {
            if (!Packwizsu.GAME_DIR_FILE.exists()) {
                throw CommandExceptions.DIRECTORY_BLANK_ERROR.create();
            }
        }
        catch (SecurityException se) {
            throw CommandExceptions.DIRECTORY_SECURITY_ERROR.create();
        }
        String packTomlLink = Packwizsu.getConfigHandler().getValue("pack_toml");
        if (!packTomlLink.contains("pack.toml")) {
            throw CommandExceptions.NO_PACK_TOML.create();
        }
        if (HAS_TASK.test(UPDATE_PACKWIZ_TASK_NAME)) {
            throw CommandExceptions.UPDATE_IN_PROGRESS_ERROR.create();
        }
        boolean hasBootstrap = new File("packwiz-installer-bootstrap.jar").exists();
        if (hasBootstrap) {
            PackwizsuCommands.getCommandOutput(ctx).method_43496((class_2561)UPDATE_START);
        } else {
            PackwizsuCommands.getCommandOutput(ctx).method_43496((class_2561)UPDATE_START_NO_BOOTSTRAP);
        }
        PackwizsuCommands.tryUpdatePackwiz(ctx, packTomlLink, hasBootstrap);
        return 1;
    }

    private static void tryUpdatePackwiz(CommandContext<class_2168> ctx, @NotNull String packTomllink, boolean hasBootstrap) {
        String[] command = new String[]{"java", "-jar", "packwiz-installer-bootstrap.jar", "-g", "-s", "server", packTomllink};
        if (!HAS_TASK.test(UPDATE_PACKWIZ_TASK_NAME)) {
            TASKS.add(new AsyncCommandTask(CompletableFuture.runAsync(() -> {
                try {
                    if (!hasBootstrap) {
                        Path bootstrapPath = Path.of(String.valueOf(Packwizsu.GAME_DIR_FILE) + "/packwiz-installer-bootstrap.jar", new String[0]);
                        HashedFileDownloader downloader = new HashedFileDownloader(BOOTSTRAP_URL, BOOTSTRAP_HASH, bootstrapPath);
                        downloader.download();
                        if (!downloader.hashesMatch()) {
                            File bootstrapFile = bootstrapPath.toFile();
                            if (bootstrapFile.exists() && !bootstrapFile.delete()) {
                                throw new IOException("Cannot verify the integrity of downloaded file 'packwiz-installer-bootstrap.jar'Please delete this file manually from your main server directory and replace with the correct filefrom https://github.com/packwiz/packwiz-installer-bootstrap/releases as it may be malicious");
                            }
                            throw new FailedHashMatchException();
                        }
                    }
                    PackwizsuCommands.testPackTomlLink(packTomllink);
                    Process process = new ProcessBuilder(command).inheritIO().start();
                    try (BufferedReader bufferedReader = process.inputReader();){
                        bufferedReader.lines().forEach(arg_0 -> ((Logger)Packwizsu.LOGGER).info(arg_0));
                    }
                    int exitCode = process.waitFor();
                    if (exitCode != 0) {
                        throw new ProcessExitCodeException("Process failed with exit code: " + exitCode);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }), UPDATE_PACKWIZ_TASK_NAME, 20, ctx));
        }
    }

    @NotNull
    private static URL testPackTomlLink(@NotNull String packTomllink) throws PackTomlURLException {
        try {
            URL url = new URL(packTomllink);
            URLConnection connection = url.openConnection();
            Toml toml = new Toml().read(connection.getInputStream());
            if (!PACK_TOML_REQUIRED_KEYS.stream().allMatch(arg_0 -> ((Toml)toml).contains(arg_0))) {
                String requiredKeys = String.join((CharSequence)", ", PACK_TOML_REQUIRED_KEYS);
                throw new PackTomlURLException("The file does not contain all the required keys: " + requiredKeys);
            }
            return url;
        }
        catch (MalformedURLException mue) {
            throw new PackTomlURLException("The link submitted is not a valid URL");
        }
        catch (IOException ioe) {
            throw new PackTomlURLException("Check this file exists and is a valid TOML file");
        }
        catch (IllegalStateException ise) {
            throw new PackTomlURLException("The file contains invalid data");
        }
    }

    public static void pollCommandStatus() {
        ListIterator tasksIterator = TASKS.listIterator();
        CompletionException exception = null;
        class_5250 message = null;
        while (tasksIterator.hasNext()) {
            AsyncCommandTask task;
            block16: {
                task = (AsyncCommandTask)tasksIterator.next();
                task.tick();
                if (!task.pollFinished()) continue;
                try {
                    task.getFuture().join();
                    if (task.hasName(UPDATE_PACKWIZ_TASK_NAME)) {
                        message = UPDATE_FINISHED;
                    } else if (task.hasName(BOOTSTRAP_TASK_NAME)) {
                        message = BOOTSTRAP_DOWNLOAD_FINISHED;
                    }
                }
                catch (CompletionException e) {
                    Throwable cause = e.getCause();
                    exception = e;
                    if (cause instanceof InterruptedException) {
                        message = PROCESS_INTERRUPTED;
                    } else if (cause instanceof IOException) {
                        message = FILE_HANDLING_ERROR;
                    }
                    if (task.hasName(UPDATE_PACKWIZ_TASK_NAME)) {
                        if (cause instanceof PackTomlURLException) {
                            PackTomlURLException ptfe = (PackTomlURLException)cause;
                            message = class_2561.method_43470((String)ptfe.getMessage());
                        } else if (cause instanceof ProcessExitCodeException) {
                            ProcessExitCodeException pece = (ProcessExitCodeException)cause;
                            message = class_2561.method_43470((String)pece.getMessage());
                        } else if (cause instanceof FailedHashMatchException) {
                            FailedHashMatchException fhme = (FailedHashMatchException)cause;
                            message = class_2561.method_43470((String)fhme.getMessage());
                        }
                    }
                    if (message != null) break block16;
                    message = COMMAND_FAILED;
                }
            }
            task.sendMessage((class_2561)message);
            if (exception != null) {
                exception.printStackTrace();
            }
            tasksIterator.remove();
        }
    }

    private static class_2165 getCommandOutput(CommandContext<class_2168> ctx) {
        MinecraftServer minecraftServer;
        class_1297 class_12972 = ((class_2168)ctx.getSource()).method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            minecraftServer = player.method_64401();
        } else {
            minecraftServer = ((class_2168)ctx.getSource()).method_9211();
        }
        return minecraftServer;
    }

    private static class PackTomlURLException
    extends Exception {
        private static final String EXCEPTION_START = "Failed to read the Packwiz pack.toml file. ";

        public PackTomlURLException(String message) {
            super(EXCEPTION_START + message);
        }
    }

    private static class AsyncCommandTask {
        private final String name;
        private final CompletableFuture<Void> future;
        private final class_2165 co;
        private final TickCounter tc;

        AsyncCommandTask(CompletableFuture<Void> future, String name, int pollTicks, CommandContext<class_2168> ctx) {
            this.future = future;
            this.name = name;
            this.co = PackwizsuCommands.getCommandOutput(ctx);
            this.tc = new TickCounter(pollTicks);
        }

        public void tick() {
            this.tc.increment();
        }

        public boolean pollFinished() {
            return this.tc.test() && this.future != null && this.future.isDone();
        }

        public void sendMessage(class_2561 message) {
            if (message != null && this.co != null) {
                this.co.method_43496(message);
            }
        }

        public CompletableFuture<Void> getFuture() {
            return this.future;
        }

        public boolean hasName(String name) {
            return this.name.equals(name);
        }
    }

    private static class ProcessExitCodeException
    extends Exception {
        public ProcessExitCodeException(String message) {
            super(message);
        }
    }

    private static class FailedHashMatchException
    extends Exception {
        public FailedHashMatchException() {
            super("Failed to verify the Packwiz Bootstrap hashes match. Please manually download the bootstrapper from: https://github.com/packwiz/packwiz-installer-bootstrap/releases and place in the main directory for your server.");
        }
    }
}

