/*
 * Decompiled with CFR 0.152.
 */
package sleepy_evelyn.packwizsu.util;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashedFileDownloader {
    private final Path destination;
    private final String url;
    private final String sha256Hash;

    public HashedFileDownloader(String url, String sha256Hash, Path destination) {
        this.url = url;
        this.sha256Hash = sha256Hash;
        this.destination = destination;
    }

    public void download() throws IOException, InterruptedException {
        HttpRequest request;
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
        HttpResponse<Path> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.url)).build(), HttpResponse.BodyHandlers.ofFile(this.destination));
        if (response.statusCode() != 200) {
            throw new IOException("Failed to download file. HTTP Response code: " + response.statusCode());
        }
    }

    public boolean hashesMatch() throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (DigestInputStream digestInputStream = new DigestInputStream(Files.newInputStream(this.destination, new OpenOption[0]), digest);){
            while (digestInputStream.read() != -1) {
            }
        }
        byte[] hashBytes = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte b : hashBytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString().equalsIgnoreCase(this.sha256Hash);
    }
}

