/*
 * Decompiled with CFR 0.152.
 */
package sleepy_evelyn.packwizsu.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import sleepy_evelyn.packwizsu.Packwizsu;

public class ConfigFile {
    private final File file;
    private final Properties defaults;
    private Properties properties;
    private final String headerComments;

    ConfigFile(String title, Properties defaults, String headerComments) {
        this.defaults = defaults;
        this.headerComments = headerComments;
        this.file = new File(String.valueOf(Packwizsu.GAME_DIR_FILE) + "/" + title + ".properties");
        try {
            if (Files.notExists(Packwizsu.GAME_DIR_FILE.toPath(), new LinkOption[0])) {
                Files.createDirectory(Packwizsu.GAME_DIR_FILE.toPath(), new FileAttribute[0]);
            }
            if (this.file.createNewFile()) {
                this.setToDefaults();
                this.save();
            }
            this.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void save() throws Exception {
        FileOutputStream outputStream = new FileOutputStream(this.file);
        this.properties.store(outputStream, this.headerComments);
        outputStream.close();
    }

    void load() throws Exception {
        if (this.file.createNewFile()) {
            this.setToDefaults();
        } else {
            FileInputStream inputStream = new FileInputStream(this.file);
            this.properties = new Properties();
            this.properties.load(inputStream);
        }
    }

    void setToDefaults() {
        this.properties = this.defaults;
    }

    void setPropertyValue(String key, String value) {
        this.properties.setProperty(key, value);
    }

    void removePropertyValue(String key) {
        this.properties.remove(key);
    }

    String getPropertyValue(String key) {
        return this.properties.getProperty(key);
    }
}

