/*
 * Decompiled with CFR 0.152.
 */
package sleepy_evelyn.packwizsu.util;

public class TickCounter {
    private final int tickThreshold;
    private final int maxValue;
    private int counter = 0;

    public TickCounter(int tickThreshold) {
        this(tickThreshold, Integer.MAX_VALUE);
    }

    public TickCounter(int tickThreshold, int maxValue) {
        this.tickThreshold = tickThreshold;
        this.maxValue = maxValue;
    }

    public boolean test() {
        if (this.counter >= this.tickThreshold) {
            this.reset();
            return true;
        }
        return false;
    }

    public void increment() {
        if (this.counter >= this.maxValue || this.counter < 0) {
            this.reset();
        } else {
            ++this.counter;
        }
    }

    public void reset() {
        this.counter = 0;
    }

    public int value() {
        return this.counter;
    }

    public int getTickThreshold() {
        return this.tickThreshold;
    }
}

