/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.vertical.slabs.world.level.block;

import com.devnemo.nemos.vertical.slabs.world.level.block.state.properties.NemosVerticalBlockStateProperties;
import com.devnemo.nemos.vertical.slabs.world.level.block.state.properties.VerticalSlabType;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabBlock
extends class_2248
implements class_3737 {
    public static final MapCodec<VerticalSlabBlock> CODEC = VerticalSlabBlock.method_54094(VerticalSlabBlock::new);
    public static class_2754<VerticalSlabType> TYPE = NemosVerticalBlockStateProperties.VERTICAL_SLAB_TYPE;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265 FRONT_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final class_265 LEFT_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final class_265 RIGHT_SHAPE = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 BACK_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final double leftArea = 0.333;
    private static final double rightArea = 0.666;

    public MapCodec<? extends VerticalSlabBlock> getCodec() {
        return CODEC;
    }

    public VerticalSlabBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657(TYPE, (Comparable)((Object)VerticalSlabType.FRONT))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean method_9526(class_2680 state) {
        return state.method_11654(TYPE) != VerticalSlabType.DOUBLE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TYPE, WATERLOGGED});
    }

    @NotNull
    protected class_265 method_9530(class_2680 state, @NotNull class_1922 blockGetter, @NotNull class_2338 pos, @NotNull class_3726 context) {
        VerticalSlabType slabType = (VerticalSlabType)((Object)state.method_11654(TYPE));
        return switch (slabType) {
            default -> throw new MatchException(null, null);
            case VerticalSlabType.DOUBLE -> class_259.method_1077();
            case VerticalSlabType.FRONT -> FRONT_SHAPE;
            case VerticalSlabType.LEFT -> LEFT_SHAPE;
            case VerticalSlabType.RIGHT -> RIGHT_SHAPE;
            case VerticalSlabType.BACK -> BACK_SHAPE;
        };
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_2338 blockPos = blockPlaceContext.method_8037();
        class_2680 blockState = blockPlaceContext.method_8045().method_8320(blockPos);
        if (blockState.method_27852((class_2248)this)) {
            return (class_2680)((class_2680)blockState.method_11657(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        class_3610 fluidState = blockPlaceContext.method_8045().method_8316(blockPos);
        class_2680 newblockState = (class_2680)((class_2680)this.method_9564().method_11657(TYPE, (Comparable)((Object)VerticalSlabType.BACK))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        class_2350 direction = blockPlaceContext.method_8038();
        double zPos = blockPlaceContext.method_17698().field_1350 - (double)blockPos.method_10260();
        double xPos = blockPlaceContext.method_17698().field_1352 - (double)blockPos.method_10263();
        if (direction == class_2350.field_11036 || direction == class_2350.field_11033) {
            VerticalSlabType type = VerticalSlabBlock.getVerticalSlabType(zPos, xPos);
            return (class_2680)newblockState.method_11657(TYPE, (Comparable)((Object)type));
        }
        if (direction == class_2350.field_11035) {
            return this.getBlockStateForXPos(xPos, newblockState, VerticalSlabType.FRONT);
        }
        if (direction == class_2350.field_11043) {
            return this.getBlockStateForXPos(xPos, newblockState, VerticalSlabType.BACK);
        }
        if (direction == class_2350.field_11039) {
            return this.getBlockStateForZPos(zPos, newblockState, VerticalSlabType.RIGHT);
        }
        if (direction == class_2350.field_11034) {
            return this.getBlockStateForZPos(zPos, newblockState, VerticalSlabType.LEFT);
        }
        return newblockState;
    }

    private static VerticalSlabType getVerticalSlabType(double zPos, double xPos) {
        double diffZ = 1.0 - zPos;
        double diffX = 1.0 - xPos;
        VerticalSlabType type = zPos > 0.5 ? (xPos > 0.5 ? (diffX > diffZ ? VerticalSlabType.BACK : VerticalSlabType.RIGHT) : (xPos > diffZ ? VerticalSlabType.BACK : VerticalSlabType.LEFT)) : (xPos > 0.5 ? (diffX > zPos ? VerticalSlabType.FRONT : VerticalSlabType.RIGHT) : (xPos > zPos ? VerticalSlabType.FRONT : VerticalSlabType.LEFT));
        return type;
    }

    private class_2680 getBlockStateForXPos(double xPos, class_2680 blockState, VerticalSlabType defaultSlabType) {
        if (xPos < 0.333) {
            return (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)VerticalSlabType.LEFT));
        }
        if (xPos > 0.666) {
            return (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)VerticalSlabType.RIGHT));
        }
        return (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)defaultSlabType));
    }

    private class_2680 getBlockStateForZPos(double zPos, class_2680 blockState, VerticalSlabType defaultSlabType) {
        if (zPos < 0.333) {
            return (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)VerticalSlabType.FRONT));
        }
        if (zPos > 0.666) {
            return (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)VerticalSlabType.BACK));
        }
        return (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)defaultSlabType));
    }

    protected boolean method_9616(class_2680 state, class_1750 context) {
        class_1799 itemStack = context.method_8041();
        VerticalSlabType slabType = (VerticalSlabType)((Object)state.method_11654(TYPE));
        if (slabType == VerticalSlabType.DOUBLE || !itemStack.method_31574(this.method_8389())) {
            return false;
        }
        if (context.method_7717()) {
            class_2350 direction = context.method_8038();
            if (slabType == VerticalSlabType.FRONT) {
                return direction == class_2350.field_11035;
            }
            if (slabType == VerticalSlabType.BACK) {
                return direction == class_2350.field_11043;
            }
            if (slabType == VerticalSlabType.LEFT) {
                return direction == class_2350.field_11034;
            }
            if (slabType == VerticalSlabType.RIGHT) {
                return direction == class_2350.field_11039;
            }
        }
        return true;
    }

    @NotNull
    protected class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    public boolean method_10311(@NotNull class_1936 levelAccessor, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3610 fluidState) {
        if (this.isDoubleVerticalSlab(state)) {
            return super.method_10311(levelAccessor, pos, state, fluidState);
        }
        return false;
    }

    public boolean method_10310(@Nullable class_1309 filler, @NotNull class_1922 blockGetter, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3611 fluid) {
        if (this.isDoubleVerticalSlab(state)) {
            return super.method_10310(filler, blockGetter, pos, state, fluid);
        }
        return false;
    }

    @NotNull
    protected class_2680 method_9559(class_2680 state, @NotNull class_4538 levelReader, @NotNull class_10225 scheduledTickAccess, @NotNull class_2338 pos, @NotNull class_2350 direction, @NotNull class_2338 neighborPos, @NotNull class_2680 neighborState, @NotNull class_5819 randomSource) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        return super.method_9559(state, levelReader, scheduledTickAccess, pos, direction, neighborPos, neighborState, randomSource);
    }

    protected boolean method_9516(@NotNull class_2680 state, class_10 type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case class_10.field_50, class_10.field_51 -> false;
            case class_10.field_48 -> state.method_26227().method_15767(class_3486.field_15517);
        };
    }

    private boolean isDoubleVerticalSlab(class_2680 state) {
        return state.method_11654(TYPE) != VerticalSlabType.DOUBLE;
    }
}

