/*
 * Decompiled with CFR 0.152.
 */
package com.bowpearl;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BowPearl
extends JavaPlugin
implements Listener {
    private final Set<UUID> enabledPlayers = new HashSet<UUID>();
    private boolean requireEnderPearl;
    private double cooldownTime;
    private String teleportMessage;
    private String toggleOnMessage;
    private String toggleOffMessage;
    private String cooldownMessage;
    private boolean useParticles;
    private String particleType;
    private boolean playSound;
    private String soundEffect;
    private boolean allowFallDamage;
    private boolean enabledByDefault;
    private Set<UUID> playersInCooldown = new HashSet<UUID>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("bowpearl").setExecutor((CommandExecutor)this);
        this.getLogger().info("BowPearl has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("BowPearl has been disabled!");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.requireEnderPearl = config.getBoolean("require-ender-pearl", false);
        this.cooldownTime = config.getDouble("cooldown-seconds", 5.0);
        this.teleportMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.teleport", "&aTeleported!"));
        this.toggleOnMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.toggle-on", "&aBowPearl enabled!"));
        this.toggleOffMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.toggle-off", "&cBowPearl disabled!"));
        this.cooldownMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.cooldown", "&cCooldown active: &e{time}s"));
        this.useParticles = config.getBoolean("effects.particles.enabled", true);
        this.particleType = config.getString("effects.particles.type", "PORTAL");
        this.playSound = config.getBoolean("effects.sound.enabled", true);
        this.soundEffect = config.getString("effects.sound.type", "ENTITY_ENDERMAN_TELEPORT");
        this.allowFallDamage = config.getBoolean("allow-fall-damage", false);
        this.enabledByDefault = config.getBoolean("enabled-by-default", true);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("bowpearl.toggle")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            this.toggleBowPearl(player);
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("reload") && player.hasPermission("bowpearl.reload")) {
                this.reloadConfig();
                this.loadConfig();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "BowPearl configuration reloaded!");
                return true;
            }
            if (args[0].equalsIgnoreCase("on")) {
                this.enableBowPearl(player);
                return true;
            }
            if (args[0].equalsIgnoreCase("off")) {
                this.disableBowPearl(player);
                return true;
            }
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /bowpearl [on|off|reload]");
        return true;
    }

    private void toggleBowPearl(Player player) {
        if (this.enabledPlayers.contains(player.getUniqueId())) {
            this.disableBowPearl(player);
        } else {
            this.enableBowPearl(player);
        }
    }

    private void enableBowPearl(Player player) {
        this.enabledPlayers.add(player.getUniqueId());
        player.sendMessage(this.toggleOnMessage);
    }

    private void disableBowPearl(Player player) {
        this.enabledPlayers.remove(player.getUniqueId());
        player.sendMessage(this.toggleOffMessage);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.enabledByDefault && player.hasPermission("bowpearl.use")) {
            this.enabledPlayers.add(player.getUniqueId());
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)event.getEntity();
        if (!(arrow.getShooter() instanceof Player)) {
            return;
        }
        final Player player = (Player)arrow.getShooter();
        if (!this.enabledPlayers.contains(player.getUniqueId()) || !player.hasPermission("bowpearl.use")) {
            return;
        }
        if (this.playersInCooldown.contains(player.getUniqueId())) {
            player.sendMessage(this.cooldownMessage.replace("{time}", String.format("%.1f", this.cooldownTime)));
            return;
        }
        if (this.requireEnderPearl) {
            boolean hasEnderPearl = false;
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || item.getType() != Material.ENDER_PEARL) continue;
                ItemStack newStack = item.clone();
                newStack.setAmount(item.getAmount() - 1);
                if (newStack.getAmount() <= 0) {
                    player.getInventory().remove(item);
                } else {
                    item.setAmount(newStack.getAmount());
                }
                hasEnderPearl = true;
                break;
            }
            if (!hasEnderPearl) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You need an Ender Pearl to use BowPearl!");
                return;
            }
        }
        Location teleportLocation = arrow.getLocation().clone();
        teleportLocation.setYaw(player.getLocation().getYaw());
        teleportLocation.setPitch(player.getLocation().getPitch());
        teleportLocation.setY(teleportLocation.getY() + 1.0);
        if (this.useParticles) {
            try {
                player.getWorld().spawnParticle(Particle.valueOf((String)this.particleType), player.getLocation(), 30, 0.5, 1.0, 0.5, 0.1);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid particle type: " + this.particleType);
            }
        }
        player.teleport(teleportLocation);
        if (this.useParticles) {
            try {
                player.getWorld().spawnParticle(Particle.valueOf((String)this.particleType), teleportLocation, 30, 0.5, 1.0, 0.5, 0.1);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid particle type: " + this.particleType);
            }
        }
        if (this.playSound) {
            try {
                player.playSound(teleportLocation, Sound.valueOf((String)this.soundEffect), 1.0f, 1.0f);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid sound effect: " + this.soundEffect);
            }
        }
        if (!this.allowFallDamage) {
            player.setFallDistance(0.0f);
        }
        player.sendMessage(this.teleportMessage);
        if (this.cooldownTime > 0.0) {
            this.playersInCooldown.add(player.getUniqueId());
            new BukkitRunnable(this){
                final /* synthetic */ BowPearl this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.playersInCooldown.remove(player.getUniqueId());
                }
            }.runTaskLater((Plugin)this, (long)(this.cooldownTime * 20.0));
        }
        arrow.remove();
    }
}

