/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.audio;

import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.client.audio.NetMusicAudioStream;
import com.github.tartaricacid.netmusic.init.InitSounds;
import com.github.tartaricacid.netmusic.tileentity.TileEntityMusicPlayer;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;

public class NetMusicSound
extends AbstractTickableSoundInstance {
    private final URL songUrl;
    private final int tickTimes;
    private final BlockPos pos;
    @Nullable
    private final LyricRecord lyricRecord;
    private int tick;

    public NetMusicSound(BlockPos pos, URL songUrl, int timeSecond, @Nullable LyricRecord lyricRecord) {
        super((SoundEvent)InitSounds.NET_MUSIC.get(), SoundSource.RECORDS, SoundInstance.createUnseededRandom());
        this.songUrl = songUrl;
        this.x = (float)pos.getX() + 0.5f;
        this.y = (float)pos.getY() + 0.5f;
        this.z = (float)pos.getZ() + 0.5f;
        this.tickTimes = timeSecond * 20;
        this.volume = 4.0f;
        this.tick = 0;
        this.pos = pos;
        this.lyricRecord = lyricRecord;
    }

    public void tick() {
        TileEntityMusicPlayer musicPlay;
        BlockEntity te;
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        ++this.tick;
        if (this.tick > this.tickTimes + 50) {
            te = world.getBlockEntity(this.pos);
            if (te instanceof TileEntityMusicPlayer) {
                musicPlay = (TileEntityMusicPlayer)te;
                musicPlay.lyricRecord = null;
            }
            this.stop();
        } else if (world.getGameTime() % 8L == 0L) {
            for (int i = 0; i < 2; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.NOTE, this.x - 0.5 + world.random.nextDouble(), this.y + world.random.nextDouble() + 1.0, this.z - 0.5 + world.random.nextDouble(), world.random.nextGaussian(), world.random.nextGaussian(), (double)world.random.nextInt(3));
            }
        }
        if (this.lyricRecord != null) {
            this.lyricRecord.updateCurrentLine(this.tick);
        }
        if ((te = world.getBlockEntity(this.pos)) instanceof TileEntityMusicPlayer) {
            musicPlay = (TileEntityMusicPlayer)te;
            if (!musicPlay.isPlay()) {
                musicPlay.lyricRecord = null;
                this.stop();
            } else {
                musicPlay.lyricRecord = this.lyricRecord;
            }
        } else {
            this.stop();
        }
    }

    public CompletableFuture<AudioStream> getStream(SoundBufferLibrary soundBuffers, Sound sound, boolean looping) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return new NetMusicAudioStream(this.songUrl);
            }
            catch (IOException | UnsupportedAudioFileException e) {
                e.printStackTrace();
                return null;
            }
        }, Util.backgroundExecutor());
    }
}

