/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.gui;

import com.github.tartaricacid.netmusic.inventory.ComputerMenu;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.netmusic.network.message.SetMusicIDMessage;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.apache.commons.lang3.StringUtils;

@IPNIgnore
public class ComputerMenuScreen
extends AbstractContainerScreen<ComputerMenu> {
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"netmusic", (String)"textures/gui/computer.png");
    private static final Pattern URL_HTTP_REG = Pattern.compile("(http|ftp|https)://[\\w\\-_]+(\\.[\\w\\-_]+)+([\\w\\-.,@?^=%&:/~+#]*[\\w\\-@?^=%&/~+#])?");
    private static final Pattern URL_FILE_REG = Pattern.compile("^[a-zA-Z]:\\\\(?:[^\\\\/:*?\"<>|\\r\\n]+\\\\)*[^\\\\/:*?\"<>|\\r\\n]*$");
    private static final Pattern TIME_REG = Pattern.compile("^\\d+$");
    private EditBox urlTextField;
    private EditBox nameTextField;
    private EditBox timeTextField;
    private Checkbox readOnlyButton;
    private Component tips = Component.empty();

    public ComputerMenuScreen(ComputerMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.imageHeight = 216;
    }

    protected void init() {
        super.init();
        this.initUrlEditBox();
        this.initNameEditBox();
        this.initTimeEditBox();
        this.readOnlyButton = Checkbox.builder((Component)Component.translatable((String)"gui.netmusic.cd_burner.read_only"), (Font)this.font).pos(this.leftPos + 58, this.topPos + 55).maxWidth(80).selected(false).build();
        this.addRenderableWidget((GuiEventListener)this.readOnlyButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.netmusic.cd_burner.craft"), b -> this.handleCraftButton()).pos(this.leftPos + 7, this.topPos + 78).size(135, 18).build());
    }

    private void initUrlEditBox() {
        String perText = "";
        boolean focus = false;
        if (this.urlTextField != null) {
            perText = this.urlTextField.getValue();
            focus = this.urlTextField.isFocused();
        }
        this.urlTextField = new EditBox(this.getMinecraft().font, this.leftPos + 10, this.topPos + 18, 120, 16, (Component)Component.literal((String)"Music URL Box"));
        this.urlTextField.setValue(perText);
        this.urlTextField.setBordered(false);
        this.urlTextField.setMaxLength(32500);
        this.urlTextField.setTextColor(15986656);
        this.urlTextField.setFocused(focus);
        this.urlTextField.moveCursorToEnd(false);
        this.addWidget((GuiEventListener)this.urlTextField);
    }

    private void initNameEditBox() {
        String perText = "";
        boolean focus = false;
        if (this.nameTextField != null) {
            perText = this.nameTextField.getValue();
            focus = this.nameTextField.isFocused();
        }
        this.nameTextField = new EditBox(this.getMinecraft().font, this.leftPos + 10, this.topPos + 39, 120, 16, (Component)Component.literal((String)"Music Name Box"));
        this.nameTextField.setValue(perText);
        this.nameTextField.setBordered(false);
        this.nameTextField.setMaxLength(256);
        this.nameTextField.setTextColor(15986656);
        this.nameTextField.setFocused(focus);
        this.nameTextField.moveCursorToEnd(false);
        this.addWidget((GuiEventListener)this.nameTextField);
    }

    private void initTimeEditBox() {
        String perText = "";
        boolean focus = false;
        if (this.timeTextField != null) {
            perText = this.timeTextField.getValue();
            focus = this.timeTextField.isFocused();
        }
        this.timeTextField = new EditBox(this.getMinecraft().font, this.leftPos + 10, this.topPos + 61, 40, 16, (Component)Component.literal((String)"Music Time Box"));
        this.timeTextField.setValue(perText);
        this.timeTextField.setBordered(false);
        this.timeTextField.setMaxLength(5);
        this.timeTextField.setTextColor(15986656);
        this.timeTextField.setFocused(focus);
        this.timeTextField.moveCursorToEnd(false);
        this.addWidget((GuiEventListener)this.timeTextField);
    }

    private void handleCraftButton() {
        ItemStack cd = ((ComputerMenu)this.getMenu()).getInput().getStackInSlot(0);
        if (cd.isEmpty()) {
            this.tips = Component.translatable((String)"gui.netmusic.cd_burner.cd_is_empty");
            return;
        }
        ItemMusicCD.SongInfo songInfo = ItemMusicCD.getSongInfo(cd);
        if (songInfo != null && songInfo.readOnly) {
            this.tips = Component.translatable((String)"gui.netmusic.cd_burner.cd_read_only");
            return;
        }
        String urlText = this.urlTextField.getValue();
        if (StringUtils.isBlank((CharSequence)urlText)) {
            this.tips = Component.translatable((String)"gui.netmusic.computer.url.empty");
            return;
        }
        String nameText = this.nameTextField.getValue();
        if (StringUtils.isBlank((CharSequence)nameText)) {
            this.tips = Component.translatable((String)"gui.netmusic.computer.name.empty");
            return;
        }
        String timeText = this.timeTextField.getValue();
        if (StringUtils.isBlank((CharSequence)timeText)) {
            this.tips = Component.translatable((String)"gui.netmusic.computer.time.empty");
            return;
        }
        if (!TIME_REG.matcher(timeText).matches()) {
            this.tips = Component.translatable((String)"gui.netmusic.computer.time.not_number");
            return;
        }
        int time = Integer.parseInt(timeText);
        if (URL_HTTP_REG.matcher(urlText).matches()) {
            ItemMusicCD.SongInfo song = new ItemMusicCD.SongInfo(urlText, nameText, time, this.readOnlyButton.selected());
            NetworkHandler.sendToServer(new SetMusicIDMessage(song));
            return;
        }
        if (URL_FILE_REG.matcher(urlText).matches()) {
            File file = Paths.get(urlText, new String[0]).toFile();
            if (!file.isFile()) {
                this.tips = Component.translatable((String)"gui.netmusic.computer.url.local_file_error");
                return;
            }
            try {
                URL url = file.toURI().toURL();
                ItemMusicCD.SongInfo song = new ItemMusicCD.SongInfo(url.toString(), nameText, time, this.readOnlyButton.selected());
                NetworkHandler.sendToServer(new SetMusicIDMessage(song));
                return;
            }
            catch (MalformedURLException e) {
                e.fillInStackTrace();
            }
        }
        this.tips = Component.translatable((String)"gui.netmusic.computer.url.error");
    }

    protected void renderLabels(GuiGraphics graphics, int x, int y) {
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        int posX = this.leftPos;
        int posY = (this.height - this.imageHeight) / 2;
        graphics.blit(BG, posX, posY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        super.render(graphics, x, y, partialTicks);
        this.urlTextField.render(graphics, x, y, partialTicks);
        this.nameTextField.render(graphics, x, y, partialTicks);
        this.timeTextField.render(graphics, x, y, partialTicks);
        if (StringUtils.isBlank((CharSequence)this.urlTextField.getValue()) && !this.urlTextField.isFocused()) {
            graphics.drawString(this.font, (Component)Component.translatable((String)"gui.netmusic.computer.url.tips").withStyle(ChatFormatting.ITALIC), this.leftPos + 12, this.topPos + 18, ChatFormatting.GRAY.getColor().intValue(), false);
        }
        if (StringUtils.isBlank((CharSequence)this.nameTextField.getValue()) && !this.nameTextField.isFocused()) {
            graphics.drawString(this.font, (Component)Component.translatable((String)"gui.netmusic.computer.name.tips").withStyle(ChatFormatting.ITALIC), this.leftPos + 12, this.topPos + 39, ChatFormatting.GRAY.getColor().intValue(), false);
        }
        if (StringUtils.isBlank((CharSequence)this.timeTextField.getValue()) && !this.timeTextField.isFocused()) {
            graphics.drawString(this.font, (Component)Component.translatable((String)"gui.netmusic.computer.time.tips").withStyle(ChatFormatting.ITALIC), this.leftPos + 11, this.topPos + 61, ChatFormatting.GRAY.getColor().intValue(), false);
        }
        graphics.drawWordWrap(this.font, (FormattedText)this.tips, this.leftPos + 8, this.topPos + 100, 162, 0xCF0000);
        this.renderTooltip(graphics, x, y);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String urlValue = this.urlTextField.getValue();
        String nameValue = this.nameTextField.getValue();
        String timeValue = this.timeTextField.getValue();
        super.resize(minecraft, width, height);
        this.urlTextField.setValue(urlValue);
        this.nameTextField.setValue(nameValue);
        this.timeTextField.setValue(timeValue);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.urlTextField.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.urlTextField);
            return true;
        }
        if (this.nameTextField.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.nameTextField);
            return true;
        }
        if (this.timeTextField.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.timeTextField);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.getMinecraft().options.keyInventory.isActiveAndMatches(mouseKey) && (this.urlTextField.isFocused() || this.nameTextField.isFocused() || this.timeTextField.isFocused())) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void insertText(String text, boolean overwrite) {
        if (overwrite) {
            this.urlTextField.setValue(text);
            this.nameTextField.setValue(text);
            this.timeTextField.setValue(text);
        } else {
            this.urlTextField.insertText(text);
            this.nameTextField.insertText(text);
            this.timeTextField.insertText(text);
        }
    }
}

