/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.command;

import com.github.tartaricacid.netmusic.client.config.MusicListManage;
import com.github.tartaricacid.netmusic.init.InitItems;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.netmusic.network.message.GetMusicListMessage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class NetMusicCommand {
    private static final String ROOT_NAME = "netmusic";
    private static final String RELOAD_NAME = "reload";
    private static final String GET_163_NAME = "get163";
    private static final String GET_163_CD_NAME = "get163cd";
    private static final String GET_DJ_CD_NAME = "getDJcd";
    private static final String SONG_LIST_ID = "song_list_id";
    private static final String SONG_ID = "song_id";
    private static final String DJ_SONG_ID = "dj_id";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.literal((String)ROOT_NAME).requires(source -> source.hasPermission(2));
        LiteralArgumentBuilder get163List = Commands.literal((String)GET_163_NAME);
        LiteralArgumentBuilder get163Song = Commands.literal((String)GET_163_CD_NAME);
        LiteralArgumentBuilder reload = Commands.literal((String)RELOAD_NAME);
        LiteralArgumentBuilder getDJSong = Commands.literal((String)GET_DJ_CD_NAME);
        RequiredArgumentBuilder songListId = Commands.argument((String)SONG_LIST_ID, (ArgumentType)LongArgumentType.longArg());
        RequiredArgumentBuilder songId = Commands.argument((String)SONG_ID, (ArgumentType)LongArgumentType.longArg());
        RequiredArgumentBuilder djId = Commands.argument((String)DJ_SONG_ID, (ArgumentType)LongArgumentType.longArg());
        root.then(get163List.then(songListId.executes(NetMusicCommand::getSongList)));
        root.then(get163Song.then(songId.executes(NetMusicCommand::getSong)));
        root.then(reload.executes(NetMusicCommand::reload));
        root.then(getDJSong.then(djId.executes(NetMusicCommand::getDJSong)));
        return root;
    }

    private static int getSong(CommandContext<CommandSourceStack> context) {
        try {
            long songId = LongArgumentType.getLong(context, (String)SONG_ID);
            ItemMusicCD.SongInfo songInfo = MusicListManage.get163Song(songId);
            if (StringUtils.isBlank((CharSequence)songInfo.songUrl) || StringUtils.isBlank((CharSequence)songInfo.songName)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"gui.netmusic.cd_burner.get_info_error"), false);
                return 1;
            }
            ItemStack musicDisc = ItemMusicCD.setSongInfo(songInfo, ((Item)InitItems.MUSIC_CD.get()).getDefaultInstance());
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            boolean canPlaceIn = serverPlayer.getInventory().add(musicDisc);
            if (canPlaceIn && musicDisc.isEmpty()) {
                musicDisc.setCount(1);
                ItemEntity dropItem = serverPlayer.drop(musicDisc, false);
                if (dropItem != null) {
                    dropItem.makeFakeItem();
                }
                serverPlayer.level().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((serverPlayer.getRandom().nextFloat() - serverPlayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.inventoryMenu.broadcastChanges();
            } else {
                ItemEntity dropItem = serverPlayer.drop(musicDisc, false);
                if (dropItem != null) {
                    dropItem.setNoPickUpDelay();
                    dropItem.setThrower((Entity)serverPlayer);
                }
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.netmusic.music_cd.add163cd.success"), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.netmusic.music_cd.add163cd.fail"));
        }
        return 1;
    }

    private static int getSongList(CommandContext<CommandSourceStack> context) {
        try {
            long listId = LongArgumentType.getLong(context, (String)SONG_LIST_ID);
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            NetworkHandler.sendToClientPlayer(new GetMusicListMessage(listId), serverPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static int reload(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            NetworkHandler.sendToClientPlayer(new GetMusicListMessage(-1L), serverPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static int getDJSong(CommandContext<CommandSourceStack> context) {
        try {
            long djId = LongArgumentType.getLong(context, (String)DJ_SONG_ID);
            ItemMusicCD.SongInfo songInfo = MusicListManage.getDjSong(djId);
            ItemStack musicDisc = ItemMusicCD.setSongInfo(songInfo, ((Item)InitItems.MUSIC_CD.get()).getDefaultInstance());
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            boolean canPlaceIn = serverPlayer.getInventory().add(musicDisc);
            if (canPlaceIn && musicDisc.isEmpty()) {
                musicDisc.setCount(1);
                ItemEntity dropItem = serverPlayer.drop(musicDisc, false);
                if (dropItem != null) {
                    dropItem.makeFakeItem();
                }
                serverPlayer.level().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((serverPlayer.getRandom().nextFloat() - serverPlayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.inventoryMenu.broadcastChanges();
            } else {
                ItemEntity dropItem = serverPlayer.drop(musicDisc, false);
                if (dropItem != null) {
                    dropItem.setNoPickUpDelay();
                    dropItem.setThrower((Entity)serverPlayer);
                }
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.netmusic.music_cd.addDJcd.success"), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.netmusic.music_cd.addDJcd.fail"));
        }
        return 1;
    }
}

