/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.compat.tlm.client.audio;

import com.github.tartaricacid.netmusic.client.audio.NetMusicAudioStream;
import com.github.tartaricacid.netmusic.compat.tlm.backpack.MusicPlayerBackpack;
import com.github.tartaricacid.netmusic.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class MaidNetMusicSound
extends AbstractTickableSoundInstance {
    private final EntityMaid maid;
    private final URL songUrl;
    private final int tickTimes;
    private int tick;

    public MaidNetMusicSound(EntityMaid maid, URL songUrl, int timeSecond) {
        super((SoundEvent)InitSounds.NET_MUSIC.get(), SoundSource.RECORDS, SoundInstance.createUnseededRandom());
        this.maid = maid;
        this.songUrl = songUrl;
        this.x = maid.getX();
        this.y = maid.getY();
        this.z = maid.getZ();
        this.tickTimes = timeSecond * 20;
        this.volume = 4.0f;
        this.tick = 0;
    }

    public void tick() {
        ClientLevel world;
        if (this.maid.isRemoved()) {
            this.stop();
        }
        if (!(this.maid.getMaidBackpackType() instanceof MusicPlayerBackpack)) {
            this.stop();
        }
        if ((world = Minecraft.getInstance().level) == null) {
            this.stop();
            return;
        }
        ++this.tick;
        if (this.tick > this.tickTimes + 50) {
            this.stop();
        } else {
            this.x = this.maid.getX();
            this.y = this.maid.getY();
            this.z = this.maid.getZ();
            if (world.getGameTime() % 8L == 0L) {
                for (int i = 0; i < 2; ++i) {
                    world.addParticle((ParticleOptions)ParticleTypes.NOTE, this.x - 0.5 + world.random.nextDouble(), this.y + 1.5 + world.random.nextDouble(), this.z - 0.5 + world.random.nextDouble(), world.random.nextGaussian(), world.random.nextGaussian(), (double)world.random.nextInt(3));
                }
            }
        }
    }

    public CompletableFuture<AudioStream> getStream(SoundBufferLibrary soundBuffers, Sound sound, boolean looping) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return new NetMusicAudioStream(this.songUrl);
            }
            catch (IOException | UnsupportedAudioFileException e) {
                e.printStackTrace();
                return null;
            }
        }, Util.backgroundExecutor());
    }

    public int getMaidId() {
        return this.maid.getId();
    }

    public void setStop() {
        this.stop();
    }
}

