/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.compat.tlm.client.chatbubble;

import com.github.tartaricacid.netmusic.NetMusic;
import com.github.tartaricacid.netmusic.api.lyric.LyricParser;
import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.compat.tlm.chatbubble.LyricChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class LyricChatBubbleRenderer
implements IChatBubbleRenderer {
    private static final MutableComponent WAITING_TEXT = Component.translatable((String)"gui.netmusic.lyric.waiting");
    private static final MutableComponent NO_LYRIC_TEXT = Component.translatable((String)"gui.netmusic.lyric.no_lyric");
    private final Font font;
    private final ResourceLocation bg;
    private final long recordStartTick;
    @Nullable
    private volatile LyricRecord lyric;
    private volatile boolean isLoading = true;

    public LyricChatBubbleRenderer(LyricChatBubbleData data, ResourceLocation bg) {
        this.bg = bg;
        this.font = Minecraft.getInstance().font;
        this.recordStartTick = data.getStartTick();
        if (data.getSongId() > 0L) {
            CompletableFuture.supplyAsync(() -> {
                try {
                    String lyric = NetMusic.NET_EASE_WEB_API.lyric(data.getSongId());
                    LyricRecord lyricRecord = LyricParser.parseLyric(lyric, data.getSongName());
                    return lyricRecord;
                }
                catch (IOException e) {
                    NetMusic.LOGGER.error((Object)e);
                }
                finally {
                    this.isLoading = false;
                }
                return null;
            }).thenAccept(lyricRecord -> Minecraft.getInstance().execute(() -> {
                this.lyric = lyricRecord;
            }));
        } else {
            this.isLoading = false;
        }
    }

    public int getHeight() {
        Int2ObjectSortedMap<String> transLyrics;
        LyricRecord tmpLyric = this.lyric;
        if (tmpLyric == null) {
            return 12;
        }
        int maxHeight = 0;
        Int2ObjectSortedMap<String> lyrics = tmpLyric.getLyrics();
        if (lyrics != null && !lyrics.isEmpty()) {
            maxHeight += 12;
        }
        if ((transLyrics = tmpLyric.getTransLyrics()) != null && !transLyrics.isEmpty()) {
            maxHeight += 12;
        }
        return maxHeight;
    }

    public int getWidth() {
        Int2ObjectSortedMap<String> transLyrics;
        LyricRecord tmpLyric = this.lyric;
        if (tmpLyric == null) {
            if (this.isLoading) {
                return this.font.width((FormattedText)WAITING_TEXT);
            }
            return this.font.width((FormattedText)NO_LYRIC_TEXT);
        }
        int maxWidth = 0;
        Int2ObjectSortedMap<String> lyrics = tmpLyric.getLyrics();
        if (lyrics != null && !lyrics.isEmpty()) {
            maxWidth = this.font.width((String)lyrics.get(lyrics.firstIntKey()));
        }
        if ((transLyrics = tmpLyric.getTransLyrics()) != null && !transLyrics.isEmpty()) {
            maxWidth = Math.max(maxWidth, this.font.width((String)transLyrics.get(transLyrics.firstIntKey())));
        }
        return maxWidth;
    }

    public void render(EntityMaidRenderer renderer, EntityGraphics graphics) {
        LyricRecord tmpLyric = this.lyric;
        if (tmpLyric == null) {
            this.renderDefault(graphics);
            return;
        }
        Int2ObjectSortedMap<String> lyrics = tmpLyric.getLyrics();
        if (lyrics == null || lyrics.isEmpty()) {
            this.renderDefault(graphics);
            return;
        }
        if (this.recordStartTick < 0L) {
            this.renderDefault(graphics);
            return;
        }
        int currentTick = (int)(graphics.getMaid().level().getGameTime() - this.recordStartTick);
        tmpLyric.updateCurrentLine(currentTick);
        MutableComponent currentLyric = Component.literal((String)((String)lyrics.get(lyrics.firstIntKey())));
        MutableComponent transLyric = null;
        int currentLyricWidth = this.font.width((FormattedText)currentLyric);
        int transLyricWidth = 0;
        int currentLyricColor = 0xAAAAAA;
        int transLyricColor = 0;
        int y = 2;
        Int2ObjectSortedMap<String> transLyrics = tmpLyric.getTransLyrics();
        if (transLyrics != null && !transLyrics.isEmpty()) {
            transLyric = Component.literal((String)((String)transLyrics.get(transLyrics.firstIntKey())));
            transLyricWidth = this.font.width((FormattedText)transLyric);
            y += 12;
        } else {
            currentLyricColor = 0;
        }
        int maxWidth = Math.max(currentLyricWidth, transLyricWidth);
        graphics.drawWordWrap(this.font, (FormattedText)currentLyric, (maxWidth - currentLyricWidth) / 2, y, 1000, currentLyricColor);
        if (transLyric != null) {
            graphics.drawWordWrap(this.font, (FormattedText)transLyric, (maxWidth - transLyricWidth) / 2, y - 12, 1000, transLyricColor);
        }
    }

    public ResourceLocation getBackgroundTexture() {
        return this.bg;
    }

    private void renderDefault(EntityGraphics graphics) {
        if (this.isLoading) {
            graphics.drawWordWrap(this.font, (FormattedText)WAITING_TEXT, 0, 2, 1000, ChatFormatting.GRAY.getColor().intValue());
        } else {
            graphics.drawWordWrap(this.font, (FormattedText)NO_LYRIC_TEXT, 0, 2, 1000, ChatFormatting.GRAY.getColor().intValue());
        }
    }
}

