/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.inventory;

import com.github.tartaricacid.netmusic.init.InitItems;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ComputerMenu
extends AbstractContainerMenu {
    public static final MenuType<ComputerMenu> TYPE = IMenuTypeExtension.create((windowId, inv, data) -> new ComputerMenu(windowId, inv));
    private final ItemStackHandler input = new ItemStackHandler(this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.getItem() == InitItems.MUSIC_CD.get();
        }
    };
    private final ItemStackHandler output = new ItemStackHandler(this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }
    };
    private ItemMusicCD.SongInfo songInfo;

    public ComputerMenu(int id, Inventory inventory) {
        super(TYPE, id);
        int i;
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.input, 0, 147, 14));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.output, 0, 147, 79));
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 192));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 134 + i * 18));
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            itemStack = slotItem.copy();
            if (index < 2 ? !this.moveItemStackTo(slotItem, 2, this.slots.size(), false) : !this.moveItemStackTo(slotItem, 0, 2, true)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.input.getStackInSlot(0));
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.output.getStackInSlot(0));
    }

    public void setSongInfo(ItemMusicCD.SongInfo setSongInfo) {
        this.songInfo = setSongInfo;
        if (!this.input.getStackInSlot(0).isEmpty() && this.output.getStackInSlot(0).isEmpty()) {
            ItemStack itemStack = this.input.extractItem(0, 1, false);
            ItemMusicCD.SongInfo rawSongInfo = ItemMusicCD.getSongInfo(itemStack);
            if (rawSongInfo == null || !rawSongInfo.readOnly) {
                ItemMusicCD.setSongInfo(this.songInfo, itemStack);
            }
            this.output.setStackInSlot(0, itemStack);
        }
    }

    public ItemStackHandler getInput() {
        return this.input;
    }
}

